/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.beans.ContainerFactory;
import com.sun.star.comp.beans.LocalOfficeWindow;
import com.sun.star.comp.beans.NativeService;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private Process mProcess;
    private XComponentContext mContext;
    private XBridge mBridge;
    private String mURL;
    private String mConnType;
    private String mPipe;
    private String mPort;
    private String mProtocol;
    private String mInitialObject;
    private final List<XEventListener> mComponents = new ArrayList<XEventListener>();
    private static final AtomicLong m_nBridgeCounter = new AtomicLong(0L);

    public LocalOfficeConnection() {
        try {
            this.setUnoUrl("uno:pipe,name=" + LocalOfficeConnection.getPipeName() + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException malformedURLException) {
            throw new com.sun.star.uno.RuntimeException((Throwable)malformedURLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new com.sun.star.uno.RuntimeException((Throwable)unsupportedEncodingException);
        }
    }

    protected LocalOfficeConnection(XComponentContext xComponentContext) {
        this.mContext = xComponentContext;
    }

    @Override
    public void setUnoUrl(String string) throws MalformedURLException {
        this.mURL = null;
        String string2 = "uno:localoffice";
        if (string.startsWith(string2)) {
            this.parseUnoUrlWithOfficePath(string, string2);
        } else {
            try {
                UnoUrl unoUrl = UnoUrl.parseUnoUrl((String)string);
                this.mConnType = unoUrl.getConnection();
                this.mPipe = (String)unoUrl.getConnectionParameters().get("pipe");
                this.mPort = (String)unoUrl.getConnectionParameters().get("port");
                this.mProtocol = unoUrl.getProtocol();
                this.mInitialObject = unoUrl.getRootOid();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MalformedURLException malformedURLException = new MalformedURLException("Invalid UNO connection URL.");
                malformedURLException.initCause(illegalArgumentException);
                throw malformedURLException;
            }
        }
        this.mURL = string;
    }

    @Override
    @Deprecated
    public void setContainerFactory(ContainerFactory containerFactory) {
    }

    @Override
    public synchronized XComponentContext getComponentContext() {
        if (this.mContext == null) {
            this.mContext = this.connect();
        }
        return this.mContext;
    }

    @Override
    @Deprecated
    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator<XEventListener> iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().disposing(null);
            }
            catch (RuntimeException runtimeException) {}
        }
        this.mComponents.clear();
        if (this.mBridge != null) {
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.mBridge);
            if (xComponent != null) {
                xComponent.dispose();
            } else {
                System.err.println("LocalOfficeConnection: could not dispose bridge!");
            }
            this.mBridge = null;
        }
        this.mContext = null;
    }

    public void addEventListener(XEventListener xEventListener) {
        this.mComponents.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.mComponents.remove(xEventListener);
    }

    private XComponentContext connect() {
        try {
            Object object;
            XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
            xComponentContext.getServiceManager();
            Object object2 = null;
            try {
                object2 = this.resolve(xComponentContext, this.mURL);
            }
            catch (NoConnectException noConnectException) {
                object = new OfficeService();
                ((OfficeService)object).startupService();
                long l = System.currentTimeMillis() + 1000L * (long)((OfficeService)object).getStartupTime();
                while (object2 == null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        object2 = this.resolve(xComponentContext, this.mURL);
                    }
                    catch (NoConnectException noConnectException2) {
                        if (System.currentTimeMillis() <= l) continue;
                        throw noConnectException2;
                    }
                }
            }
            if (null != object2) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object2);
                object = xPropertySet.getPropertyValue("DefaultContext");
                XComponentContext xComponentContext2 = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object);
                return xComponentContext2;
            }
        }
        catch (NoConnectException noConnectException) {
            System.out.println("Couldn't connect to remote server");
            System.out.println(noConnectException.getMessage());
        }
        catch (ConnectionSetupException connectionSetupException) {
            System.out.println("Couldn't access necessary local resource to establish the interprocess connection");
            System.out.println(connectionSetupException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("uno-url is syntactical illegal ( " + this.mURL + " )");
            System.out.println(illegalArgumentException.getMessage());
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            System.out.println("--- RuntimeException:");
            System.out.println(runtimeException.getMessage());
            runtimeException.printStackTrace();
            System.out.println("--- end.");
            throw runtimeException;
        }
        catch (Exception exception) {
            System.out.println("java.lang.Exception: ");
            System.out.println(exception);
            exception.printStackTrace();
            System.out.println("--- end.");
            throw new com.sun.star.uno.RuntimeException((Throwable)exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolve(XComponentContext xComponentContext, String string) throws NoConnectException, ConnectionSetupException, IllegalArgumentException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string.indexOf(59) == -1) {
            string2 = string;
            string3 = "iiop";
            string4 = "classic_uno";
        } else {
            int n = string.indexOf(58);
            string = string.substring(n + 1).trim();
            n = string.indexOf(59);
            string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            n = string.indexOf(59);
            string3 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            string4 = string.trim().trim();
        }
        Object object = null;
        XBridgeFactory xBridgeFactory = null;
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        try {
            xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", xComponentContext));
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new com.sun.star.uno.RuntimeException((Throwable)exception);
        }
        LocalOfficeConnection localOfficeConnection = this;
        synchronized (localOfficeConnection) {
            if (this.mBridge == null) {
                Object object2 = null;
                try {
                    object2 = xMultiComponentFactory.createInstanceWithContext("com.sun.star.connection.Connector", xComponentContext);
                }
                catch (com.sun.star.uno.Exception exception) {
                    throw new com.sun.star.uno.RuntimeException((Throwable)exception);
                }
                XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)object2);
                XConnection xConnection = xConnector.connect(string2);
                String string5 = "OOoBean_private_bridge_" + m_nBridgeCounter.getAndIncrement();
                try {
                    this.mBridge = xBridgeFactory.createBridge(string5, string3, xConnection, null);
                }
                catch (BridgeExistsException bridgeExistsException) {
                    throw new com.sun.star.uno.RuntimeException((Throwable)bridgeExistsException);
                }
            }
            object = this.mBridge.getInstance(string4);
            return object;
        }
    }

    private void parseUnoUrlWithOfficePath(String string, String string2) throws MalformedURLException {
        int n = string.indexOf(";urp;StarOffice.ServiceManager");
        if (n < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String string3 = string.substring(string2.length(), n + 1);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block35: for (n = 0; n < string3.length(); ++n) {
            char c = string3.charAt(n);
            switch (n2) {
                case 0: {
                    switch (c) {
                        case ',': {
                            stringBuffer.delete(0, stringBuffer.length());
                            n2 = 1;
                            continue block35;
                        }
                        case ';': {
                            n2 = 7;
                            continue block35;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    continue block35;
                }
                case 1: {
                    switch (c) {
                        case ' ': 
                        case '=': {
                            string4 = stringBuffer.toString();
                            n2 = c == ' ' ? 2 : 3;
                            continue block35;
                        }
                        case ',': 
                        case ';': {
                            n2 = -6;
                            continue block35;
                        }
                    }
                    stringBuffer.append(c);
                    continue block35;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            n2 = 3;
                            continue block35;
                        }
                        case ' ': {
                            continue block35;
                        }
                    }
                    n2 = -1;
                    continue block35;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 4;
                    continue block35;
                }
                case 4: {
                    switch (c) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --n;
                            n2 = 5;
                            if (string4.equals("path")) {
                                if (string5 == null) {
                                    string5 = stringBuffer.toString();
                                } else {
                                    n2 = -3;
                                }
                            } else if (string4.equals("pipe")) {
                                if (string6 == null) {
                                    string6 = stringBuffer.toString();
                                } else {
                                    n2 = -4;
                                }
                            } else {
                                n2 = -2;
                            }
                            stringBuffer.delete(0, stringBuffer.length());
                            continue block35;
                        }
                    }
                    stringBuffer.append(c);
                    continue block35;
                }
                case 5: {
                    switch (c) {
                        case ' ': {
                            continue block35;
                        }
                        case ',': {
                            n2 = 6;
                            continue block35;
                        }
                        case ';': {
                            n2 = 7;
                            continue block35;
                        }
                    }
                    n2 = -5;
                    continue block35;
                }
                case 6: {
                    switch (c) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    continue block35;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
        }
        if (n2 != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (string6 != null) {
            this.mPipe = string6;
        }
    }

    private static String getPipeName() throws UnsupportedEncodingException {
        String string = System.getProperty("user.name") + OFFICE_ID_SUFFIX;
        string = string.replace("_", "%B7");
        return URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%", "_");
    }

    static {
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr70");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find msvcr70");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr71");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find msvcr71");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"jawt");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find jawt:");
                throwable.printStackTrace();
            }
        }
        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)OFFICE_LIB_NAME);
    }

    private static class StreamProcessor
    extends Thread {
        private final InputStream m_in;
        private final PrintStream m_print;

        public StreamProcessor(InputStream inputStream, PrintStream printStream) {
            super("StreamProcessor");
            this.m_in = inputStream;
            this.m_print = printStream;
            this.start();
        }

        @Override
        public void run() {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_in, "UTF-8"));
                while ((string = bufferedReader.readLine()) != null) {
                    this.m_print.println(string);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace(System.err);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private class OfficeService
    implements NativeService {
        private OfficeService() {
        }

        @Override
        public String getIdentifier() {
            String string = null;
            try {
                string = LocalOfficeConnection.this.mPipe == null ? LocalOfficeConnection.getPipeName() : LocalOfficeConnection.this.mPipe;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new com.sun.star.uno.RuntimeException((Throwable)unsupportedEncodingException);
            }
            return string;
        }

        @Override
        public void startupService() throws IOException {
            int n = 4;
            String string = null;
            try {
                string = System.getProperty("com.sun.star.officebean.Options");
                if (string != null) {
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            Object[] objectArray = new String[n];
            String string2 = System.getenv("UNO_PATH");
            if (string2 == null) {
                throw new IOException("UNO_PATH environment variable is not set (required system path to the office program directory)");
            }
            objectArray[0] = new File(string2, LocalOfficeConnection.OFFICE_APP_NAME).getPath();
            objectArray[1] = "--nologo";
            objectArray[2] = "--nodefault";
            if (LocalOfficeConnection.this.mConnType.equals("pipe")) {
                objectArray[3] = "--accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.this.mProtocol + ";" + LocalOfficeConnection.this.mInitialObject;
            } else if (LocalOfficeConnection.this.mConnType.equals("socket")) {
                objectArray[3] = "--accept=socket,port=" + LocalOfficeConnection.this.mPort + ";urp";
            } else {
                throw new IOException("not connection specified");
            }
            if (string != null) {
                objectArray[4] = string;
            }
            LocalOfficeConnection.this.mProcess = Runtime.getRuntime().exec((String[])objectArray);
            if (LocalOfficeConnection.this.mProcess == null) {
                throw new com.sun.star.uno.RuntimeException("cannot start soffice: " + Arrays.toString(objectArray));
            }
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getInputStream(), System.out);
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getErrorStream(), System.err);
        }

        @Override
        public int getStartupTime() {
            return 60;
        }
    }
}

