'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSocket = undefined;

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

// timeout in ms

var createSocket = exports.createSocket = function () {
  var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee(basePath, functionsRegistry) {
    return _regenerator2.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt('return', new Promise(function (resolve, reject) {
              var socket = (0, _socket2.default)({
                path: basePath + '/socket.io',
                transports: ['polling', 'websocket'],
                transportOptions: {
                  polling: {
                    extraHeaders: {
                      'kbn-xsrf': 'professionally-crafted-string-of-text'
                    }
                  }
                },
                timeout: SOCKET_CONNECTION_TIMEOUT,
                // ensure socket.io always tries polling first, otherwise auth will fail
                rememberUpgrade: false
              });

              socket.on('getFunctionList', function () {
                socket.emit('functionList', functionsRegistry.toJS());
              });

              socket.on('connect', function () {
                resolve(socket);
                socket.off('connectionFailed', errorHandler);
                socket.off('connect_error', errorHandler);
                socket.off('connect_timeout', errorHandler);
              });

              function errorHandler(err) {
                // 'connectionFailed' returns an object with a reason prop
                // other error cases provide their own error
                reject(err.reason ? new Error(err.reason) : err);
              }

              socket.on('connectionFailed', errorHandler);
              socket.on('connect_error', errorHandler);
              socket.on('connect_timeout', errorHandler);
            }));

          case 1:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function createSocket(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var _socket = require('socket.io-client');

var _socket2 = _interopRequireDefault(_socket);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SOCKET_CONNECTION_TIMEOUT = 5000; /*
                                       * Licensed to Elasticsearch B.V. under one or more contributor
                                       * license agreements. See the NOTICE file distributed with
                                       * this work for additional information regarding copyright
                                       * ownership. Elasticsearch B.V. licenses this file to you under
                                       * the Apache License, Version 2.0 (the "License"); you may
                                       * not use this file except in compliance with the License.
                                       * You may obtain a copy of the License at
                                       *
                                       *    http://www.apache.org/licenses/LICENSE-2.0
                                       *
                                       * Unless required by applicable law or agreed to in writing,
                                       * software distributed under the License is distributed on an
                                       * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                       * KIND, either express or implied.  See the License for the
                                       * specific language governing permissions and limitations
                                       * under the License.
                                       */