/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.jd.core.v1.model.javasyntax.type.PrimitiveType;

public class PrimitiveTypeUtil {
    protected static final PrimitiveType[] descriptorToPrimitiveType = new PrimitiveType[25];

    public static PrimitiveType getPrimitiveTypeFromDescriptor(String descriptor) {
        int dimension = 0;
        while (descriptor.charAt(dimension) == '[') {
            ++dimension;
        }
        return descriptorToPrimitiveType[descriptor.charAt(dimension) - 66].createType(dimension);
    }

    public static PrimitiveType getPrimitiveTypeFromValue(int value) {
        if (value >= 0) {
            if (value <= 1) {
                return PrimitiveType.MAYBE_BOOLEAN_TYPE;
            }
            if (value <= 127) {
                return PrimitiveType.MAYBE_BYTE_TYPE;
            }
            if (value <= Short.MAX_VALUE) {
                return PrimitiveType.MAYBE_SHORT_TYPE;
            }
            if (value <= 65535) {
                return PrimitiveType.MAYBE_CHAR_TYPE;
            }
        } else {
            if (value >= -128) {
                return PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
            }
            if (value >= Short.MIN_VALUE) {
                return PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
            }
        }
        return PrimitiveType.MAYBE_INT_TYPE;
    }

    public static int getStandardPrimitiveTypeFlags(int flags) {
        if ((flags & 1) != 0) {
            return 1;
        }
        if ((flags & 0x10) != 0) {
            return 16;
        }
        if ((flags & 2) != 0) {
            return 2;
        }
        if ((flags & 0x20) != 0) {
            return 32;
        }
        return flags;
    }

    public static PrimitiveType getPrimitiveType(int flags, int dimension) {
        PrimitiveType type = PrimitiveTypeUtil.getPrimitiveType(flags);
        if (type == null) {
            type = PrimitiveType.TYPE_INT;
        }
        return type.createType(dimension);
    }

    public static PrimitiveType getCommonPrimitiveType(PrimitiveType pt1, PrimitiveType pt2) {
        assert (pt1.getDimension() == 0 && pt2.getDimension() == 0);
        return PrimitiveTypeUtil.getPrimitiveType(pt1.getFlags() & pt2.getFlags());
    }

    protected static PrimitiveType getPrimitiveType(int flags) {
        switch (flags) {
            case 1: {
                return PrimitiveType.TYPE_BOOLEAN;
            }
            case 2: {
                return PrimitiveType.TYPE_CHAR;
            }
            case 4: {
                return PrimitiveType.TYPE_FLOAT;
            }
            case 8: {
                return PrimitiveType.TYPE_DOUBLE;
            }
            case 16: {
                return PrimitiveType.TYPE_BYTE;
            }
            case 32: {
                return PrimitiveType.TYPE_SHORT;
            }
            case 64: {
                return PrimitiveType.TYPE_INT;
            }
            case 128: {
                return PrimitiveType.TYPE_LONG;
            }
            case 256: {
                return PrimitiveType.TYPE_VOID;
            }
        }
        if (flags == 66) {
            return PrimitiveType.MAYBE_CHAR_TYPE;
        }
        if (flags == 98) {
            return PrimitiveType.MAYBE_SHORT_TYPE;
        }
        if (flags == 114) {
            return PrimitiveType.MAYBE_BYTE_TYPE;
        }
        if (flags == 115) {
            return PrimitiveType.MAYBE_BOOLEAN_TYPE;
        }
        if (flags == 112) {
            return PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
        }
        if (flags == 96) {
            return PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
        }
        if (flags == 113) {
            return PrimitiveType.MAYBE_NEGATIVE_BOOLEAN_TYPE;
        }
        return null;
    }

    static {
        PrimitiveTypeUtil.descriptorToPrimitiveType[0] = PrimitiveType.TYPE_BYTE;
        PrimitiveTypeUtil.descriptorToPrimitiveType[1] = PrimitiveType.TYPE_CHAR;
        PrimitiveTypeUtil.descriptorToPrimitiveType[2] = PrimitiveType.TYPE_DOUBLE;
        PrimitiveTypeUtil.descriptorToPrimitiveType[4] = PrimitiveType.TYPE_FLOAT;
        PrimitiveTypeUtil.descriptorToPrimitiveType[7] = PrimitiveType.TYPE_INT;
        PrimitiveTypeUtil.descriptorToPrimitiveType[8] = PrimitiveType.TYPE_LONG;
        PrimitiveTypeUtil.descriptorToPrimitiveType[17] = PrimitiveType.TYPE_SHORT;
        PrimitiveTypeUtil.descriptorToPrimitiveType[24] = PrimitiveType.TYPE_BOOLEAN;
    }
}

