/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;

public class GenericType
implements Type {
    protected String identifier;
    protected int dimension;

    public GenericType(String identifier, int dimension) {
        this.identifier = identifier;
        this.dimension = dimension;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public String getDescriptor() {
        return this.identifier;
    }

    @Override
    public Type createType(int dimension) {
        assert (dimension >= 0);
        if (this.dimension == dimension) {
            return this;
        }
        return new GenericType(this.identifier, dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericType that = (GenericType)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + this.dimension;
        return result;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    public String toString() {
        return "GenericType{" + this.identifier + "}";
    }
}

