/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.statement;

import java.util.List;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.util.DefaultList;

public class TryStatement
implements Statement {
    protected List<Resource> resources;
    protected BaseStatement tryStatements;
    protected List<CatchClause> catchClauses;
    protected BaseStatement finallyStatements;

    public TryStatement(BaseStatement tryStatements, List<CatchClause> catchClauses, BaseStatement finallyStatements) {
        this.resources = null;
        this.tryStatements = tryStatements;
        this.catchClauses = catchClauses;
        this.finallyStatements = finallyStatements;
    }

    public TryStatement(List<Resource> resources, BaseStatement tryStatements, List<CatchClause> catchClauses, BaseStatement finallyStatements) {
        this.resources = resources;
        this.tryStatements = tryStatements;
        this.catchClauses = catchClauses;
        this.finallyStatements = finallyStatements;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public BaseStatement getTryStatements() {
        return this.tryStatements;
    }

    public void setTryStatements(BaseStatement tryStatements) {
        this.tryStatements = tryStatements;
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    public BaseStatement getFinallyStatements() {
        return this.finallyStatements;
    }

    public void setFinallyStatements(BaseStatement finallyStatements) {
        this.finallyStatements = finallyStatements;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    public static class CatchClause
    implements Statement {
        protected int lineNumber;
        protected ObjectType type;
        protected DefaultList<ObjectType> otherTypes = null;
        protected String name;
        protected BaseStatement statements;

        public CatchClause(int lineNumber, ObjectType type, String name, BaseStatement statements) {
            this.lineNumber = lineNumber;
            this.type = type;
            this.name = name;
            this.statements = statements;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public ObjectType getType() {
            return this.type;
        }

        public DefaultList<ObjectType> getOtherTypes() {
            return this.otherTypes;
        }

        public String getName() {
            return this.name;
        }

        public BaseStatement getStatements() {
            return this.statements;
        }

        public void addType(ObjectType type) {
            if (this.otherTypes == null) {
                this.otherTypes = new DefaultList();
            }
            this.otherTypes.add(type);
        }

        @Override
        public void accept(StatementVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Resource
    implements Statement {
        protected ObjectType type;
        protected String name;
        protected Expression expression;

        public Resource(ObjectType type, String name, Expression expression) {
            this.type = type;
            this.name = name;
            this.expression = expression;
        }

        public ObjectType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        @Override
        public void accept(StatementVisitor visitor) {
            visitor.visit(this);
        }
    }
}

