/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dx.io.instructions.DecodedInstruction;
import com.rits.cloning.Cloner;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class InsnNode
extends LineAttrNode {
    private static final Cloner INSN_CLONER = new Cloner();
    protected final InsnType insnType;
    private RegisterArg result;
    private final List<InsnArg> arguments;
    protected int offset;

    public InsnNode(InsnType type, int argsCount) {
        this.insnType = type;
        this.offset = -1;
        this.arguments = argsCount == 0 ? Collections.emptyList() : new ArrayList<InsnArg>(argsCount);
    }

    public static InsnNode wrapArg(InsnArg arg) {
        InsnNode insn = new InsnNode(InsnType.ONE_ARG, 1);
        insn.addArg(arg);
        return insn;
    }

    public void setResult(@Nullable RegisterArg res) {
        if (res != null) {
            res.setParentInsn(this);
            SSAVar ssaVar = res.getSVar();
            if (ssaVar != null) {
                ssaVar.setAssign(res);
            }
        }
        this.result = res;
    }

    public void addArg(InsnArg arg) {
        this.arguments.add(arg);
        this.attachArg(arg);
    }

    public void setArg(int n, InsnArg arg) {
        this.arguments.set(n, arg);
        this.attachArg(arg);
    }

    private void attachArg(InsnArg arg) {
        RegisterArg reg;
        SSAVar ssaVar;
        arg.setParentInsn(this);
        if (arg.isRegister() && (ssaVar = (reg = (RegisterArg)arg).getSVar()) != null) {
            ssaVar.use(reg);
        }
    }

    public InsnType getType() {
        return this.insnType;
    }

    public RegisterArg getResult() {
        return this.result;
    }

    public Iterable<InsnArg> getArguments() {
        return this.arguments;
    }

    public int getArgsCount() {
        return this.arguments.size();
    }

    public InsnArg getArg(int n) {
        return this.arguments.get(n);
    }

    public boolean containsArg(RegisterArg arg) {
        for (InsnArg a : this.arguments) {
            if (a != arg && (!a.isRegister() || ((RegisterArg)a).getRegNum() != arg.getRegNum())) continue;
            return true;
        }
        return false;
    }

    public boolean replaceArg(InsnArg from, InsnArg to) {
        int count = this.getArgsCount();
        for (int i = 0; i < count; ++i) {
            InsnArg arg = this.arguments.get(i);
            if (arg == from) {
                InsnRemover.unbindArgUsage(null, arg);
                this.setArg(i, to);
                return true;
            }
            if (!arg.isInsnWrap() || !((InsnWrapArg)arg).getWrapInsn().replaceArg(from, to)) continue;
            return true;
        }
        return false;
    }

    protected boolean removeArg(InsnArg arg) {
        int index = this.getArgIndex(arg);
        if (index == -1) {
            return false;
        }
        this.removeArg(index);
        return true;
    }

    protected InsnArg removeArg(int index) {
        InsnArg arg = this.arguments.get(index);
        this.arguments.remove(index);
        InsnRemover.unbindArgUsage(null, arg);
        return arg;
    }

    protected int getArgIndex(InsnArg arg) {
        int count = this.getArgsCount();
        for (int i = 0; i < count; ++i) {
            if (arg != this.arguments.get(i)) continue;
            return i;
        }
        return -1;
    }

    protected void addReg(DecodedInstruction insn, int i, ArgType type) {
        this.addArg(InsnArg.reg(insn, i, type));
    }

    protected void addReg(int regNum, ArgType type) {
        this.addArg(InsnArg.reg(regNum, type));
    }

    protected void addLit(long literal, ArgType type) {
        this.addArg(InsnArg.lit(literal, type));
    }

    protected void addLit(DecodedInstruction insn, ArgType type) {
        this.addArg(InsnArg.lit(insn, type));
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void getRegisterArgs(Collection<RegisterArg> collection) {
        for (InsnArg arg : this.getArguments()) {
            if (arg.isRegister()) {
                collection.add((RegisterArg)arg);
                continue;
            }
            if (!arg.isInsnWrap()) continue;
            ((InsnWrapArg)arg).getWrapInsn().getRegisterArgs(collection);
        }
    }

    public boolean isConstInsn() {
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: {
                return true;
            }
        }
        return false;
    }

    public boolean canReorder() {
        if (this.contains(AFlag.DONT_GENERATE)) {
            return this.getType() != InsnType.MONITOR_EXIT;
        }
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: 
            case CAST: 
            case MOVE: 
            case ARITH: 
            case NEG: 
            case CMP_L: 
            case CMP_G: 
            case CHECK_CAST: 
            case INSTANCE_OF: 
            case FILL_ARRAY: 
            case FILLED_NEW_ARRAY: 
            case NEW_ARRAY: 
            case NEW_MULTIDIM_ARRAY: 
            case STR_CONCAT: {
                return true;
            }
        }
        return false;
    }

    public boolean canReorderRecursive() {
        if (!this.canReorder()) {
            return false;
        }
        for (InsnArg arg : this.getArguments()) {
            InsnNode wrapInsn;
            if (!arg.isInsnWrap() || (wrapInsn = ((InsnWrapArg)arg).getWrapInsn()).canReorderRecursive()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": " + InsnUtils.insnTypeToString(this.insnType) + (this.result == null ? "" : this.result + " = ") + Utils.listToString(this.arguments);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean isSame(InsnNode other) {
        if (this == other) {
            return true;
        }
        if (this.insnType != other.insnType) {
            return false;
        }
        int size = this.arguments.size();
        if (size != other.arguments.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            InsnNode otherWrapInsn;
            InsnArg arg = this.arguments.get(i);
            InsnArg otherArg = other.arguments.get(i);
            if (!arg.isInsnWrap()) continue;
            if (!otherArg.isInsnWrap()) {
                return false;
            }
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            if (wrapInsn.isSame(otherWrapInsn = ((InsnWrapArg)otherArg).getWrapInsn())) continue;
            return false;
        }
        return true;
    }

    public boolean isDeepEquals(InsnNode other) {
        if (this == other) {
            return true;
        }
        return this.isSame(other) && Objects.equals(this.result, other.result) && Objects.equals(this.arguments, other.arguments);
    }

    protected <T extends InsnNode> T copyCommonParams(T copy) {
        copy.setResult(this.result);
        if (copy.getArgsCount() == 0) {
            for (InsnArg arg : this.getArguments()) {
                if (arg.isInsnWrap()) {
                    InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
                    copy.addArg(InsnArg.wrapArg(wrapInsn.copy()));
                    continue;
                }
                copy.addArg(arg);
            }
        }
        copy.copyAttributesFrom(this);
        copy.copyLines(this);
        copy.setOffset(this.getOffset());
        return copy;
    }

    public InsnNode copy() {
        if (this.getClass() == InsnNode.class) {
            return this.copyCommonParams(new InsnNode(this.insnType, this.getArgsCount()));
        }
        return (InsnNode)INSN_CLONER.deepClone((Object)this);
    }

    public boolean canThrowException() {
        switch (this.getType()) {
            case CONST: 
            case CONST_STR: 
            case CONST_CLASS: 
            case MOVE: 
            case NEG: 
            case CMP_L: 
            case CMP_G: 
            case RETURN: 
            case IF: 
            case GOTO: 
            case MOVE_EXCEPTION: {
                return false;
            }
        }
        return true;
    }

    static {
        INSN_CLONER.dontClone(new Class[]{ArgType.class, SSAVar.class, LiteralArg.class, NamedArg.class});
        INSN_CLONER.dontCloneInstanceOf(new Class[]{RegisterArg.class});
    }
}

