/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.util.xml.NanoXmlBuilder;
import org.intellij.lang.xpath.context.XPathVersion;

public class XsltChecker
implements NanoXmlBuilder {
    private State myState;

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
        this.myState = ("stylesheet".equals(name) || "transform".equals(name)) && "http://www.w3.org/1999/XSL/Transform".equals(nsURI) ? State.POSSIBLY : State.POSSIBLY_SIMPLIFIED_SYNTAX;
    }

    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        if (this.myState == State.POSSIBLY) {
            if ("version".equals(key) && (nsURI == null || nsURI.length() == 0)) {
                this.checkVersion(value, State.YES);
                NanoXmlBuilder.stop();
            }
        } else if (this.myState == State.POSSIBLY_SIMPLIFIED_SYNTAX && "version".equals(key) && "http://www.w3.org/1999/XSL/Transform".equals(nsURI)) {
            this.checkVersion(value, State.SIMPLIFIED);
            NanoXmlBuilder.stop();
        }
    }

    private void checkVersion(String value, State yes) {
        this.myState = XsltChecker.isVersion1(value) ? yes : (XsltChecker.isVersion2(value) ? State.VERSION2 : State.NO);
    }

    public static boolean isSupportedVersion(String value) {
        return XsltChecker.isVersion1(value) || XsltChecker.isVersion2(value);
    }

    public static boolean isVersion1(String value) {
        return "1.0".equals(value) || "1.1".equals(value);
    }

    public static boolean isVersion2(String value) {
        return "2.0".equals(value);
    }

    public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
        NanoXmlBuilder.stop();
    }

    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        NanoXmlBuilder.stop();
    }

    public boolean isFullySupportedXsltFile() {
        return this.myState == State.YES || this.myState == State.SIMPLIFIED;
    }

    public boolean isSimplifiedSyntax() {
        return this.myState == State.SIMPLIFIED;
    }

    public static LanguageLevel getLanguageLevel(String value) {
        if (value == null) {
            return LanguageLevel.NONE;
        }
        if (XsltChecker.isVersion1(value)) {
            return LanguageLevel.V1;
        }
        if (XsltChecker.isVersion2(value)) {
            return LanguageLevel.V2;
        }
        return LanguageLevel.NONE;
    }

    public LanguageLevel getLanguageLevel() {
        return this.myState == State.VERSION2 ? LanguageLevel.V2 : (this.isFullySupportedXsltFile() ? LanguageLevel.V1 : LanguageLevel.NONE);
    }

    static enum State {
        YES,
        SIMPLIFIED,
        NO,
        POSSIBLY,
        POSSIBLY_SIMPLIFIED_SYNTAX,
        VERSION2;

    }

    public static enum LanguageLevel {
        NONE(null),
        V1(XPathVersion.V1),
        V2(XPathVersion.V2);

        private final XPathVersion myVersion;

        private LanguageLevel(XPathVersion version) {
            this.myVersion = version;
        }

        public XPathVersion getXPathVersion() {
            return this.myVersion;
        }
    }
}

