/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.Compatibility;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.java_lang_Class;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.KlassArray;

class CompatibilityHelper10
implements Compatibility {
    private static final long compressedKlassOffset;
    private static final long klassOffset;

    CompatibilityHelper10() {
    }

    @Override
    public Address getAddress(Method method) {
        return method.getAddress();
    }

    @Override
    public Address getAddress(Klass klass) {
        return klass.getAddress();
    }

    @Override
    public Klass asKlass(Oop ref) {
        return java_lang_Class.asKlass((Oop)ref);
    }

    @Override
    public List<InstanceKlass> getTransitiveInterfaces(InstanceKlass saKlass) {
        ArrayList<InstanceKlass> res = new ArrayList<InstanceKlass>();
        KlassArray interfaces = saKlass.getTransitiveInterfaces();
        int n = interfaces.length();
        for (int i = 0; i < n; ++i) {
            res.add((InstanceKlass)interfaces.getAt(i));
        }
        return res;
    }

    @Override
    public String getSourceDebugExtension(InstanceKlass saKlass) {
        return saKlass.getSourceDebugExtension();
    }

    @Override
    public InstanceKlass getMethodHandleKlass() {
        return SystemDictionary.getMethodHandleKlass();
    }

    @Override
    public Klass getMethodHolder(Method method) {
        return method.getMethodHolder();
    }

    @Override
    public Address getKlassAddress(Oop oop) {
        if (VM.getVM().isCompressedKlassPointersEnabled()) {
            return oop.getHandle().getCompKlassAddressAt(compressedKlassOffset);
        }
        return oop.getHandle().getAddressAt(klassOffset);
    }

    @Override
    public List<Klass> allClasses(SystemDictionary systemDictionary, VM vm) {
        ArrayList<Klass> saKlasses = new ArrayList<Klass>();
        vm.getClassLoaderDataGraph().classesDo(k -> {
            if (k instanceof ArrayKlass) {
                saKlasses.add(k);
            } else {
                int status = k.getClassStatus();
                if ((status & 2) != 0) {
                    saKlasses.add(k);
                }
            }
        });
        return saKlasses;
    }

    @Override
    public List<ReferenceTypeImpl> visibleClasses(Oop ref, VirtualMachineImpl vm) {
        ArrayList<ReferenceTypeImpl> res = new ArrayList<ReferenceTypeImpl>();
        vm.saVM().getClassLoaderDataGraph().allEntriesDo((k, loader) -> {
            if (ref.equals((Object)loader)) {
                res.add(vm.referenceType(k));
            }
        });
        return res;
    }

    static {
        long coff = -1L;
        long koff = -1L;
        try {
            Field field = Oop.class.getDeclaredField("klass");
            field.setAccessible(true);
            coff = ((MetadataField)field.get(null)).getOffset();
            Field field1 = Oop.class.getDeclaredField("compressedKlass");
            field1.setAccessible(true);
            koff = ((MetadataField)field1.get(null)).getOffset();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        compressedKlassOffset = coff;
        klassOffset = koff;
    }
}

