/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import icons.XsltDebuggerIcons;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.intellij.plugins.xsltDebugger.ui.GeneratedStructureModel;

class GeneratedStructureRenderer
extends ColoredTreeCellRenderer {
    GeneratedStructureRenderer() {
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object o = node.getUserObject();
        this.setToolTipText(null);
        if (o != null && !"ROOT".equals(o)) {
            if (o instanceof String) {
                this.append((String)o, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                this.setToolTipText("Element is not finished yet");
            } else if (o instanceof OutputEventQueue.NodeEvent) {
                OutputEventQueue.NodeEvent event = (OutputEventQueue.NodeEvent)o;
                OutputEventQueue.NodeEvent.QName qname = event.getQName();
                switch (event.getType()) {
                    case 1: {
                        this.setIcon(PlatformIcons.XML_TAG_ICON);
                        this.append(qname.getQName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        if (qname.myURI == null || qname.myURI.length() <= 0) break;
                        this.append(" {", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(qname.myURI, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("}", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        break;
                    }
                    case 3: {
                        this.setIcon(PlatformIcons.ANNOTATION_TYPE_ICON);
                        this.append(qname.getQName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        if (qname.myURI != null && qname.myURI.length() > 0) {
                            this.append(" {" + qname.myURI + "}", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        this.append(" = \"", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append(event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append("\"", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 4: {
                        this.append("#text ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(GeneratedStructureRenderer.clipValue(event.getValue()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 5: {
                        this.setIcon(XsltDebuggerIcons.XmlComment);
                        this.append("#comment ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 6: {
                        this.append("#processing-instruction ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(qname.myLocalName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.append(" " + event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        break;
                    }
                    case 20: {
                        this.setIcon(AllIcons.Debugger.Db_set_breakpoint);
                        this.append("Tracepoint at line " + event.getLineNumber(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        if (event.getValue() == null) break;
                        this.append(" " + event.getValue(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                if (node instanceof GeneratedStructureModel.StructureNode && ((GeneratedStructureModel.StructureNode)node).isNew()) {
                    this.append(" *", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                }
            }
        }
    }

    static String clipValue(String stringValue) {
        return stringValue.length() < 80 ? stringValue : stringValue.substring(0, 80) + "...";
    }
}

