/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import java.util.BitSet;

public class PsiRawStringLiteralUtil {
    public static String getAdditionalTicks(String text, String tics) {
        int quotesLength = tics.length();
        int textLength = text.length();
        int idx = 0;
        int maxQuotesNumber = -1;
        boolean hasToReplace = false;
        while ((idx = text.indexOf(tics, idx)) >= 0 && idx < textLength) {
            int additionalQuotesLength = PsiRawStringLiteralUtil.getTicksSequence(text, textLength, idx + quotesLength);
            if (additionalQuotesLength == 0) {
                hasToReplace = true;
            }
            maxQuotesNumber = Math.max(maxQuotesNumber, additionalQuotesLength);
            idx += additionalQuotesLength + quotesLength;
        }
        return hasToReplace ? StringUtil.repeat((String)"`", (int)(maxQuotesNumber + 1)) : "";
    }

    public static int getLeadingTicksSequence(CharSequence text) {
        return PsiRawStringLiteralUtil.getTicksSequence(text, text.length(), 0);
    }

    public static int getTrailingTicksSequence(CharSequence text) {
        int length;
        for (length = text.length(); length > 0 && text.charAt(length - 1) == '`'; --length) {
        }
        return text.length() - length;
    }

    private static int getTicksSequence(CharSequence literalText, int length, int startIndex) {
        int quotesLength;
        for (quotesLength = startIndex; quotesLength < length && literalText.charAt(quotesLength) == '`'; ++quotesLength) {
        }
        return quotesLength - startIndex;
    }

    public static int getReducedNumberOfBackticks(String text) {
        int trailingTicsSequence;
        int leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence(text);
        if (leadingTicsSequence == (trailingTicsSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence(text)) && leadingTicsSequence > 1) {
            int ticsSequence;
            int length = text.length() - trailingTicsSequence;
            BitSet usedTicSequences = new BitSet();
            usedTicSequences.set(leadingTicsSequence);
            for (int idx = leadingTicsSequence; idx < length && (idx = text.indexOf("`", idx)) >= 0; idx += ticsSequence) {
                ticsSequence = PsiRawStringLiteralUtil.getTicksSequence(text, length, idx);
                usedTicSequences.set(ticsSequence);
            }
            for (int i = 1; i < leadingTicsSequence; ++i) {
                if (usedTicSequences.get(i)) continue;
                return i;
            }
        }
        return -1;
    }
}

