/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.application.options.codeStyle.properties.ValueListPropertyAccessor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.language.extensions.EditorConfigOptionDescriptorProvider;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigListDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigNumberDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigOptionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigStringDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijConfigOptionDescriptorProvider
implements EditorConfigOptionDescriptorProvider {
    private static final Set<String> UNSUPPORTED_PROPERTIES = ContainerUtil.newHashSet();

    @Override
    @NotNull
    public List<EditorConfigOptionDescriptor> getOptionDescriptors() {
        if (!Utils.isFullIntellijSettingsSupport()) {
            List<EditorConfigOptionDescriptor> list = Collections.emptyList();
            if (list == null) {
                IntellijConfigOptionDescriptorProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<EditorConfigOptionDescriptor> list = IntellijConfigOptionDescriptorProvider.getAllOptions();
        if (list == null) {
            IntellijConfigOptionDescriptorProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean requiresFullSupport() {
        return Utils.isFullIntellijSettingsSupport();
    }

    private static List<EditorConfigOptionDescriptor> getAllOptions() {
        ArrayList descriptors = ContainerUtil.newArrayList();
        ArrayList mappers = ContainerUtil.newArrayList();
        CodeStylePropertiesUtil.collectMappers((CodeStyleSettings)CodeStyle.getDefaultSettings(), mapper -> mappers.add(mapper));
        for (AbstractCodeStylePropertyMapper mapper2 : mappers) {
            for (String property : mapper2.enumProperties()) {
                if (UNSUPPORTED_PROPERTIES.contains(property)) continue;
                List<String> ecNames = EditorConfigIntellijNameUtil.toEditorConfigNames(mapper2, property);
                EditorConfigDescriptor valueDescriptor = IntellijConfigOptionDescriptorProvider.createValueDescriptor(property, mapper2);
                if (valueDescriptor == null) continue;
                for (String ecName : ecNames) {
                    EditorConfigOptionDescriptor descriptor = new EditorConfigOptionDescriptor(new EditorConfigConstantDescriptor(ecName, mapper2.getPropertyDescription(property), null), valueDescriptor, null, null);
                    descriptors.add(descriptor);
                }
            }
        }
        return descriptors;
    }

    @Nullable
    private static EditorConfigDescriptor createValueDescriptor(@NotNull String property, @NotNull AbstractCodeStylePropertyMapper mapper) {
        CodeStylePropertyAccessor accessor;
        if (property == null) {
            IntellijConfigOptionDescriptorProvider.$$$reportNull$$$0(2);
        }
        if (mapper == null) {
            IntellijConfigOptionDescriptorProvider.$$$reportNull$$$0(3);
        }
        if ((accessor = mapper.getAccessor(property)) instanceof CodeStyleChoiceList) {
            return new EditorConfigUnionDescriptor(IntellijConfigOptionDescriptorProvider.choicesToDescriptorList((CodeStyleChoiceList)accessor), null, null);
        }
        if (accessor instanceof IntegerAccessor) {
            return new EditorConfigNumberDescriptor(null, null);
        }
        if (accessor instanceof ValueListPropertyAccessor) {
            return new EditorConfigListDescriptor(0, true, Collections.singletonList(new EditorConfigStringDescriptor(null, null)), null, null);
        }
        if (accessor instanceof ExternalStringAccessor) {
            return new EditorConfigStringDescriptor(null, null);
        }
        return null;
    }

    private static List<EditorConfigDescriptor> choicesToDescriptorList(@NotNull CodeStyleChoiceList list) {
        if (list == null) {
            IntellijConfigOptionDescriptorProvider.$$$reportNull$$$0(4);
        }
        return ContainerUtil.map((Collection)list.getChoices(), s -> new EditorConfigConstantDescriptor((String)s, null, null));
    }

    static {
        UNSUPPORTED_PROPERTIES.add("imports_layout");
        UNSUPPORTED_PROPERTIES.add("packages_to_use_import_on_demand");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/extended/IntellijConfigOptionDescriptorProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionDescriptors";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/extended/IntellijConfigOptionDescriptorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValueDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "choicesToDescriptorList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

