/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.editorconfig.configmanagement.EditorConfigIndentOptionsProvider;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigStatusUIContributor
extends IndentStatusBarUIContributor {
    private static final String PROJECT_ADVERTISEMENT_FLAG = "editor.config.ad.shown";
    private final boolean myEditorConfigIndentOptions;
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("EditorConfig", NotificationDisplayType.STICKY_BALLOON, true);

    public EditorConfigStatusUIContributor(TransientCodeStyleSettings transientSettings) {
        super(EditorConfigStatusUIContributor.getOverriddenIndentOptions(transientSettings));
        this.myEditorConfigIndentOptions = true;
    }

    public EditorConfigStatusUIContributor(CommonCodeStyleSettings.IndentOptions options) {
        super(options);
        this.myEditorConfigIndentOptions = options.getFileIndentOptionsProvider() instanceof EditorConfigIndentOptionsProvider;
    }

    private static CommonCodeStyleSettings.IndentOptions getOverriddenIndentOptions(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            EditorConfigStatusUIContributor.$$$reportNull$$$0(0);
        }
        PsiFile file = transientSettings.getPsiFile();
        return transientSettings.getLanguageIndentOptions(file.getLanguage());
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file) {
        if (file == null) {
            EditorConfigStatusUIContributor.$$$reportNull$$$0(1);
        }
        return this.myEditorConfigIndentOptions;
    }

    @Nullable
    public AnAction[] getActions(@NotNull PsiFile file) {
        if (file == null) {
            EditorConfigStatusUIContributor.$$$reportNull$$$0(2);
        }
        if (this.myEditorConfigIndentOptions) {
            ArrayList actions = ContainerUtil.newArrayList();
            EditorConfigNavigationActionsFactory navigationActionsFactory = EditorConfigNavigationActionsFactory.getInstance(file.getVirtualFile());
            actions.addAll(navigationActionsFactory.getNavigationActions(file.getProject()));
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }
        return null;
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        if (project == null) {
            EditorConfigStatusUIContributor.$$$reportNull$$$0(3);
        }
        return DumbAwareAction.create((String)EditorConfigBundle.message("action.disable"), e -> {
            EditorConfigSettings settings = (EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = false;
            CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
            EditorConfigStatusUIContributor.showDisabledDetectionNotification(project);
        });
    }

    @Nullable
    public String getHint() {
        return this.myEditorConfigIndentOptions ? "EditorConfig" : null;
    }

    @Nullable
    public String getAdvertisementText(@NotNull PsiFile psiFile) {
        PropertiesComponent projectProperties;
        boolean adFlag;
        if (psiFile == null) {
            EditorConfigStatusUIContributor.$$$reportNull$$$0(4);
        }
        if (adFlag = (projectProperties = PropertiesComponent.getInstance((Project)psiFile.getProject())).getBoolean(PROJECT_ADVERTISEMENT_FLAG)) {
            return null;
        }
        projectProperties.setValue(PROJECT_ADVERTISEMENT_FLAG, true);
        return EditorConfigBundle.message("advertisement.text");
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        if (project == null) {
            EditorConfigStatusUIContributor.$$$reportNull$$$0(5);
        }
        EditorConfigDisabledNotification notification = new EditorConfigDisabledNotification(project);
        notification.notify(project);
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return false;
    }

    public Icon getIcon() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigStatusUIContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOverriddenIndentOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "areActionsAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDisableAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdvertisementText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showDisabledDetectionNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReEnableAction
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableAction(@NotNull Project project, Notification notification) {
            if (project == null) {
                ReEnableAction.$$$reportNull$$$0(0);
            }
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReEnableAction.$$$reportNull$$$0(1);
            }
            CodeStyleSettings rootSettings = CodeStyle.getSettings((Project)this.myProject);
            EditorConfigSettings settings = (EditorConfigSettings)rootSettings.getCustomSettings(EditorConfigSettings.class);
            settings.ENABLED = true;
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigStatusUIContributor$ReEnableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowEditorConfigOption
    extends DumbAwareAction {
        private ShowEditorConfigOption(@Nullable String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowEditorConfigOption.$$$reportNull$$$0(0);
            }
            ShowSettingsUtilImpl.showSettingsDialog((Project)e.getProject(), (String)"preferences.sourceCode", (String)"EditorConfig");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/EditorConfigStatusUIContributor$ShowEditorConfigOption", "actionPerformed"));
        }
    }

    private static class EditorConfigDisabledNotification
    extends Notification {
        private EditorConfigDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), EditorConfigBundle.message("disabled.notification"), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableAction(project, this));
            this.addAction((AnAction)new ShowEditorConfigOption(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }
}

