/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public class MoveGroovyMemberHandler
implements MoveMemberHandler {
    public boolean changeExternalUsage(@NotNull MoveMembersOptions options, @NotNull MoveMembersProcessor.MoveMembersUsageInfo usage) {
        PsiElement element;
        if (options == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(0);
        }
        if (usage == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(1);
        }
        if ((element = usage.getElement()) == null || !element.isValid()) {
            return true;
        }
        if (usage.reference instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)usage.reference;
            GrExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null) {
                    MoveGroovyMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
                } else {
                    refExpr.setQualifier(null);
                }
            } else if (usage.qualifierClass != null) {
                MoveGroovyMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiMember moved;
        if (options == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(2);
        }
        if (member == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(3);
        }
        if (targetClass == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(4);
        }
        GroovyChangeContextUtil.encodeContextInfo((PsiElement)member);
        PsiDocComment docComment = member instanceof PsiDocCommentOwner ? ((PsiDocCommentOwner)member).getDocComment() : null;
        if (options.makeEnumConstant() && member instanceof GrVariable && EnumConstantsUtil.isSuitableForEnumConstant((PsiType)((PsiVariable)member).getType(), (PsiClass)targetClass)) {
            GrEnumConstant prototype = MoveGroovyMemberHandler.createEnumConstant(member.getName(), ((GrVariable)member).getInitializerGroovy(), member.getProject());
            moved = (PsiMember)MoveGroovyMemberHandler.addEnumConstant(targetClass, prototype, anchor);
            member.delete();
        } else if (member instanceof GrEnumConstant) {
            moved = (PsiMember)MoveGroovyMemberHandler.addEnumConstant(targetClass, (GrEnumConstant)member, null);
        } else if (member instanceof GrField) {
            int i;
            if (anchor != null) {
                anchor = anchor.getParent();
            }
            GrVariableDeclaration parent2 = (GrVariableDeclaration)member.getParent();
            GrVariableDeclaration movedDeclaration = (GrVariableDeclaration)targetClass.addAfter((PsiElement)parent2, anchor);
            int number = ArrayUtil.find((Object[])parent2.getMembers(), (Object)member);
            GrMember[] members = movedDeclaration.getMembers();
            for (i = 0; i < number; ++i) {
                members[i].delete();
            }
            for (i = number + 1; i < members.length; ++i) {
                members[i].delete();
            }
            if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                GrModifierList list = movedDeclaration.getModifierList();
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
            }
            moved = movedDeclaration.getMembers()[0];
        } else if (member instanceof GrMethod) {
            moved = (PsiMember)targetClass.addAfter((PsiElement)member, anchor);
            if (member.getContainingClass().isInterface() && !targetClass.isInterface()) {
                PsiModifierList list = moved.getModifierList();
                assert (list != null);
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
            }
        } else {
            moved = (PsiMember)targetClass.addAfter((PsiElement)member, anchor);
        }
        if (docComment != null) {
            PsiElement insertedDocComment = targetClass.addBefore((PsiElement)docComment, (PsiElement)moved);
            PsiElement prevSibling = insertedDocComment.getPrevSibling();
            MoveGroovyMemberHandler.addLineFeedIfNeeded(prevSibling);
            docComment.delete();
        }
        member.delete();
        PsiMember psiMember = moved;
        if (psiMember == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(5);
        }
        return psiMember;
    }

    private static void addLineFeedIfNeeded(PsiElement prevSibling) {
        if (prevSibling == null) {
            return;
        }
        ASTNode node = prevSibling.getNode();
        IElementType type2 = node.getElementType();
        if (type2 == GroovyTokenTypes.mNLS) {
            String text = prevSibling.getText();
            int lfCount = StringUtil.countChars((CharSequence)text, (char)'\n');
            if (lfCount < 2) {
                ASTNode parent2 = node.getTreeParent();
                parent2.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)(text + "\n "), node);
                parent2.removeChild(node);
            }
        } else {
            node.getTreeParent().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n\n ", node.getTreeNext());
        }
    }

    public void decodeContextInfo(@NotNull PsiElement scope) {
        if (scope == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(6);
        }
        GroovyChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    private static void changeQualifier(GrReferenceExpression refExpr, PsiClass aClass, PsiMember member) throws IncorrectOperationException {
        if (MoveGroovyMemberHandler.hasOnDemandStaticImport(refExpr, aClass)) {
            refExpr.setQualifier(null);
        } else if (!MoveGroovyMemberHandler.hasStaticImport(refExpr, member)) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(refExpr.getProject());
            refExpr.setQualifier(factory.createReferenceExpressionFromText(aClass.getName()));
            ((GrReferenceExpression)refExpr.getQualifierExpression()).bindToElement((PsiElement)aClass);
        }
    }

    private static boolean hasStaticImport(GrReferenceExpression refExpr, PsiMember member) {
        GrImportStatement[] imports2;
        if (!(refExpr.getContainingFile() instanceof GroovyFile)) {
            return false;
        }
        for (GrImportStatement stmt : imports2 = ((GroovyFile)refExpr.getContainingFile()).getImportStatements()) {
            if (stmt.isOnDemand() || stmt.resolveTargetClass() != member.getContainingClass() || !Comparing.strEqual((String)stmt.getImportReference().getReferenceName(), (String)member.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        if (element.getContainingFile() instanceof GroovyFile) {
            GrImportStatement[] importStatements;
            for (GrImportStatement stmt : importStatements = ((GroovyFile)element.getContainingFile()).getImportStatements()) {
                GrCodeReferenceElement ref = stmt.getImportReference();
                if (ref == null || !stmt.isStatic() || !stmt.isOnDemand() || ref.resolve() != aClass) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public PsiElement getAnchor(@NotNull PsiMember member, final @NotNull PsiClass targetClass, Set<PsiMember> membersToMove) {
        if (member == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(7);
        }
        if (targetClass == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(8);
        }
        if (member instanceof GrField && member.hasModifierProperty("static")) {
            final ArrayList referencedFields = new ArrayList();
            GrExpression psiExpression = ((GrField)member).getInitializerGroovy();
            if (psiExpression != null) {
                psiExpression.accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
                        GrField grField;
                        if (expression == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitReferenceExpression(expression);
                        PsiElement psiElement = expression.resolve();
                        if (psiElement instanceof GrField && (grField = (GrField)psiElement).getContainingClass() == targetClass && !referencedFields.contains(grField)) {
                            referencedFields.add(grField);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyMemberHandler$1", "visitReferenceExpression"));
                    }
                });
            }
            if (!referencedFields.isEmpty()) {
                Collections.sort(referencedFields, (o1, o2) -> -PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2));
                return (PsiElement)referencedFields.get(0);
            }
        }
        return null;
    }

    private static GrEnumConstant createEnumConstant(String constantName, GrExpression initializerExpr, Project project) throws IncorrectOperationException {
        GroovyPsiElementFactory elementFactory = GroovyPsiElementFactory.getInstance(project);
        String enumConstantText = initializerExpr != null ? constantName + "(" + initializerExpr.getText() + ")" : constantName;
        return elementFactory.createEnumConstantFromText(enumConstantText);
    }

    private static PsiElement addEnumConstant(PsiClass targetClass, GrEnumConstant constant, @Nullable PsiElement anchor) {
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumTypeDefinition enumeration = (GrEnumTypeDefinition)targetClass;
            GrEnumConstantList constantList = enumeration.getEnumConstantList();
            if (constantList != null) {
                ASTNode node = constantList.getNode();
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", node.getFirstChildNode());
                return constantList.addBefore(constant, constantList.getFirstChild());
            }
            PsiElement parent2 = constant.getParent();
            assert (parent2 instanceof GrEnumConstantList);
            GrEnumConstantList constListCopy = (GrEnumConstantList)targetClass.add(parent2);
            return constListCopy.getEnumConstants()[0];
        }
        return anchor != null ? targetClass.addAfter((PsiElement)constant, anchor) : targetClass.add((PsiElement)constant);
    }

    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(@NotNull PsiMember member, @NotNull PsiReference psiReference, @NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass) {
        PsiElement ref;
        if (member == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(9);
        }
        if (psiReference == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(10);
        }
        if (membersToMove == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(11);
        }
        if (targetClass == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(12);
        }
        if ((ref = psiReference.getElement()) instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)ref;
            GrExpression qualifier = (GrExpression)refExpr.getQualifier();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, (PsiClass)targetClass, (boolean)true)) {
                if (!RefactoringUtil.isInMovedElement((PsiElement)refExpr, membersToMove) ? qualifier != null : qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    public void checkConflictsOnUsage(@NotNull MoveMembersProcessor.MoveMembersUsageInfo usageInfo, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiElement element;
        if (usageInfo == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(13);
        }
        if (targetClass == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(14);
        }
        if (membersToMove == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(15);
        }
        if (conflicts == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(16);
        }
        if ((element = usageInfo.getElement()) == null) {
            return;
        }
        PsiMember member = usageInfo.member;
        if (element instanceof GrReferenceExpression) {
            GrExpression qualifier = (GrExpression)((GrReferenceExpression)element).getQualifier();
            PsiClass accessObjectClass = null;
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
            }
            if (!JavaResolveUtil.isAccessible((PsiMember)member, (PsiClass)targetClass, (PsiModifierList)modifierListCopy, (PsiElement)element, (PsiClass)accessObjectClass, null)) {
                String visibility = newVisibility != null ? newVisibility : VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member);
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), visibility, RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)element), (boolean)true)});
                conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
        }
    }

    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(17);
        }
        if (targetClass == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(18);
        }
        if (membersToMove == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(19);
        }
        if (conflicts == null) {
            MoveGroovyMemberHandler.$$$reportNull$$$0(20);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyMemberHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReference";
                break;
            }
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyMemberHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doMove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeExternalUsage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "decodeContextInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUsage";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictsOnUsage";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictsOnMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

