/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\u00020\u00012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"argumentApplicability", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Applicability;", "parameterType", "Lcom/intellij/psi/PsiType;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "context", "Lcom/intellij/psi/PsiElement;", "mapApplicability", "map", "", "Lcom/intellij/psi/PsiParameter;", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "erase", "", "type", "intellij.groovy.psi"})
public final class ApplicabilityKt {
    @NotNull
    public static final Applicability mapApplicability(@NotNull Map<Argument, ? extends PsiParameter> map2, @NotNull PsiSubstitutor substitutor, boolean erase, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map<Argument, ? extends PsiParameter> map3 = map2;
        Iterator<Map.Entry<Argument, ? extends PsiParameter>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Argument, ? extends PsiParameter> entry;
            Map.Entry<Argument, ? extends PsiParameter> entry2 = entry = iterator2.next();
            Argument argument = entry2.getKey();
            entry2 = entry;
            PsiParameter parameter = entry2.getValue();
            PsiType psiType = parameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"parameter.type");
            PsiType parameterType = ApplicabilityKt.parameterType(psiType, substitutor, erase);
            Applicability applicability = ApplicabilityKt.argumentApplicability(parameterType, argument, context);
            if (applicability == Applicability.applicable) continue;
            return applicability;
        }
        return Applicability.applicable;
    }

    @NotNull
    public static final Applicability argumentApplicability(@Nullable PsiType parameterType, @NotNull Argument argument, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (parameterType == null) {
            return Applicability.canBeApplicable;
        }
        PsiType argumentType = argument.getRuntimeType();
        if (argumentType == null) {
            return Applicability.canBeApplicable;
        }
        ConversionResult conversionResult = TypesUtil.canAssign(parameterType, argumentType, context, GrTypeConverter.ApplicableTo.METHOD_PARAMETER);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)conversionResult), (String)"TypesUtil.canAssign(para\u2026cableTo.METHOD_PARAMETER)");
        ConversionResult assignability = conversionResult;
        if (assignability == ConversionResult.ERROR) {
            return Applicability.inapplicable;
        }
        return Applicability.applicable;
    }

    @Nullable
    public static final PsiType parameterType(@NotNull PsiType type2, @NotNull PsiSubstitutor substitutor, boolean erase) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
        return erase ? TypeConversionUtil.erasure((PsiType)type2, (PsiSubstitutor)substitutor) : substitutor.substitute(type2);
    }
}

