/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringHintProcessor;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J;\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J,\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0002J3\u0010+\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\n2\u0006\u0010,\u001a\u00020\f2\u0006\u0010%\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010.\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DefaultDelegatesToProvider;", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/GrDelegatesToProvider;", "()V", "findParameter", "Lcom/intellij/psi/PsiParameter;", "parameterList", "Lcom/intellij/psi/PsiParameterList;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "map", "", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil$ArgInfo;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiParameterList;Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;[Lorg/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil$ArgInfo;)Lcom/intellij/psi/PsiParameter;", "findTargetParameter", "", "list", "target", "", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "getFromTarget", "Lcom/intellij/psi/PsiType;", "delegatesTo", "Lcom/intellij/psi/PsiAnnotation;", "signature", "Lorg/jetbrains/plugins/groovy/lang/psi/api/signatures/GrSignature;", "(Lcom/intellij/psi/PsiParameterList;Lcom/intellij/psi/PsiAnnotation;Lorg/jetbrains/plugins/groovy/lang/psi/api/signatures/GrSignature;[Lorg/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil$ArgInfo;)Lcom/intellij/psi/PsiType;", "getFromType", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getFromValue", "getStrategyValue", "strategy", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "inferCallQualifier", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "inferGenericArgType", "targetType", "genericIndex", "param", "mapArgs", "place", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;Lorg/jetbrains/plugins/groovy/lang/psi/api/signatures/GrSignature;)[Lorg/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil$ArgInfo;", "intellij.groovy.psi"})
public final class DefaultDelegatesToProvider
implements GrDelegatesToProvider {
    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrFunctionalExpression expression) {
        PsiType psiType;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        GrCall grCall = GrDelegatesToUtilKt.getContainingCall(expression);
        if (grCall == null) {
            return null;
        }
        GrCall call = grCall;
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"call.advancedResolve()");
        GroovyResolveResult result2 = groovyResolveResult;
        PsiElement psiElement = result2.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (GdkMethodUtil.isWithOrIdentity((PsiElement)method)) {
            GrCall grCall2 = call;
            if (grCall2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall");
            }
            GrExpression grExpression = this.inferCallQualifier((GrMethodCall)grCall2);
            if (grExpression == null) {
                return null;
            }
            GrExpression qualifier = grExpression;
            return new DelegatesToInfo(qualifier.getType(), 1);
        }
        GrSignature grSignature = GrClosureSignatureUtil.createSignature(method, PsiSubstitutor.EMPTY);
        Intrinsics.checkExpressionValueIsNotNull((Object)grSignature, (String)"createSignature(method, PsiSubstitutor.EMPTY)");
        GrSignature signature = grSignature;
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] argInfoArray = this.mapArgs(expression, call, signature);
        if (argInfoArray == null) {
            return null;
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] map2 = argInfoArray;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameterList parameterList = psiParameterList;
        PsiParameter psiParameter = this.findParameter(parameterList, expression, map2);
        if (psiParameter == null) {
            return null;
        }
        PsiParameter parameter = psiParameter;
        String delegateFqnData = (String)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY);
        Integer strategyData = (Integer)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_STRATEGY_KEY);
        if (delegateFqnData != null) {
            Integer n = strategyData;
            return new DelegatesToInfo((PsiType)TypesUtil.createType(delegateFqnData, expression), n != null ? n : 0);
        }
        PsiModifierList psiModifierList = parameter.getModifierList();
        if (psiModifierList == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"parameter.modifierList ?: return null");
        PsiModifierList modifierList = psiModifierList;
        PsiAnnotation psiAnnotation = modifierList.findAnnotation("groovy.lang.DelegatesTo");
        if (psiAnnotation == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"modifierList.findAnnotat\u2026EGATES_TO) ?: return null");
        PsiAnnotation delegatesTo = psiAnnotation;
        int strategyValue = this.getStrategyValue(delegatesTo.findAttributeValue("strategy"));
        if (strategyValue == 2 || strategyValue == 4) {
            psiType = null;
        } else {
            PsiType psiType2 = this.getFromValue(delegatesTo);
            if (psiType2 == null) {
                psiType2 = psiType = this.getFromTarget(parameterList, delegatesTo, signature, map2);
            }
            if (psiType2 == null) {
                psiType = this.getFromType(result2, delegatesTo);
            }
        }
        PsiType delegateType = psiType;
        return new DelegatesToInfo(delegateType, strategyValue);
    }

    private final GrClosureSignatureUtil.ArgInfo<PsiElement>[] mapArgs(PsiElement place, GrCall call, GrSignature signature) {
        GrSignature grSignature = GrClosureSignatureUtil.rawSignature(signature);
        Intrinsics.checkExpressionValueIsNotNull((Object)grSignature, (String)"GrClosureSignatureUtil.rawSignature(signature)");
        GrSignature rawSignature = grSignature;
        return GrClosureSignatureUtil.mapParametersToArguments(rawSignature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), place, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiParameter findParameter(PsiParameterList parameterList, GrFunctionalExpression expression, GrClosureSignatureUtil.ArgInfo<PsiElement>[] map2) {
        PsiParameter[] psiParameterArray = parameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"parameterList.parameters");
        PsiParameter[] parameters = psiParameterArray;
        int n = 0;
        int n2 = map2.length;
        while (n < n2) {
            void i;
            if (map2[i].args.contains(expression)) {
                return parameters[i];
            }
            ++i;
        }
        return null;
    }

    private final PsiType getFromValue(PsiAnnotation delegatesTo) {
        PsiAnnotationMemberValue value = delegatesTo.findDeclaredAttributeValue("value");
        if (value instanceof GrReferenceExpression) {
            return ResolveUtil.unwrapClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return ResolveUtil.unwrapClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiType.NULL || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiType.NULL) {
            return null;
        }
        if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    private final PsiType getFromTarget(PsiParameterList parameterList, PsiAnnotation delegatesTo, GrSignature signature, GrClosureSignatureUtil.ArgInfo<PsiElement>[] map2) {
        String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GrAnnotationUtil.inferSt\u2026 \"target\") ?: return null");
        String target = string;
        int parameter = this.findTargetParameter(parameterList, target);
        if (parameter < 0) {
            return null;
        }
        PsiType type2 = map2[parameter].type;
        Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
        return index != null ? this.inferGenericArgType(signature, type2, index, parameter) : type2;
    }

    private final PsiType inferGenericArgType(GrSignature signature, PsiType targetType, int genericIndex, int param) {
        if (!(targetType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)targetType).resolveGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)classResolveResult, (String)"targetType.resolveGenerics()");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"result.element ?: return null");
        PsiClass psiClass2 = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"result.substitutor");
        PsiSubstitutor substitutor = psiSubstitutor;
        GrClosureParameter grClosureParameter = signature.getParameters()[param];
        Intrinsics.checkExpressionValueIsNotNull((Object)grClosureParameter, (String)"signature.parameters[param]");
        PsiType baseType = grClosureParameter.getType();
        PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
        if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass2, (PsiClass)baseClass, (boolean)true)) {
            PsiTypeParameter[] psiTypeParameterArray = baseClass.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"baseClass.typeParameters");
            PsiTypeParameter[] typeParameters = psiTypeParameterArray;
            if (genericIndex < typeParameters.length) {
                PsiSubstitutor psiSubstitutor2 = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass2, (PsiSubstitutor)substitutor);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor2, (String)"TypeConversionUtil.getSu\u2026s, psiClass, substitutor)");
                PsiSubstitutor superClassSubstitutor = psiSubstitutor2;
                return superClassSubstitutor.substitute(typeParameters[genericIndex]);
            }
        }
        return null;
    }

    private final PsiType getFromType(GroovyResolveResult result2, PsiAnnotation delegatesTo) {
        PsiElement psiElement = result2.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod element = psiMethod;
        String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "type");
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GrAnnotationUtil.inferSt\u2026o, \"type\") ?: return null");
        String typeValue = string;
        if (StringsKt.isBlank((CharSequence)typeValue)) {
            return null;
        }
        PsiElement psiElement2 = FromStringHintProcessor.createContext(element);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"FromStringHintProcessor.createContext(element)");
        PsiElement context = psiElement2;
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeValue, context);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"JavaPsiFacade.getElement\u2026mText(typeValue, context)");
        PsiType type2 = psiType;
        PsiSubstitutor psiSubstitutor = result2 instanceof GroovyMethodResult ? ((GroovyMethodResult)result2).getPartialSubstitutor() : result2.getSubstitutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"if (result is GroovyMeth\u2026r else result.substitutor");
        PsiSubstitutor substitutor = psiSubstitutor;
        return substitutor.substitute(type2);
    }

    /*
     * WARNING - void declaration
     */
    private final int findTargetParameter(PsiParameterList list, String target) {
        PsiParameter[] psiParameterArray = list.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"list.parameters");
        PsiParameter[] parameters = psiParameterArray;
        int n = 0;
        int n2 = parameters.length;
        while (n < n2) {
            void i;
            PsiParameter psiParameter = parameters[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[i]");
            if (psiParameter.getModifierList() == null) {
            } else {
                PsiModifierList modifierList;
                Intrinsics.checkExpressionValueIsNotNull((Object)modifierList, (String)"parameters[i].modifierList ?: continue");
                if (modifierList.findAnnotation("groovy.lang.DelegatesTo.Target") == null) {
                } else {
                    PsiAnnotation targetAnnotation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)targetAnnotation, (String)"modifierList.findAnnotat\u2026ES_TO_TARGET) ?: continue");
                    if (GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value") == null) {
                    } else {
                        String value;
                        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"GrAnnotationUtil.inferSt\u2026ion, \"value\") ?: continue");
                        if (Intrinsics.areEqual((Object)value, (Object)target)) {
                            return (int)i;
                        }
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    private final GrExpression inferCallQualifier(GrMethodCall call) {
        GrExpression grExpression = call.getInvokedExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"call.invokedExpression");
        GrExpression expression = grExpression;
        return !(expression instanceof GrReferenceExpression) ? null : (GrExpression)((GrReferenceExpression)expression).getQualifier();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int getStrategyValue(PsiAnnotationMemberValue strategy) {
        String text;
        if (strategy == null) {
            return 0;
        }
        String string = text = strategy.getText();
        if (string != null) {
            switch (string) {
                case "0": {
                    return 0;
                }
                case "1": {
                    return 1;
                }
                case "2": {
                    return 2;
                }
                case "3": {
                    return 3;
                }
                case "4": {
                    return 4;
                }
            }
        }
        String string2 = text;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        if (StringsKt.endsWith$default((String)string2, (String)"OWNER_FIRST", (boolean)false, (int)2, null)) {
            return 0;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_FIRST", (boolean)false, (int)2, null)) {
            return 1;
        }
        if (StringsKt.endsWith$default((String)text, (String)"OWNER_ONLY", (boolean)false, (int)2, null)) {
            return 2;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_ONLY", (boolean)false, (int)2, null)) {
            return 3;
        }
        if (!StringsKt.endsWith$default((String)text, (String)"TO_SELF", (boolean)false, (int)2, null)) return 0;
        return 4;
    }
}

