/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Couple;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GrMapTypeImpl
extends GrMapType {
    @NotNull
    private final LinkedHashMap<String, PsiType> myStringEntries;
    @NotNull
    private final List<Couple<PsiType>> myOtherEntries;

    GrMapTypeImpl(JavaPsiFacade facade, GlobalSearchScope scope, @NotNull LinkedHashMap<String, PsiType> stringEntries, @NotNull List<Couple<PsiType>> otherEntries, @NotNull LanguageLevel languageLevel) {
        if (stringEntries == null) {
            GrMapTypeImpl.$$$reportNull$$$0(0);
        }
        if (otherEntries == null) {
            GrMapTypeImpl.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            GrMapTypeImpl.$$$reportNull$$$0(2);
        }
        super(facade, scope, languageLevel);
        this.myStringEntries = stringEntries;
        this.myOtherEntries = otherEntries;
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        return this.myStringEntries.get(key);
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        Set<String> set = this.myStringEntries.keySet();
        if (set == null) {
            GrMapTypeImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    protected PsiType[] getAllKeyTypes() {
        HashSet<Object> result2 = new HashSet<Object>();
        if (!this.myStringEntries.isEmpty()) {
            result2.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<PsiType> entry : this.myOtherEntries) {
            result2.add(entry.first);
        }
        result2.remove(null);
        PsiType[] psiTypeArray = result2.toArray(GrMapTypeImpl.createArray((int)result2.size()));
        if (psiTypeArray == null) {
            GrMapTypeImpl.$$$reportNull$$$0(4);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    protected PsiType[] getAllValueTypes() {
        HashSet<PsiType> result2 = new HashSet<PsiType>(this.myStringEntries.values());
        for (Couple<PsiType> entry : this.myOtherEntries) {
            result2.add((PsiType)entry.second);
        }
        result2.remove(null);
        PsiType[] psiTypeArray = result2.toArray(GrMapTypeImpl.createArray((int)result2.size()));
        if (psiTypeArray == null) {
            GrMapTypeImpl.$$$reportNull$$$0(5);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        List<Couple<PsiType>> list = this.myOtherEntries;
        if (list == null) {
            GrMapTypeImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        LinkedHashMap<String, PsiType> linkedHashMap = this.myStringEntries;
        if (linkedHashMap == null) {
            GrMapTypeImpl.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    public boolean isValid() {
        for (PsiType psiType : this.myStringEntries.values()) {
            if (psiType == null || psiType.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (couple.first != null && !((PsiType)couple.first).isValid()) {
                return false;
            }
            if (couple.second == null || ((PsiType)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GrMapTypeImpl type2 = (GrMapTypeImpl)((Object)o);
        if (!this.myStringEntries.equals(type2.myStringEntries)) {
            return false;
        }
        return this.myOtherEntries.equals(type2.myOtherEntries);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStringEntries.hashCode();
        result2 = 31 * result2 + this.myOtherEntries.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringEntries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherEntries";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringKeys";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeyTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValueTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherEntries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

