/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.GraphKt;

class InferenceCache {
    private final GrControlFlowOwner myScope;
    private final Instruction[] myFlow;
    private final Map<PsiElement, List<Instruction>> myFromByElements;
    private final TObjectIntHashMap<String> myVarIndexes;
    private final List<DefinitionMap> myDefinitions;
    private final AtomicReference<List<TypeDfaState>> myVarTypes;
    private final Set<Instruction> myTooComplexInstructions;

    InferenceCache(@NotNull GrControlFlowOwner scope, @NotNull TObjectIntHashMap<String> varIndexes, @NotNull List<DefinitionMap> definitions) {
        if (scope == null) {
            InferenceCache.$$$reportNull$$$0(0);
        }
        if (varIndexes == null) {
            InferenceCache.$$$reportNull$$$0(1);
        }
        if (definitions == null) {
            InferenceCache.$$$reportNull$$$0(2);
        }
        this.myTooComplexInstructions = ContainerUtil.newConcurrentSet();
        this.myScope = scope;
        this.myFlow = scope.getControlFlow();
        this.myVarIndexes = varIndexes;
        this.myDefinitions = definitions;
        this.myFromByElements = Arrays.stream(this.myFlow).filter(it -> it.getElement() != null).collect(Collectors.groupingBy(Instruction::getElement));
        ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
        for (int i = 0; i < this.myFlow.length; ++i) {
            noTypes.add(new TypeDfaState());
        }
        this.myVarTypes = new AtomicReference(noTypes);
    }

    @Nullable
    PsiType getInferredType(@NotNull String variableName, @NotNull Instruction instruction, boolean mixinOnly) {
        DFAType dfaType;
        if (variableName == null) {
            InferenceCache.$$$reportNull$$$0(3);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(4);
        }
        if (this.myTooComplexInstructions.contains(instruction)) {
            return null;
        }
        TypeDfaState cache2 = this.myVarTypes.get().get(instruction.num());
        if (!cache2.containsVariable(variableName)) {
            Predicate<Instruction> mixinPredicate = mixinOnly ? e -> e instanceof MixinTypeInstruction : e -> true;
            Couple<Set<Instruction>> interesting = this.collectRequiredInstructions(instruction, variableName, mixinPredicate);
            List<TypeDfaState> dfaResult = this.performTypeDfa(this.myScope, this.myFlow, interesting);
            if (dfaResult == null) {
                this.myTooComplexInstructions.addAll((Collection)interesting.first);
            } else {
                this.cacheDfaResult(dfaResult);
            }
        }
        return (dfaType = this.getCachedInferredType(variableName, instruction)) == null ? null : dfaType.getResultType();
    }

    @Nullable
    private List<TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, @NotNull Instruction[] flow, @NotNull Couple<Set<Instruction>> interesting) {
        if (owner == null) {
            InferenceCache.$$$reportNull$$$0(5);
        }
        if (flow == null) {
            InferenceCache.$$$reportNull$$$0(6);
        }
        if (interesting == null) {
            InferenceCache.$$$reportNull$$$0(7);
        }
        TypeDfaInstance dfaInstance = new TypeDfaInstance(flow, interesting, this);
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
        return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
    }

    @Nullable
    DFAType getCachedInferredType(@NotNull String variableName, @NotNull Instruction instruction) {
        if (variableName == null) {
            InferenceCache.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(9);
        }
        return this.myVarTypes.get().get(instruction.num()).getVariableType(variableName);
    }

    private Couple<Set<Instruction>> collectRequiredInstructions(@NotNull Instruction instruction, @NotNull String variableName, @NotNull Predicate<? super Instruction> predicate2) {
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(10);
        }
        if (variableName == null) {
            InferenceCache.$$$reportNull$$$0(11);
        }
        if (predicate2 == null) {
            InferenceCache.$$$reportNull$$$0(12);
        }
        LinkedHashMap<Pair, Set<Pair<Instruction, String>>> interesting = new LinkedHashMap<Pair, Set<Pair<Instruction, String>>>();
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(Pair.create((Object)instruction, (Object)variableName));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (interesting.containsKey(pair)) continue;
            Set<Pair<Instruction, String>> dependencies = this.findDependencies((Instruction)pair.first, (String)pair.second);
            interesting.put(pair, dependencies);
            dependencies.forEach(queue::addLast);
        }
        Set interestingInstructions = interesting.keySet().stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set acyclicInstructions = GraphKt.findNodesOutsideCycles(GraphKt.mapGraph(interesting)).stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        return Couple.of(interestingInstructions, acyclicInstructions);
    }

    @NotNull
    private Set<Pair<Instruction, String>> findDependencies(@NotNull Instruction instruction, @NotNull String varName) {
        int varIndex;
        DefinitionMap definitionMap;
        int[] definitions;
        if (instruction == null) {
            InferenceCache.$$$reportNull$$$0(13);
        }
        if (varName == null) {
            InferenceCache.$$$reportNull$$$0(14);
        }
        if ((definitions = (definitionMap = this.myDefinitions.get(instruction.num())).getDefinitions(varIndex = this.myVarIndexes.get((Object)varName))) == null) {
            Set<Pair<Instruction, String>> set = Collections.emptySet();
            if (set == null) {
                InferenceCache.$$$reportNull$$$0(15);
            }
            return set;
        }
        LinkedHashSet pairs = ContainerUtil.newLinkedHashSet();
        for (int defIndex : definitions) {
            Instruction write = this.myFlow[defIndex];
            pairs.add(Pair.create((Object)write, (Object)varName));
            PsiElement statement = InferenceCache.findDependencyScope(write.getElement());
            if (statement == null) continue;
            pairs.addAll(this.findAllInstructionsInside(statement));
        }
        LinkedHashSet linkedHashSet = pairs;
        if (linkedHashSet == null) {
            InferenceCache.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    @NotNull
    private List<Pair<Instruction, String>> findAllInstructionsInside(@NotNull PsiElement scope) {
        if (scope == null) {
            InferenceCache.$$$reportNull$$$0(17);
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof GrReferenceExpression && !((GrReferenceExpression)element).isQualified()) {
                    String varName = ((GrReferenceExpression)element).getReferenceName();
                    List instructionList = (List)InferenceCache.this.myFromByElements.get(element);
                    if (varName != null && instructionList != null) {
                        for (Instruction dependency : instructionList) {
                            result2.add(Pair.create((Object)dependency, (Object)varName));
                        }
                    }
                }
                super.visitElement(element);
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            InferenceCache.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement findDependencyScope(@Nullable PsiElement element) {
        return PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> !(element1.getParent() instanceof GrExpression) || element1 instanceof GrBinaryExpression || element1 instanceof GrInstanceOfExpression || PsiUtil.isExpressionStatement(element1));
    }

    private void cacheDfaResult(@NotNull List<TypeDfaState> dfaResult) {
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(19);
        }
        this.myVarTypes.accumulateAndGet(dfaResult, InferenceCache::addDfaResult);
    }

    @NotNull
    private static List<TypeDfaState> addDfaResult(@NotNull List<TypeDfaState> oldTypes, @NotNull List<TypeDfaState> dfaResult) {
        if (oldTypes == null) {
            InferenceCache.$$$reportNull$$$0(20);
        }
        if (dfaResult == null) {
            InferenceCache.$$$reportNull$$$0(21);
        }
        ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
        for (int i = 0; i < dfaResult.size(); ++i) {
            newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
        }
        ArrayList<TypeDfaState> arrayList = newTypes;
        if (arrayList == null) {
            InferenceCache.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varIndexes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interesting";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaResult";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/InferenceCache";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllInstructionsInside";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addDfaResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performTypeDfa";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInferredType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectRequiredInstructions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findAllInstructionsInside";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cacheDfaResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDfaResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

