/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u0004*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u0004*\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/closure/ImplicitClosureCallPredicate;", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "()V", "satisfiedBy", "", "element", "Lcom/intellij/psi/PsiElement;", "isClosureCallMethod", "isClosureType", "Lcom/intellij/psi/PsiType;", "intellij.groovy"})
public final class ImplicitClosureCallPredicate
implements PsiElementPredicate {
    public static final ImplicitClosureCallPredicate INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        GroovyResolveResult groovyResolveResult = ((GrMethodCallExpression)element).advancedResolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"element.advancedResolve()");
        GroovyResolveResult result2 = groovyResolveResult;
        if (((GrMethodCallExpression)element).getImplicitCallReference() != null) return this.isClosureCallMethod(result2.getElement());
        if (!result2.isInvokedOnProperty()) return false;
        GrExpression grExpression = ((GrMethodCallExpression)element).getInvokedExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"element.invokedExpression");
        if (!this.isClosureType(grExpression.getType())) return false;
        return true;
    }

    private final boolean isClosureType(@Nullable PsiType $receiver) {
        return $receiver != null && $receiver.equalsToText("groovy.lang.Closure");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isClosureCallMethod(@Nullable PsiElement $receiver) {
        if (!($receiver instanceof PsiMethod)) return false;
        if (!Intrinsics.areEqual((Object)((PsiMethod)$receiver).getName(), (Object)"call")) return false;
        PsiClass psiClass = ((PsiMethod)$receiver).getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"groovy.lang.Closure")) return false;
        return true;
    }

    private ImplicitClosureCallPredicate() {
    }

    static {
        ImplicitClosureCallPredicate implicitClosureCallPredicate;
        INSTANCE = implicitClosureCallPredicate = new ImplicitClosureCallPredicate();
    }
}

