/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class AbstractConfigUtils {
    private static final Logger LOG = Logger.getInstance(AbstractConfigUtils.class);
    protected static final String VERSION_GROUP_NAME = "version";
    private final Condition<Library> LIB_SEARCH_CONDITION = library -> this.isSDKLibrary((Library)library);
    @NonNls
    public static final String UNDEFINED_VERSION = "undefined";
    @NonNls
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    public abstract boolean isSDKHome(VirtualFile var1);

    @NotNull
    public abstract String getSDKVersion(@NotNull String var1);

    @Nullable
    public static String getSDKJarVersion(String jarPath, String jarRegex, String manifestPath) {
        return AbstractConfigUtils.getSDKJarVersion(jarPath, Pattern.compile(jarRegex), manifestPath);
    }

    @Nullable
    public static String getSDKJarVersion(String jarPath, Pattern jarPattern, String manifestPath) {
        return AbstractConfigUtils.getSDKJarVersion(jarPath, jarPattern, manifestPath, VERSION_GROUP_NAME);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String getSDKJarVersion(String jarPath, Pattern jarPattern, String manifestPath, String versionGroupName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK], 27[CATCHBLOCK], 11[TRYBLOCK]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Library[] getProjectSDKLibraries(Project project) {
        if (project == null || project.isDisposed()) {
            return Library.EMPTY_ARRAY;
        }
        LibraryTable table = ProjectLibraryTable.getInstance((Project)project);
        List all = ContainerUtil.findAll((Object[])table.getLibraries(), this.LIB_SEARCH_CONDITION);
        return all.toArray(Library.EMPTY_ARRAY);
    }

    public Library[] getAllSDKLibraries(@Nullable Project project) {
        return (Library[])ArrayUtil.mergeArrays((Object[])this.getGlobalSDKLibraries(), (Object[])this.getProjectSDKLibraries(project));
    }

    public Library[] getAllUsedSDKLibraries(Project project) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            libraries.addAll(Arrays.asList(this.getSDKLibrariesByModule(module)));
        }
        return libraries.toArray(Library.EMPTY_ARRAY);
    }

    public Library[] getGlobalSDKLibraries() {
        return LibrariesUtil.getGlobalLibraries(this.LIB_SEARCH_CONDITION);
    }

    public abstract boolean isSDKLibrary(Library var1);

    public Library[] getSDKLibrariesByModule(Module module) {
        return LibrariesUtil.getLibrariesByCondition(module, this.LIB_SEARCH_CONDITION);
    }
}

