/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.MatchResult;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.schema.YamlJsonSchemaInspectionBase;

public class YamlJsonSchemaDeprecationInspection
extends YamlJsonSchemaInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = YAMLBundle.message("inspections.schema.deprecation.name");
        if (string == null) {
            YamlJsonSchemaDeprecationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, PsiElement root, final JsonSchemaObject schema) {
        JsonLikePsiWalker walker;
        if (holder == null) {
            YamlJsonSchemaDeprecationInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            YamlJsonSchemaDeprecationInspection.$$$reportNull$$$0(2);
        }
        if ((walker = JsonLikePsiWalker.getWalker((PsiElement)root, (JsonSchemaObject)schema)) == null || schema == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final Project project = root.getProject();
        return new YamlPsiElementVisitor(){

            @Override
            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                if (keyValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.annotate(keyValue);
                super.visitKeyValue(keyValue);
            }

            private void annotate(@NotNull YAMLKeyValue keyValue) {
                PsiElement key;
                if (keyValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((key = keyValue.getKey()) == null) {
                    return;
                }
                JsonPointerPosition position = walker.findPosition((PsiElement)keyValue, true);
                if (position == null) {
                    return;
                }
                MatchResult result = new JsonSchemaResolver(project, schema, position).detailedResolve();
                for (JsonSchemaObject object : result.mySchemas) {
                    String message = object.getDeprecationMessage();
                    if (message == null) continue;
                    holder.registerProblem(key, YAMLBundle.message("inspections.schema.deprecation.text", keyValue.getName(), message), new LocalQuickFix[0]);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "keyValue";
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonSchemaDeprecationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKeyValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "annotate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonSchemaDeprecationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonSchemaDeprecationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

