/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.EditDistance;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.highlighting.AbstractManifestQuickFix;
import org.jetbrains.lang.manifest.psi.Header;

public class MisspelledHeaderInspection
extends LocalInspectionTool {
    private static final int MAX_SUGGESTIONS = 5;
    private static final int MAX_DISTANCE = 4;
    private static final int TYPO_DISTANCE = 2;
    @XCollection(elementName="header")
    public final Set<String> CUSTOM_HEADERS = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final HeaderParserRepository myRepository = HeaderParserRepository.getInstance();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MisspelledHeaderInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof Header) {
                    Header header = (Header)element;
                    String headerName = header.getName();
                    TreeSet matches = new TreeSet();
                    this.addMatches(headerName, MisspelledHeaderInspection.this.CUSTOM_HEADERS, matches);
                    this.addMatches(headerName, MisspelledHeaderInspection.this.myRepository.getAllHeaderNames(), matches);
                    Suggestion bestMatch = (Suggestion)ContainerUtil.getFirstItem(matches);
                    if (bestMatch != null && headerName.equals(bestMatch.getWord())) {
                        return;
                    }
                    ArrayList<AbstractManifestQuickFix> fixes = new ArrayList<AbstractManifestQuickFix>();
                    for (Suggestion match : matches) {
                        fixes.add(new HeaderRenameQuickFix(header, match.getWord()));
                        if (fixes.size() != 5) continue;
                        break;
                    }
                    if (bestMatch == null || bestMatch.getMetrics() > 2) {
                        fixes.add(new CustomHeaderQuickFix(header, MisspelledHeaderInspection.this.CUSTOM_HEADERS));
                    }
                    holder.registerProblem((PsiElement)header.getNameElement(), ManifestBundle.message("inspection.header.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }

            private void addMatches(String headerName, Collection<String> headers, SortedSet<? super Suggestion> matches) {
                for (String candidate : headers) {
                    int distance = EditDistance.optimalAlignment((CharSequence)headerName, (CharSequence)candidate, (boolean)false);
                    if (distance > 4) continue;
                    matches.add((Suggestion)new Suggestion(candidate, distance));
                }
            }
        };
        if (psiElementVisitor == null) {
            MisspelledHeaderInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel(this.CUSTOM_HEADERS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomHeaderQuickFix
    extends AbstractManifestQuickFix {
        private final String myHeaderName;
        private final Collection<? super String> myHeaders;

        private CustomHeaderQuickFix(Header header, Collection<? super String> headers) {
            super((PsiElement)header);
            this.myHeaderName = header.getName();
            this.myHeaders = headers;
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.header.remember.fix", this.myHeaderName);
            if (string == null) {
                CustomHeaderQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                CustomHeaderQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                CustomHeaderQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                CustomHeaderQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                CustomHeaderQuickFix.$$$reportNull$$$0(4);
            }
            this.myHeaders.add(this.myHeaderName);
            ProjectInspectionProfileManager.getInstance((Project)project2).fireProfileChanged();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HeaderRenameQuickFix
    extends AbstractManifestQuickFix {
        private final String myNewName;

        private HeaderRenameQuickFix(Header header, String newName) {
            super((PsiElement)header);
            this.myNewName = newName;
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.header.rename.fix", this.myNewName);
            if (string == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(4);
            }
            ((Header)startElement).setName(this.myNewName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OptionsPanel
    extends JPanel {
        OptionsPanel(final Set<? super String> headers) {
            super(new BorderLayout(5, 5));
            this.add((Component)new JLabel(ManifestBundle.message("inspection.header.ui.label", new Object[0])), "North");
            final JTextArea area = new JTextArea("");
            this.add((Component)area, "Center");
            if (!headers.isEmpty()) {
                area.setText(StringUtil.join(new TreeSet<String>(headers), (String)"\n"));
            }
            area.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    headers.clear();
                    for (String line : StringUtil.split((String)area.getText(), (String)"\n")) {
                        String header = line.trim();
                        if (header.isEmpty()) continue;
                        headers.add(header);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$OptionsPanel$1", "textChanged"));
                }
            });
        }
    }
}

