/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u001c\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002\u001a$\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002\u001a\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u000b*\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a8\u0006\u0011"}, d2={"getDirectoryTree", "", "dir", "Ljava/nio/file/Path;", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "excluded", "", "", "getIndentString", "printFile", "file", "sortedFileList", "", "intellij.platform.testFramework"})
public final class FileTreePrinterKt {
    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $receiver, @NotNull Set<String> excluded) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(excluded, (String)"excluded");
        StringBuilder sb = new StringBuilder();
        FileTreePrinterKt.getDirectoryTree($receiver, 0, sb, excluded);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String getDirectoryTree$default(Path path, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        return FileTreePrinterKt.getDirectoryTree(path, set);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $receiver) {
        return FileTreePrinterKt.getDirectoryTree$default($receiver, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void getDirectoryTree(Path dir, int indent, StringBuilder sb, Set<String> excluded) {
        List list;
        List<Path> list2 = FileTreePrinterKt.sortedFileList(dir);
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = list2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                if (!(!excluded.contains(((Object)it.getFileName()).toString()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list3 = UtilKt.nullize(list);
        if (list3 == null) {
            return;
        }
        List fileList = list3;
        FileTreePrinterKt.getIndentString(indent, sb);
        sb.append("\u251c\u2500\u2500");
        sb.append(((Object)dir.getFileName()).toString());
        sb.append("/");
        sb.append("\n");
        for (Path file : fileList) {
            if (PathKt.isDirectory((Path)file)) {
                FileTreePrinterKt.getDirectoryTree(file, indent + 1, sb, excluded);
                continue;
            }
            FileTreePrinterKt.printFile(file, indent + 1, sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<Path> sortedFileList(Path dir) {
        ArrayList arrayList;
        Path $receiver$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($receiver$iv);
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl = false;
                ArrayList list = new ArrayList();
                Iterable $receiver$iv2 = stream;
                for (Object item$iv : $receiver$iv2) {
                    void var14_17;
                    void it;
                    Path path = (Path)item$iv;
                    Collection collection = list;
                    boolean bl2 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    collection.add(var14_17);
                }
                CollectionsKt.sort((List)list);
                ArrayList arrayList2 = list;
                arrayList = arrayList2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            arrayList = null;
        }
        return arrayList;
    }

    private static final void printFile(Path file, int indent, StringBuilder sb) {
        FileTreePrinterKt.getIndentString(indent, sb);
        sb.append("\u251c\u2500\u2500");
        String fileName = ((Object)file.getFileName()).toString();
        sb.append(fileName);
        sb.append("\n");
        if (!StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null)) {
            sb.append(PathKt.readChars((Path)file)).append("\n\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void getIndentString(int indent, StringBuilder sb) {
        int n = 0;
        int n2 = indent;
        while (n < n2) {
            void i;
            sb.append("  ");
            ++i;
        }
    }
}

