/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Extensions.cleanRootArea((Disposable)this.getTestRootDisposable());
    }

    public static MockApplicationEx getApplication() {
        return (MockApplicationEx)ApplicationManager.getApplication();
    }

    public void initApplication() {
        MockApplicationEx instance2 = new MockApplicationEx(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)instance2, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        PlatformLiteFixture.getApplication().registerService(EncodingManager.class, EncodingManagerImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myProject = null;
        try {
            super.tearDown();
        }
        finally {
            PlatformLiteFixture.clearFields((Object)this);
        }
    }

    protected <T> void registerExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull T t) {
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(0);
        }
        if (t == null) {
            PlatformLiteFixture.$$$reportNull$$$0(1);
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, t);
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> name2, @NotNull T t) {
        if (area == null) {
            PlatformLiteFixture.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            PlatformLiteFixture.$$$reportNull$$$0(3);
        }
        if (t == null) {
            PlatformLiteFixture.$$$reportNull$$$0(4);
        }
        this.registerExtensionPoint(area, name2, t.getClass());
        PlatformTestUtil.registerExtension(area, name2, t, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(5);
        }
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(6);
        }
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            PlatformLiteFixture.$$$reportNull$$$0(7);
        }
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(9);
        }
        if (!area.hasExtensionPoint(extensionPointName)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(extensionPointName, aClass.getName(), kind, this.getTestRootDisposable());
        }
    }

    protected void registerComponentImplementation(MutablePicoContainer container, Class<?> key, Class<?> implementation) {
        container.unregisterComponent(key);
        container.registerComponentImplementation(key, implementation);
    }

    public static <T> T registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        Object old = container.getComponentInstance(key);
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
        return (T)old;
    }

    public static <T> T registerComponentInstance(ComponentManager container, Class<T> key, T implementation) {
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)container.getPicoContainer(), key, implementation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/PlatformLiteFixture";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExtension";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExtensionPoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

