/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.PlatformLiteFixture;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;

public abstract class ParsingTestCase
extends PlatformLiteFixture {
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(0);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(1);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(2);
        }
        this(dataPath, fileExt, false, definitions);
    }

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(3);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(4);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(5);
        }
        this.myFilePrefix = "";
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        ComponentAdapter component = ParsingTestCase.getApplication().getPicoContainer().getComponentAdapter((Object)ProgressManager.class.getName());
        if (component == null) {
            ParsingTestCase.getApplication().getPicoContainer().registerComponent((ComponentAdapter)new AbstractComponentAdapter(ProgressManager.class.getName(), Object.class){

                public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                    return new ProgressManagerImpl();
                }

                public void verify(PicoContainer container) throws PicoIntrospectionException {
                }
            });
        }
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager((Project)this.myProject);
        this.myFileFactory = new PsiFileFactoryImpl((PsiManager)this.myPsiManager);
        MutablePicoContainer appContainer = ParsingTestCase.getApplication().getPicoContainer();
        ParsingTestCase.registerComponentInstance(appContainer, MessageBus.class, ParsingTestCase.getApplication().getMessageBus());
        ParsingTestCase.registerComponentInstance(appContainer, SchemeManagerFactory.class, new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        ParsingTestCase.registerComponentInstance(appContainer, EditorFactory.class, editorFactory);
        ParsingTestCase.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(charSequence -> editorFactory.createDocument((CharSequence)charSequence), FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY));
        ParsingTestCase.registerComponentInstance(appContainer, PsiDocumentManager.class, new MockPsiDocumentManager());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl((Project)this.myProject, (CachedValuesFactory)new PsiCachedValuesFactory((PsiManager)this.myPsiManager)));
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(StartupManager.class, new StartupManagerImpl((Project)this.myProject));
        this.registerExtensionPoint(FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        this.registerExtensionPoint(MetaLanguage.EP_NAME, MetaLanguage.class);
        for (ParserDefinition definition : this.myDefinitions) {
            this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
        }
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
        }
        PomModelImpl pomModel = new PomModelImpl((Project)this.myProject);
        this.myProject.registerService(PomModel.class, pomModel);
        new TreeAspect((PomModel)pomModel);
    }

    public void configureFromParserDefinition(ParserDefinition definition, String extension) {
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension;
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, this.myLanguage, (Object)definition);
        ParsingTestCase.registerComponentInstance(ParsingTestCase.getApplication().getPicoContainer(), FileTypeManager.class, new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected <T> void addExplicitExtension(LanguageExtension<T> instance2, Language language, T object) {
        instance2.addExplicitExtension(language, object);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> instance2.removeExplicitExtension(language, object));
    }

    @Override
    protected <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        if (extensionPointName == null) {
            ParsingTestCase.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            ParsingTestCase.$$$reportNull$$$0(7);
        }
        super.registerExtensionPoint(extensionPointName, aClass);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> Extensions.getRootArea().unregisterExtensionPoint(extensionPointName.getName()));
    }

    protected <T> void registerApplicationService(Class<T> aClass, T object) {
        ParsingTestCase.getApplication().registerService(aClass, object);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> ParsingTestCase.getApplication().getPicoContainer().unregisterComponent((Object)aClass.getName()));
    }

    @NotNull
    public MockProjectEx getProject() {
        MockProjectEx mockProjectEx = this.myProject;
        if (mockProjectEx == null) {
            ParsingTestCase.$$$reportNull$$$0(8);
        }
        return mockProjectEx;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFile = null;
        this.myProject = null;
        this.myPsiManager = null;
        this.myFileFactory = null;
        super.tearDown();
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        String string = this.getTestName(this.myLowercaseFirstLetter);
        if (string == null) {
            ParsingTestCase.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void ensureNoErrorElements() {
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private static final int TAB_WIDTH = 8;

            public void visitErrorElement(PsiErrorElement element) {
                String text = ParsingTestCase.this.myFile.getText();
                String[] lines = StringUtil.splitByLinesKeepSeparators((String)text);
                int offset = element.getTextOffset();
                LineColumn position = StringUtil.offsetToLineColumn((CharSequence)text, (int)offset);
                int lineNumber = position != null ? position.line : -1;
                int column = position != null ? position.column : 0;
                String line = StringUtil.trimTrailing((String)lines[lineNumber]);
                int numIndentTabs = StringUtil.countChars((CharSequence)line.subSequence(0, column), (char)'\t', (int)0, (boolean)true);
                int indentedColumn = column + numIndentTabs * 7;
                String lineWithNoTabs = StringUtil.repeat((String)" ", (int)(numIndentTabs * 8)) + line.substring(numIndentTabs).replace('\t', ' ');
                String errorUnderline = StringUtil.repeat((String)" ", (int)indentedColumn) + StringUtil.repeat((String)"^", (int)Math.max(1, element.getTextLength()));
                TestCase.fail((String)String.format("Unexpected error element: %s:%d:%d\n\n%s\n%s\n%s", ParsingTestCase.this.myFile.getName(), lineNumber + 1, column, lineWithNoTabs, errorUnderline, element.getErrorDescription()));
            }
        });
    }

    protected void doTest(boolean checkResult) {
        this.doTest(checkResult, false);
    }

    protected void doTest(boolean checkResult, boolean ensureNoErrorElements) {
        String name2 = this.getTestName();
        try {
            String text = this.loadFile(name2 + "." + this.myFileExt);
            this.myFile = this.createPsiFile(name2, text);
            ParsingTestCase.ensureParsed(this.myFile);
            ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
            ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text, (Object)LoadTextUtil.loadText((VirtualFile)this.myFile.getVirtualFile()));
            ParsingTestCase.assertEquals((String)"doc text mismatch", (String)text, (String)Objects.requireNonNull(this.myFile.getViewProvider().getDocument()).getText());
            ParsingTestCase.assertEquals((String)"psi text mismatch", (String)text, (String)this.myFile.getText());
            ParsingTestCase.ensureCorrectReparse(this.myFile);
            if (checkResult) {
                this.checkResult(name2, this.myFile);
                if (ensureNoErrorElements) {
                    this.ensureNoErrorElements();
                }
            } else {
                ParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doTest(String suffix) throws IOException {
        String name2 = this.getTestName();
        String text = this.loadFile(name2 + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name2, text);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)text, (String)this.myFile.getText());
        this.checkResult(name2 + suffix, this.myFile);
    }

    protected void doCodeTest(@NotNull String code) throws IOException {
        if (code == null) {
            ParsingTestCase.$$$reportNull$$$0(10);
        }
        String name2 = this.getTestName();
        this.myFile = this.createPsiFile("a", code);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)code, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name2, this.myFile);
    }

    protected PsiFile createPsiFile(@NotNull String name2, @NotNull String text) {
        if (name2 == null) {
            ParsingTestCase.$$$reportNull$$$0(11);
        }
        if (text == null) {
            ParsingTestCase.$$$reportNull$$$0(12);
        }
        return this.createFile(name2 + "." + this.myFileExt, text);
    }

    protected PsiFile createFile(@NotNull String name2, @NotNull String text) {
        if (name2 == null) {
            ParsingTestCase.$$$reportNull$$$0(13);
        }
        if (text == null) {
            ParsingTestCase.$$$reportNull$$$0(14);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, this.myLanguage, (CharSequence)text);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        return this.createFile(virtualFile);
    }

    protected PsiFile createFile(@NotNull LightVirtualFile virtualFile) {
        if (virtualFile == null) {
            ParsingTestCase.$$$reportNull$$$0(15);
        }
        return this.myFileFactory.trySetupPsiForFile(virtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NotNull String targetDataName, @NotNull PsiFile file) throws IOException {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(16);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(17);
        }
        ParsingTestCase.doCheckResult(this.myFullDataPath, file, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges(), this.allTreesInSingleFile());
    }

    protected boolean allTreesInSingleFile() {
        return false;
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges) {
        if (testDataDir == null) {
            ParsingTestCase.$$$reportNull$$$0(18);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(19);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(20);
        }
        ParsingTestCase.doCheckResult(testDataDir, file, checkAllPsiRoots, targetDataName, skipSpaces, printRanges, false);
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges, boolean allTreesInSingleFile) {
        if (testDataDir == null) {
            ParsingTestCase.$$$reportNull$$$0(21);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(22);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(23);
        }
        FileViewProvider provider = file.getViewProvider();
        Set languages = provider.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            ParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", ParsingTestCase.toParseTreeText((PsiElement)file, skipSpaces, printRanges).trim());
            return;
        }
        if (allTreesInSingleFile) {
            String expectedName = targetDataName + ".txt";
            StringBuilder sb = new StringBuilder();
            ArrayList languagesList = new ArrayList(languages);
            ContainerUtil.sort(languagesList, Comparator.comparing(Language::getID));
            for (Language language : languagesList) {
                sb.append("Subtree: ").append(language.getDisplayName()).append(" (").append(language.getID()).append(")").append("\n").append(ParsingTestCase.toParseTreeText((PsiElement)provider.getPsi(language), skipSpaces, printRanges).trim()).append("\n").append(StringUtil.repeat((String)"-", (int)80)).append("\n");
            }
            ParsingTestCase.doCheckResult(testDataDir, expectedName, sb.toString());
        } else {
            for (Language language : languages) {
                PsiFile root = provider.getPsi(language);
                String expectedName = targetDataName + "." + language.getID() + ".txt";
                ParsingTestCase.doCheckResult(testDataDir, expectedName, ParsingTestCase.toParseTreeText((PsiElement)root, skipSpaces, printRanges).trim());
            }
        }
    }

    protected void checkResult(@NotNull String actual) {
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(24);
        }
        String name2 = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name2 + ".txt", actual);
    }

    protected void checkResult(@NotNull String targetDataName, @NotNull String actual) {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(25);
        }
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(26);
        }
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual);
    }

    public static void doCheckResult(@NotNull String fullPath, @NotNull String targetDataName, @NotNull String actual) {
        if (fullPath == null) {
            ParsingTestCase.$$$reportNull$$$0(27);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(28);
        }
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(29);
        }
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        UsefulTestCase.assertSameLinesWithFile(expectedFileName, actual);
    }

    protected static String toParseTreeText(@NotNull PsiElement file, boolean skipSpaces, boolean printRanges) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(30);
        }
        return DebugUtil.psiToString((PsiElement)file, (boolean)skipSpaces, (boolean)printRanges);
    }

    protected String loadFile(@NotNull String name2) throws IOException {
        if (name2 == null) {
            ParsingTestCase.$$$reportNull$$$0(31);
        }
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, name2);
    }

    public static String loadFileDefault(@NotNull String dir, @NotNull String name2) throws IOException {
        if (dir == null) {
            ParsingTestCase.$$$reportNull$$$0(32);
        }
        if (name2 == null) {
            ParsingTestCase.$$$reportNull$$$0(33);
        }
        return FileUtil.loadFile((File)new File(dir, name2), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(@NotNull PsiFile file) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(34);
        }
        file.accept(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(35);
        }
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)file, (boolean)false, (boolean)false);
        DebugUtil.performPsiModification((String)"ensureCorrectReparse", () -> {
            String fileText = file.getText();
            DiffLog diffLog = new BlockSupportImpl(file.getProject()).reparseRange(file, file.getNode(), TextRange.allOf((String)fileText), (CharSequence)fileText, (ProgressIndicator)new EmptyProgressIndicator(), (CharSequence)fileText);
            diffLog.performActualPsiChange(file);
        });
        ParsingTestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file, (boolean)false, (boolean)false));
    }

    public void registerMockInjectedLanguageManager() {
        this.registerExtensionPoint(Extensions.getArea((AreaInstance)this.myProject), MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME, MultiHostInjector.class);
        this.registerExtensionPoint(LanguageInjector.EXTENSION_POINT_NAME, LanguageInjector.class);
        this.myProject.registerService(InjectedLanguageManager.class, new InjectedLanguageManagerImpl((Project)this.myProject, (DumbService)new MockDumbService((Project)this.myProject)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 11: 
            case 13: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDataName";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 30: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCodeTest";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doCheckResult";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toParseTreeText";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "loadFileDefault";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "ensureParsed";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

