/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        String selectedText;
        if (project2 == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor.getUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY) == null) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                StructuralSearchTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (c == '$' && !StringUtil.isEmpty((String)(selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText())) && !selectedText.contains("$")) {
            boolean multipleCarets;
            Document document = editor.getDocument();
            SmartList rangeMarkers = new SmartList();
            rangeMarkers.add(document.createRangeMarker(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            CaretModel caretModel = editor.getCaretModel();
            boolean bl = multipleCarets = caretModel.getCaretCount() != 1;
            if (!multipleCarets) {
                PsiTreeUtil.processElements((PsiElement)file, arg_0 -> StructuralSearchTypedHandler.lambda$beforeSelectionRemoved$0(selectedText, (List)rangeMarkers, document, arg_0));
            }
            String newText = c + selectedText + c;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            for (RangeMarker marker : rangeMarkers) {
                if (!marker.isValid()) continue;
                document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)newText);
                if (!multipleCarets) continue;
                int startOffset = marker.getStartOffset() + 1;
                int endOffset = startOffset + selectedText.length();
                selectionModel.setSelection(ltrSelection ? startOffset : endOffset, ltrSelection ? endOffset : startOffset);
                caretModel.moveToOffset(ltrSelection ? endOffset : startOffset);
            }
            if (!multipleCarets) {
                SmartList newCaretStates = new SmartList();
                for (RangeMarker marker : rangeMarkers) {
                    int startOffset = marker.getStartOffset() + 1;
                    int endOffset = startOffset + selectedText.length();
                    LogicalPosition selectionStart = editor.offsetToLogicalPosition(ltrSelection ? startOffset : endOffset);
                    LogicalPosition selectionEnd = editor.offsetToLogicalPosition(ltrSelection ? endOffset : startOffset);
                    LogicalPosition caretPosition = editor.offsetToLogicalPosition(ltrSelection ? endOffset : startOffset);
                    CaretState state = new CaretState(caretPosition, selectionStart, selectionEnd);
                    newCaretStates.add(state);
                }
                caretModel.setCaretsAndSelections((List)newCaretStates);
            }
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                StructuralSearchTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeSelectionRemoved(c, project2, editor, file);
        if (result == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$beforeSelectionRemoved$0(String selectedText, List rangeMarkers, Document document, PsiElement element) {
        if (StructuralSearchUtil.isIdentifier(element) && element.getText().equals(selectedText)) {
            rangeMarkers.add(document.createRangeMarker(element.getTextRange()));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

