/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper {
    @NonNls
    private static final String SEARCH_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String REPLACE_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String RECURSIVE_STATE = "structural.search.recursive";
    @NonNls
    private static final String MATCH_CASE_STATE = "structural.search.match.case";
    @NonNls
    private static final String SHORTEN_FQN_STATE = "structural.search.shorten.fqn";
    @NonNls
    private static final String REFORMAT_STATE = "structural.search.reformat";
    @NonNls
    private static final String USE_STATIC_IMPORT_STATE = "structural.search.use.static.import";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH = Key.create((String)"STRUCTURAL_SEARCH_AREA");
    public static final String USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
    private final SearchContext mySearchContext;
    boolean myReplace;
    Configuration myConfiguration;
    @NonNls
    FileType myFileType = StructuralSearchUtil.getDefaultFileType();
    Language myDialect = null;
    String myContext = null;
    private final Alarm myAlarm;
    private boolean myUseLastConfiguration;
    private final boolean myEditConfigOnly;
    private boolean myDoingOkAction;
    boolean myFilterButtonEnabled = false;
    JCheckBox myRecursive;
    private JCheckBox myMatchCase;
    private JCheckBox myShortenFQN;
    private JCheckBox myReformat;
    private JCheckBox myUseStaticImport;
    FileTypeSelector myFileTypesComboBox;
    ActionToolbarImpl myOptionsToolbar;
    EditorTextField mySearchCriteriaEdit;
    EditorTextField myReplaceCriteriaEdit;
    OnePixelSplitter mySearchEditorPanel;
    private OnePixelSplitter myReplaceEditorPanel;
    FilterPanel myFilterPanel;
    private LinkComboBox myTargetComboBox;
    private ScopePanel myScopePanel;
    private JCheckBox myOpenInNewTab;
    JComponent myReplacePanel;

    public StructuralSearchDialog(SearchContext searchContext, boolean replace) {
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        super(searchContext.getProject(), true);
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.myEditConfigOnly = editConfigOnly;
        this.mySearchContext = searchContext;
        this.myConfiguration = this.createConfiguration(null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "projectClosing"));
            }
        });
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.myUseLastConfiguration = useLastConfiguration;
    }

    private EditorTextField createEditor(String text) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile2 != null);
        Document document = profile2.createDocument(this.getProject(), this.myFileType, this.myDialect, text);
        EditorTextField textField = new EditorTextField(document, this.getProject(), this.myFileType, false, false){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                assert (profile2 != null);
                TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)profile2.getTemplateContextType());
                SubstitutionShortInfoHandler.install((Editor)editor, variableName -> {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, StructuralSearchDialog.this.myConfiguration));
                    if (StructuralSearchDialog.this.isFilterPanelEnabled()) {
                        StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)variableName);
                    }
                });
                editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
                Project project2 = this.getProject();
                PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(this.getDocument());
                if (file != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled(file, false);
                }
                TextCompletionUtil.installCompletionHint((EditorEx)editor);
                editor.putUserData(STRUCTURAL_SEARCH, (Object)StructuralSearchDialog.this);
                editor.setEmbeddedIntoDialogWrapper(true);
                return editor;
            }

            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "updateBorder"));
            }
        };
        textField.setPreferredSize(new Dimension(850, 150));
        textField.setMinimumSize(new Dimension(200, 50));
        textField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.initiateValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "documentChanged"));
            }
        });
        return textField;
    }

    void initiateValidation() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            try {
                boolean valid = this.isValid();
                boolean compiled = this.isCompiled();
                JRootPane component = this.getRootPane();
                if (component == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myFilterButtonEnabled = compiled;
                    this.setSearchTargets(this.myConfiguration.getMatchOptions());
                    this.getOKAction().setEnabled(valid);
                }, ModalityState.stateForComponent((Component)component));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
            }
        }, 250);
    }

    private boolean isCompiled() {
        try {
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.getProject(), this.myConfiguration.getMatchOptions(), false);
            if (compiledPattern != null) {
                this.myFilterPanel.setCompiledPattern(compiledPattern);
                if (!this.myFilterPanel.isInitialized()) {
                    this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
                }
            }
            return compiledPattern != null;
        }
        catch (MalformedPatternException e) {
            return false;
        }
    }

    private void detectFileType() {
        Language language;
        StructuralSearchProfile profile2;
        PsiFile file;
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        PsiFile context = file = this.mySearchContext.getFile();
        Editor editor = this.mySearchContext.getEditor();
        if (editor != null && context != null) {
            int offset = editor.getCaretModel().getOffset();
            context = InjectedLanguageManager.getInstance((Project)this.getProject()).findInjectedElementAt(file, offset);
            if (context == null) {
                context = file.findElementAt(offset);
            }
            if (context != null) {
                context = context.getParent();
            }
        }
        if (context != null && (profile2 = StructuralSearchUtil.getProfileByLanguage(language = context.getLanguage())) != null) {
            FileType fileType = profile2.detectFileType((PsiElement)context);
            this.myFileType = fileType != null ? fileType : language.getAssociatedFileType();
        }
    }

    private Configuration createConfiguration(Configuration template) {
        if (this.myReplace) {
            return template == null ? new ReplaceConfiguration(USER_DEFINED, USER_DEFINED) : new ReplaceConfiguration(template);
        }
        return template == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(template);
    }

    private void setTextFromContext() {
        SelectionModel selectionModel;
        String selectedText;
        Editor editor = this.mySearchContext.getEditor();
        if (editor != null && (selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(selectedText)) {
                return;
            }
            String text = selectedText.trim();
            this.setTextForEditor(text.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.setTextForEditor(text, this.myReplaceCriteriaEdit);
            }
            this.myScopePanel.setScope(null);
            ApplicationManager.getApplication().invokeLater(() -> this.startTemplate());
            return;
        }
        Configuration configuration = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration();
        if (configuration != null) {
            this.loadConfiguration(configuration);
        }
    }

    private void setTextForEditor(String text, EditorTextField editor) {
        editor.setText(text);
        editor.selectAll();
        Project project2 = this.getProject();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document);
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{file}).run(() -> CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, new TextRange(0, document.getTextLength())));
    }

    private void startSearching() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.mySearchContext).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        }
    }

    @NotNull
    String getDefaultTitle() {
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.myReplaceEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchEditorPanel.getDivider().setOpaque(false);
        this.mySearchCriteriaEdit = this.createEditor("");
        this.mySearchEditorPanel.setFirstComponent((JComponent)this.mySearchCriteriaEdit);
        this.mySearchEditorPanel.add("Center", (Component)this.mySearchCriteriaEdit);
        this.myReplacePanel = this.createReplacePanel();
        this.myReplacePanel.setVisible(this.myReplace);
        this.myScopePanel = new ScopePanel(this.getProject());
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.getProject()).getRecentDirectories());
            this.myScopePanel.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)scope -> this.initiateValidation()));
        } else {
            this.myScopePanel.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.getProject(), StructuralSearchUtil.getProfileByFileType(this.myFileType), this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initiateValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        JLabel searchTargetLabel = new JLabel(SSRBundle.message("search.target.label", new Object[0]));
        this.myTargetComboBox = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)item -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name2 : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(name2).setPartOfSearchResults(name2.equals(item));
            }
        }));
        JPanel centerPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(centerPanel);
        centerPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)this.mySearchEditorPanel).addComponent(this.myReplacePanel).addComponent(this.myScopePanel).addGroup(layout.createSequentialGroup().addComponent(searchTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)this.mySearchEditorPanel).addGap(2).addComponent(this.myReplacePanel).addComponent(this.myScopePanel, -2, -1, -2).addGap(16).addGroup(layout.createParallelGroup().addComponent(searchTargetLabel).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        return centerPanel;
    }

    private JComponent createReplacePanel() {
        JLabel label = new JLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.myShortenFQN = new JCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.myReformat = new JCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.myUseStaticImport = new JCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        this.myReplaceCriteriaEdit = this.createEditor("");
        this.myReplaceEditorPanel.setFirstComponent((JComponent)this.myReplaceCriteriaEdit);
        JPanel replacePanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(replacePanel);
        replacePanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 28, 28).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myShortenFQN).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.myReformat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.myUseStaticImport)).addComponent((Component)this.myReplaceEditorPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.myShortenFQN).addComponent(this.myReformat).addComponent(this.myUseStaticImport)).addComponent((Component)this.myReplaceEditorPanel));
        return replacePanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        DefaultActionGroup historyActionGroup = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("History", null, StructuralSearchDialog.getShowHistoryIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object source;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!((source = e.getInputEvent().getSource()) instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).getHistoryConfigurations()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<Configuration>(){

                    protected void customizeCellRenderer(@NotNull JList<? extends Configuration> list, Configuration value, int index, boolean selected, boolean hasFocus) {
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (value instanceof ReplaceConfiguration) {
                            this.setIcon(AllIcons.Actions.Replace);
                            this.append(StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)value.getMatchOptions().getSearchPattern()), (int)49, (int)0, (boolean)true) + " \u21d2 " + StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)value.getReplaceOptions().getReplacement()), (int)49, (int)0, (boolean)true));
                        } else {
                            this.setIcon(AllIcons.Actions.Find);
                            this.append(StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)value.getMatchOptions().getSearchPattern()), (int)100, (int)0, (boolean)true));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$4$1", "customizeCellRenderer"));
                    }
                }).setItemChosenCallback(c -> StructuralSearchDialog.this.loadConfiguration((Configuration)c)).setSelectionMode(0).createPopup().showUnderneathOf((Component)source);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$4", "actionPerformed"));
            }
        }});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbarImpl historyToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)historyActionGroup, true);
        historyToolbar.setLayoutPolicy(0);
        JLabel label = new JLabel(SSRBundle.message("search.template", new Object[0]));
        UIUtil.installCompleteMatchInfo(label, () -> this.myConfiguration, link -> this.showFilterPanel((String)link));
        this.myRecursive = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        this.myRecursive.setVisible(!this.myReplace);
        this.myMatchCase = new JCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]), true);
        ArrayList<FileType> types = new ArrayList<FileType>();
        for (FileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        Collections.sort(types, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.detectFileType();
        this.myFileTypesComboBox = new FileTypeSelector(types);
        this.myFileTypesComboBox.setMinimumAndPreferredWidth(200);
        this.myFileTypesComboBox.setSelectedItem(this.myFileType, this.myDialect, this.myContext);
        this.myFileTypesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FileTypeInfo item = StructuralSearchDialog.this.myFileTypesComboBox.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    StructuralSearchDialog.this.myFileType = item.getFileType();
                    StructuralSearchDialog.this.myDialect = item.getDialect();
                    StructuralSearchDialog.this.myContext = item.getContext();
                    StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                    assert (profile2 != null);
                    Document searchDocument = profile2.createDocument(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.mySearchCriteriaEdit.getText());
                    StructuralSearchDialog.this.mySearchCriteriaEdit.setNewDocumentAndFileType(StructuralSearchDialog.this.myFileType, searchDocument);
                    Document replaceDocument = profile2.createDocument(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myReplaceCriteriaEdit.getText());
                    StructuralSearchDialog.this.myReplaceCriteriaEdit.setNewDocumentAndFileType(StructuralSearchDialog.this.myFileType, replaceDocument);
                    StructuralSearchDialog.this.myFilterPanel.setProfile(profile2);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        });
        JLabel fileTypeLabel = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        fileTypeLabel.setLabelFor((Component)((Object)this.myFileTypesComboBox));
        DefaultActionGroup templateActionGroup = new DefaultActionGroup(new AnAction[]{new DumbAwareAction(SSRBundle.message("save.template.text.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$6", "actionPerformed"));
            }
        }, new CopyConfigurationAction(), new PasteConfigurationAction(), new DumbAwareAction(SSRBundle.message("copy.existing.template.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                SelectTemplateDialog dialog;
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (!(dialog = new SelectTemplateDialog(StructuralSearchDialog.this.getProject(), false, StructuralSearchDialog.this.myReplace)).showAndGet()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    StructuralSearchDialog.this.loadConfiguration(configurations[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7", "actionPerformed"));
            }
        }, Separator.getInstance(), new SwitchAction()});
        templateActionGroup.setPopup(true);
        templateActionGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        DumbAwareToggleAction filterAction = new DumbAwareToggleAction(null, "View variable filters", AllIcons.General.Filter){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                return StructuralSearchDialog.this.isFilterPanelEnabled();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                StructuralSearchDialog.this.setFilterPanelEnabled(state);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(2);
                }
                e.getPresentation().setEnabled(StructuralSearchDialog.this.myFilterButtonEnabled);
                super.update(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{filterAction, templateActionGroup});
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)optionsActionGroup, true);
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel northPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(northPanel);
        northPanel.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)historyToolbar, -2, -1, -2).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myRecursive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.myMatchCase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(fileTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myFileTypesComboBox), 125, -1, -2).addComponent((Component)this.myOptionsToolbar, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)historyToolbar).addComponent(label).addComponent(this.myRecursive).addComponent(this.myMatchCase).addComponent(fileTypeLabel).addComponent((Component)((Object)this.myFileTypesComboBox)).addComponent((Component)this.myOptionsToolbar));
        return northPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (this.myEditConfigOnly) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.myOpenInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.myOpenInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel.add((Component)this.myOpenInNewTab, "East");
        return panel;
    }

    Project getProject() {
        return this.mySearchContext.getProject();
    }

    public void show() {
        Dimension size;
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        if (!this.myUseLastConfiguration) {
            this.setTextFromContext();
        }
        super.show();
        DimensionService dimensionService = DimensionService.getInstance();
        Point location = dimensionService.getLocation(SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        if (location != null) {
            this.setLocation(location);
        }
        if ((size = dimensionService.getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.getProject())) != null) {
            this.setSize(size.width, size.height);
        } else {
            this.pack();
            Dimension otherSize = dimensionService.getSize(this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY, this.getProject());
            if (otherSize != null) {
                this.setSize(otherSize.width, this.getSize().height);
            }
        }
    }

    private void startTemplate() {
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder builder = new StructuralSearchTemplateBuilder(psiFile).buildTemplate();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> builder.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    protected void doOKAction() {
        this.myDoingOkAction = true;
        boolean result = this.isValid();
        this.myDoingOkAction = false;
        if (!result) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        SearchScope scope = this.myScopePanel.getScope();
        if (scope == null) {
            return;
        }
        super.doOKAction();
        if (this.myEditConfigOnly) {
            return;
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            FindInProjectSettings.getInstance((Project)this.getProject()).addDirectory(directoryScope.getDirectory().getPresentableUrl());
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(scope.getDisplayName());
        findSettings.setShowResultsInSeparateView(this.myOpenInNewTab.isSelected());
        try {
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.startSearching();
        }
        catch (MalformedPatternException ex) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", ex.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    public Configuration getConfiguration() {
        this.saveConfiguration();
        return this.myConfiguration;
    }

    private boolean isValid() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        try {
            Matcher.validate(this.getProject(), matchOptions);
        }
        catch (MalformedPatternException e) {
            String message = StringUtil.isEmpty((String)matchOptions.getSearchPattern()) ? null : SSRBundle.message("this.pattern.is.malformed.message", e.getMessage() != null ? e.getMessage() : "");
            this.reportMessage(message, true, (JComponent)this.mySearchCriteriaEdit);
            return false;
        }
        catch (UnsupportedPatternException e) {
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", e.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
            return false;
        }
        catch (NoMatchFoundException e) {
            this.reportMessage(e.getMessage(), false, this.myScopePanel);
            return false;
        }
        this.reportMessage(null, false, (JComponent)this.mySearchCriteriaEdit);
        if (this.myReplace) {
            try {
                Replacer.checkSupportedReplacementPattern(this.getProject(), this.myConfiguration.getReplaceOptions());
            }
            catch (UnsupportedPatternException ex) {
                this.reportMessage(SSRBundle.message("unsupported.replacement.pattern.message", ex.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                return false;
            }
            catch (MalformedPatternException ex) {
                this.reportMessage(SSRBundle.message("malformed.replacement.pattern.message", ex.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                return false;
            }
        }
        this.reportMessage(null, false, (JComponent)this.myReplaceCriteriaEdit);
        return this.myEditConfigOnly || this.myScopePanel.getScope() != null;
    }

    void reportMessage(String message, boolean error, JComponent component) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            component.putClientProperty("JComponent.outline", !error || message == null ? null : "error");
            component.repaint();
            if (message == null) {
                return;
            }
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            if (component != this.myScopePanel) {
                balloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            } else {
                balloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, 0)), Balloon.Position.above);
            }
            balloon.showInCenterOf(component);
            Disposer.register((Disposable)this.myDisposable, (Disposable)balloon);
        });
    }

    void securityCheck() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        for (String name2 : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name2);
            if (!this.showSecurityMessage(constraint)) continue;
            return;
        }
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (replaceOptions != null) {
            for (ReplacementVariableDefinition variableDefinition : replaceOptions.getVariableDefinitions()) {
                if (!this.showSecurityMessage(variableDefinition)) continue;
                return;
            }
        }
    }

    private boolean showSecurityMessage(NamedScriptableDefinition constraint) {
        if (constraint.getScriptCodeConstraint().length() <= 2) {
            return false;
        }
        EdtInvocationManager.getInstance().invokeLater(() -> this.reportMessage(SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName()), false, (JComponent)this.myOptionsToolbar));
        return true;
    }

    public void showFilterPanel(String variableName) {
        if (this.myFilterButtonEnabled) {
            this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
            this.setFilterPanelEnabled(true);
            this.myConfiguration.setCurrentVariableName(variableName);
        }
    }

    void setFilterPanelEnabled(boolean enabled) {
        if (enabled) {
            if (!this.isFilterPanelEnabled()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelEnabled()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    boolean isFilterPanelEnabled() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void setSearchTargets(MatchOptions matchOptions) {
        ArrayList<String> names = new ArrayList<String>(matchOptions.getVariableConstraintNames());
        names.remove("__context__");
        names.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItems(names);
        if (names.size() > 1) {
            this.myTargetComboBox.setEnabled(true);
            for (String name2 : names) {
                MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name2);
                if (constraint == null || !constraint.isPartOfSearchResults()) continue;
                this.myTargetComboBox.setSelectedItem(name2);
                break;
            }
        } else {
            this.myTargetComboBox.setEnabled(false);
        }
    }

    boolean loadConfiguration(String text) {
        if (text == null) {
            return false;
        }
        Configuration configuration = ConfigurationUtil.fromXml(text);
        if (configuration == null) {
            return false;
        }
        this.loadConfiguration(configuration);
        this.securityCheck();
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        this.myConfiguration = this.createConfiguration(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.setSearchTargets(matchOptions);
        SearchScope scope = matchOptions.getScope();
        if (scope != null) {
            this.myScopePanel.setScope(scope);
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        this.myMatchCase.setSelected(matchOptions.isCaseSensitiveMatch());
        this.myFileTypesComboBox.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor searchEditor = this.mySearchCriteriaEdit.getEditor();
        if (searchEditor != null) {
            searchEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            if (configuration instanceof ReplaceConfiguration) {
                ReplaceOptions replaceOptions = configuration.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
                this.myShortenFQN.setSelected(replaceOptions.isToShortenFQN());
                this.myReformat.setSelected(replaceOptions.isToReformatAccordingToStyle());
                this.myUseStaticImport.setSelected(replaceOptions.isToUseStaticImport());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
                this.myShortenFQN.setSelected(properties.getBoolean(SHORTEN_FQN_STATE));
                this.myReformat.setSelected(properties.getBoolean(REFORMAT_STATE));
                this.myUseStaticImport.setSelected(properties.getBoolean(USE_STATIC_IMPORT_STATE));
            }
            Editor replaceEditor = this.myReplaceCriteriaEdit.getEditor();
            if (replaceEditor != null) {
                replaceEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
            }
            this.myRecursive.setSelected(false);
        } else if (configuration instanceof ReplaceConfiguration) {
            this.myRecursive.setSelected(properties.getBoolean(RECURSIVE_STATE));
        }
    }

    private void saveConfiguration() {
        SearchScope scope;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.myEditConfigOnly && (scope = this.myScopePanel.getScope()) != null) {
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scope.getDisplayName());
            matchOptions.setScope((SearchScope)(searchWithinHierarchy && !this.myDoingOkAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : scope));
        }
        matchOptions.setFileType(this.myFileType);
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myContext);
        matchOptions.setSearchPattern(this.mySearchCriteriaEdit.getDocument().getText());
        matchOptions.setCaseSensitiveMatch(this.myMatchCase.isSelected());
        if (this.myReplace) {
            ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
            replaceOptions.setReplacement(this.myReplaceCriteriaEdit.getDocument().getText());
            replaceOptions.setToShortenFQN(this.myShortenFQN.isSelected());
            replaceOptions.setToReformatAccordingToStyle(this.myReformat.isSelected());
            replaceOptions.setToUseStaticImport(this.myUseStaticImport.isSelected());
        } else {
            matchOptions.setRecursiveSearch(this.myRecursive.isSelected());
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            properties.setValue(SHORTEN_FQN_STATE, this.myShortenFQN.isSelected());
            properties.setValue(REFORMAT_STATE, this.myReformat.isSelected());
            properties.setValue(USE_STATIC_IMPORT_STATE, this.myUseStaticImport.isSelected());
        } else {
            properties.setValue(RECURSIVE_STATE, this.myRecursive.isSelected());
            properties.setValue(MATCH_CASE_STATE, this.myMatchCase.isSelected());
        }
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void dispose() {
        if (this.myReplace) {
            this.storeDimensions(REPLACE_DIMENSION_SERVICE_KEY, SEARCH_DIMENSION_SERVICE_KEY);
        } else {
            this.storeDimensions(SEARCH_DIMENSION_SERVICE_KEY, REPLACE_DIMENSION_SERVICE_KEY);
        }
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
        this.myAlarm.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        super.dispose();
    }

    private void storeDimensions(String key1, String key2) {
        Dimension size = this.getSize();
        DimensionService dimensionService = DimensionService.getInstance();
        dimensionService.setLocation(SEARCH_DIMENSION_SERVICE_KEY, this.getLocation(), this.getProject());
        dimensionService.setSize(key1, size, this.getProject());
        Dimension otherSize = dimensionService.getSize(key2);
        if (otherSize != null && otherSize.width != size.width) {
            otherSize.width = size.width;
            dimensionService.setSize(key2, otherSize, this.getProject());
        }
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    private static Icon getShowHistoryIcon() {
        return AllIcons.Actions.SearchWithHistory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog", "getDefaultTitle"));
    }

    private class PasteConfigurationAction
    extends AnAction
    implements DumbAware {
        PasteConfigurationAction() {
            super(SSRBundle.message("import.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String contents;
            if (e == null) {
                PasteConfigurationAction.$$$reportNull$$$0(0);
            }
            if (!StructuralSearchDialog.this.loadConfiguration(contents = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor))) {
                StructuralSearchDialog.this.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)StructuralSearchDialog.this.myOptionsToolbar);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$PasteConfigurationAction", "actionPerformed"));
        }
    }

    private class CopyConfigurationAction
    extends AnAction
    implements DumbAware {
        CopyConfigurationAction() {
            super(SSRBundle.message("export.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyConfigurationAction.$$$reportNull$$$0(0);
            }
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(StructuralSearchDialog.this.myConfiguration)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$CopyConfigurationAction", "actionPerformed"));
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        SwitchAction() {
            this.init();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchAction.$$$reportNull$$$0(0);
            }
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.myRecursive.setVisible(!StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension size = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.REPLACE_DIMENSION_SERVICE_KEY : StructuralSearchDialog.SEARCH_DIMENSION_SERVICE_KEY);
            if (size != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, size.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.init();
        }

        private void init() {
            this.getTemplatePresentation().setText(SSRBundle.message(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet searchShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet replaceShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet shortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{searchShortcutSet, replaceShortcutSet}) : new CompositeShortcutSet(new ShortcutSet[]{replaceShortcutSet, searchShortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)shortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction", "actionPerformed"));
        }
    }
}

