/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageFileAction
extends AnAction {
    private static final SyncDateFormat TIME_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("h:mm:ss a"));

    public PackageFileAction() {
        super(CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]), CompilerBundle.message((String)"action.description.package.file", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        List<VirtualFile> files;
        if (e == null) {
            PackageFileAction.$$$reportNull$$$0(0);
        }
        boolean visible = false;
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null && !(files = PackageFileAction.getFilesToPackage(e, project2)).isEmpty()) {
            visible = true;
            e.getPresentation().setText(files.size() == 1 ? CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]) : CompilerBundle.message((String)"action.name.package.files", (Object[])new Object[0]));
        }
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    private static List<VirtualFile> getFilesToPackage(@NotNull AnActionEvent e, @NotNull Project project2) {
        VirtualFile[] files;
        if (e == null) {
            PackageFileAction.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            PackageFileAction.$$$reportNull$$$0(2);
        }
        if ((files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                PackageFileAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        block0: for (VirtualFile file : files) {
            if (file == null || file.isDirectory() || fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) && compilerManager.isCompilableFileType(file.getFileType())) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    PackageFileAction.$$$reportNull$$$0(4);
                }
                return list;
            }
            Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project2).findArtifacts(file);
            for (Artifact artifact : artifacts) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result.add(file);
                continue block0;
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            PackageFileAction.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project2;
        if (event == null) {
            PackageFileAction.$$$reportNull$$$0(6);
        }
        if ((project2 = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files = PackageFileAction.getFilesToPackage(event, project2);
        Artifact[] allArtifacts = ArtifactManager.getInstance((Project)project2).getArtifacts();
        PackageFileWorker.startPackagingFiles(project2, files, allArtifacts, () -> PackageFileAction.setStatusText(project2, files));
    }

    private static void setStatusText(Project project2, List<VirtualFile> files) {
        if (!files.isEmpty()) {
            StringBuilder fileNames = new StringBuilder();
            for (VirtualFile file : files) {
                if (fileNames.length() != 0) {
                    fileNames.append(", ");
                }
                fileNames.append("'").append(file.getName()).append("'");
            }
            String time = TIME_FORMAT.format(Clock.getTime());
            String statusText = CompilerBundle.message((String)"status.text.file.has.been.packaged", (Object[])new Object[]{files.size(), fileNames, time});
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            if (statusBar != null) {
                statusBar.setInfo(statusText);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/ui/actions/PackageFileAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/ui/actions/PackageFileAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToPackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

