/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.ModulePackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUtil {
    private ArtifactUtil() {
    }

    public static CompositePackagingElement<?> copyFromRoot(@NotNull CompositePackagingElement<?> oldRoot, @NotNull Project project2) {
        if (oldRoot == null) {
            ArtifactUtil.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(1);
        }
        CompositePackagingElement newRoot = (CompositePackagingElement)ArtifactUtil.copyElement(oldRoot, project2);
        ArtifactUtil.copyChildren(oldRoot, newRoot, project2);
        return newRoot;
    }

    public static void copyChildren(CompositePackagingElement<?> oldParent, CompositePackagingElement<?> newParent, @NotNull Project project2) {
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(2);
        }
        for (PackagingElement child : oldParent.getChildren()) {
            newParent.addOrFindChild(ArtifactUtil.copyWithChildren(child, project2));
        }
    }

    @NotNull
    public static <S> PackagingElement<S> copyWithChildren(@NotNull PackagingElement<? extends S> element, @NotNull Project project2) {
        if (element == null) {
            ArtifactUtil.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(4);
        }
        PackagingElement<? extends S> copy = ArtifactUtil.copyElement(element, project2);
        if (element instanceof CompositePackagingElement) {
            ArtifactUtil.copyChildren((CompositePackagingElement)element, (CompositePackagingElement)copy, project2);
        }
        PackagingElement<? extends S> packagingElement = copy;
        if (packagingElement == null) {
            ArtifactUtil.$$$reportNull$$$0(5);
        }
        return packagingElement;
    }

    @NotNull
    private static <S> PackagingElement<S> copyElement(@NotNull PackagingElement<? extends S> element, @NotNull Project project2) {
        if (element == null) {
            ArtifactUtil.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(7);
        }
        PackagingElement copy = element.getType().createEmpty(project2);
        Object state = element.getState();
        if (state != null) {
            copy.loadState(state);
        } else {
            copy.noStateLoaded();
        }
        PackagingElement packagingElement = copy;
        if (packagingElement == null) {
            ArtifactUtil.$$$reportNull$$$0(8);
        }
        return packagingElement;
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, final @NotNull Processor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        if (artifact == null) {
            ArtifactUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(10);
        }
        if (resolvingContext == null) {
            ArtifactUtil.$$$reportNull$$$0(11);
        }
        return ArtifactUtil.processPackagingElements(artifact, type, new PackagingElementProcessor<E>(){

            @Override
            public boolean process(@NotNull E e, @NotNull PackagingElementPath path) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor.process(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, resolvingContext, processSubstitutions);
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        if (artifact == null) {
            ArtifactUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(13);
        }
        if (resolvingContext == null) {
            ArtifactUtil.$$$reportNull$$$0(14);
        }
        return ArtifactUtil.processPackagingElements(artifact.getRootElement(), type, processor, resolvingContext, processSubstitutions, artifact.getArtifactType());
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(PackagingElement<?> rootElement, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType) {
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(15);
        }
        if (resolvingContext == null) {
            ArtifactUtil.$$$reportNull$$$0(16);
        }
        return ArtifactUtil.processElementRecursively(rootElement, type, processor, resolvingContext, processSubstitutions, artifactType, PackagingElementPath.EMPTY, new HashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsRecursively(List<? extends PackagingElement<?>> elements, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(17);
        }
        if (resolvingContext == null) {
            ArtifactUtil.$$$reportNull$$$0(18);
        }
        if (path == null) {
            ArtifactUtil.$$$reportNull$$$0(19);
        }
        for (PackagingElement<?> element : elements) {
            if (ArtifactUtil.processElementRecursively(element, type, processor, resolvingContext, processSubstitutions, artifactType, path, processed)) continue;
            return false;
        }
        return true;
    }

    public static void processRecursivelySkippingIncludedArtifacts(Artifact artifact, final Processor<? super PackagingElement<?>> processor, PackagingElementResolvingContext context) {
        ArtifactUtil.processPackagingElements(artifact.getRootElement(), null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(1);
                }
                return processor.process(element);
            }

            @Override
            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                return !(element instanceof ArtifactPackagingElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, context, true, artifact.getArtifactType());
    }

    private static <E extends PackagingElement<?>> boolean processElementRecursively(@NotNull PackagingElement<?> element, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        List substitution;
        ComplexPackagingElement complexElement;
        if (element == null) {
            ArtifactUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(21);
        }
        if (resolvingContext == null) {
            ArtifactUtil.$$$reportNull$$$0(22);
        }
        if (path == null) {
            ArtifactUtil.$$$reportNull$$$0(23);
        }
        if (!processor.shouldProcess(element) || !processed.add(element)) {
            return true;
        }
        if ((type == null || element.getType().equals(type)) && !processor.process(element, path)) {
            return false;
        }
        if (element instanceof CompositePackagingElement) {
            CompositePackagingElement composite = (CompositePackagingElement)element;
            return ArtifactUtil.processElementsRecursively(composite.getChildren(), type, processor, resolvingContext, processSubstitutions, artifactType, path.appendComposite(composite), processed);
        }
        if (element instanceof ComplexPackagingElement && processSubstitutions && processor.shouldProcessSubstitution(complexElement = (ComplexPackagingElement)element) && (substitution = complexElement.getSubstitution(resolvingContext, artifactType)) != null) {
            return ArtifactUtil.processElementsRecursively(substitution, type, processor, resolvingContext, processSubstitutions, artifactType, path.appendComplex(complexElement), processed);
        }
        return true;
    }

    public static void removeDuplicates(@NotNull CompositePackagingElement<?> parent) {
        if (parent == null) {
            ArtifactUtil.$$$reportNull$$$0(24);
        }
        ArrayList<PackagingElement> prevChildren = new ArrayList<PackagingElement>();
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : parent.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                ArtifactUtil.removeDuplicates((CompositePackagingElement)child);
            }
            boolean merged = false;
            for (PackagingElement prevChild : prevChildren) {
                if (!child.isEqualTo(prevChild)) continue;
                if (child instanceof CompositePackagingElement) {
                    for (PackagingElement childElement : ((CompositePackagingElement)child).getChildren()) {
                        ((CompositePackagingElement)prevChild).addOrFindChild(childElement);
                    }
                }
                merged = true;
                break;
            }
            if (merged) {
                toRemove.add(child);
                continue;
            }
            prevChildren.add(child);
        }
        for (PackagingElement child : toRemove) {
            parent.removeChild(child);
        }
    }

    public static <S> void copyProperties(ArtifactProperties<?> from, ArtifactProperties<S> to) {
        to.loadState(from.getState());
    }

    @Nullable
    public static String getDefaultArtifactOutputPath(@NotNull String artifactName, @NotNull Project project2) {
        CompilerProjectExtension extension;
        if (artifactName == null) {
            ArtifactUtil.$$$reportNull$$$0(25);
        }
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(26);
        }
        if ((extension = CompilerProjectExtension.getInstance((Project)project2)) == null) {
            return null;
        }
        String outputUrl = extension.getCompilerOutputUrl();
        if (outputUrl == null || outputUrl.length() == 0) {
            VirtualFile baseDir = project2.getBaseDir();
            if (baseDir == null) {
                return null;
            }
            outputUrl = baseDir.getUrl() + "/out";
        }
        return VfsUtilCore.urlToPath((String)outputUrl) + "/artifacts/" + FileUtil.sanitizeFileName((String)artifactName);
    }

    public static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor) {
        if (elements == null) {
            ArtifactUtil.$$$reportNull$$$0(27);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(28);
        }
        if (artifactType == null) {
            ArtifactUtil.$$$reportNull$$$0(29);
        }
        if (parentPath == null) {
            ArtifactUtil.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(31);
        }
        return ArtifactUtil.processElementsWithSubstitutions(elements, context, artifactType, parentPath, processor, new THashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor, Set<? super PackagingElement<?>> processed) {
        if (elements == null) {
            ArtifactUtil.$$$reportNull$$$0(32);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(33);
        }
        if (artifactType == null) {
            ArtifactUtil.$$$reportNull$$$0(34);
        }
        if (parentPath == null) {
            ArtifactUtil.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(36);
        }
        for (PackagingElement<?> element : elements) {
            ComplexPackagingElement complexElement;
            List substitution;
            if (!processed.add(element) || !(element instanceof ComplexPackagingElement && processor.shouldProcessSubstitution((ComplexPackagingElement)element) ? (substitution = (complexElement = (ComplexPackagingElement)element).getSubstitution(context, artifactType)) != null && !ArtifactUtil.processElementsWithSubstitutions(substitution, context, artifactType, parentPath.appendComplex(complexElement), processor, processed) : !processor.process(element, parentPath))) continue;
            return false;
        }
        return true;
    }

    public static List<PackagingElement<?>> findByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        if (parent == null) {
            ArtifactUtil.$$$reportNull$$$0(37);
        }
        if (relativePath == null) {
            ArtifactUtil.$$$reportNull$$$0(38);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(39);
        }
        if (artifactType == null) {
            ArtifactUtil.$$$reportNull$$$0(40);
        }
        final ArrayList result = new ArrayList();
        ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                if (packagingElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(1);
                }
                result.add(packagingElement);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packagingElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$3";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result;
    }

    public static boolean processElementsByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, final @NotNull PackagingElementProcessor<? super PackagingElement<?>> processor) {
        if (parent == null) {
            ArtifactUtil.$$$reportNull$$$0(41);
        }
        if (relativePath == null) {
            ArtifactUtil.$$$reportNull$$$0(42);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(43);
        }
        if (artifactType == null) {
            ArtifactUtil.$$$reportNull$$$0(44);
        }
        if (parentPath == null) {
            ArtifactUtil.$$$reportNull$$$0(45);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(46);
        }
        if ((relativePath = StringUtil.trimStart((String)relativePath, (String)"/")).isEmpty()) {
            return true;
        }
        int i = relativePath.indexOf(47);
        final String firstName = i != -1 ? relativePath.substring(0, i) : relativePath;
        final String tail = i != -1 ? relativePath.substring(i + 1) : "";
        return ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, parentPath.appendComposite(parent), new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                FileCopyPackagingElement fileCopy;
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(1);
                }
                boolean process2 = false;
                if (element instanceof CompositePackagingElement && firstName.equals(((CompositePackagingElement)element).getName())) {
                    process2 = true;
                } else if (element instanceof FileCopyPackagingElement && firstName.equals((fileCopy = (FileCopyPackagingElement)element).getOutputFileName())) {
                    process2 = true;
                }
                if (process2) {
                    if (tail.length() == 0) {
                        if (!processor.process(element, path)) {
                            return false;
                        }
                    } else if (element instanceof CompositePackagingElement) {
                        return ArtifactUtil.processElementsByRelativePath((CompositePackagingElement)element, tail, context, artifactType, path, processor);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$4";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processDirectoryChildren(@NotNull CompositePackagingElement<?> parent, @NotNull PackagingElementPath pathToParent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, final @NotNull PackagingElementProcessor<PackagingElement<?>> processor) {
        if (parent == null) {
            ArtifactUtil.$$$reportNull$$$0(47);
        }
        if (pathToParent == null) {
            ArtifactUtil.$$$reportNull$$$0(48);
        }
        if (relativePath == null) {
            ArtifactUtil.$$$reportNull$$$0(49);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(50);
        }
        if (artifactType == null) {
            ArtifactUtil.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(52);
        }
        return ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, pathToParent, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                List children;
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(1);
                }
                return !(element instanceof DirectoryPackagingElement) || ArtifactUtil.processElementsWithSubstitutions(children = ((DirectoryPackagingElement)element).getChildren(), context, artifactType, path.appendComposite((DirectoryPackagingElement)element), processor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$5";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void processFileOrDirectoryCopyElements(Artifact artifact, PackagingElementProcessor<? super FileOrDirectoryCopyPackagingElement<?>> processor, PackagingElementResolvingContext context, boolean processSubstitutions) {
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, processor, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE, processor, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, processor, context, processSubstitutions);
    }

    public static Collection<Trinity<Artifact, PackagingElementPath, String>> findContainingArtifactsWithOutputPaths(final @NotNull VirtualFile file, @NotNull Project project2, Artifact[] artifacts) {
        if (file == null) {
            ArtifactUtil.$$$reportNull$$$0(53);
        }
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(54);
        }
        final boolean isResourceFile = CompilerConfiguration.getInstance((Project)project2).isResourceFile(file);
        final ArrayList<Trinity<Artifact, PackagingElementPath, String>> result = new ArrayList<Trinity<Artifact, PackagingElementPath, String>>();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        for (final Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    String relativePath;
                    if (element == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
                            String relativePath2 = root.equals(file) && element instanceof FileCopyPackagingElement ? ((FileCopyPackagingElement)element).getOutputFileName() : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
                            result.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath2));
                            return false;
                        }
                    } else if (isResourceFile && element instanceof ModuleOutputPackagingElement && (relativePath = ArtifactUtil.getRelativePathInSources(file, (ModuleOutputPackagingElement)element, context)) != null) {
                        result.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath));
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$6";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, context, true);
        }
        return result;
    }

    @Nullable
    private static String getRelativePathInSources(@NotNull VirtualFile file, @NotNull ModuleOutputPackagingElement moduleElement, @NotNull PackagingElementResolvingContext context) {
        if (file == null) {
            ArtifactUtil.$$$reportNull$$$0(55);
        }
        if (moduleElement == null) {
            ArtifactUtil.$$$reportNull$$$0(56);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(57);
        }
        for (VirtualFile sourceRoot : moduleElement.getSourceRoots(context)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)file, (boolean)true)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(Artifact artifact, String outputPath, PackagingElementResolvingContext context) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(artifact.getRootElement(), outputPath, context, artifact.getArtifactType());
        return files.isEmpty() ? null : files.get(0);
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(parent, outputPath, context, artifactType);
        return files.isEmpty() ? null : files.get(0);
    }

    public static List<VirtualFile> findSourceFilesByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        String path = StringUtil.trimStart((String)outputPath, (String)"/");
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        int i = path.indexOf(47);
        final String firstName = i != -1 ? path.substring(0, i) : path;
        String tail = i != -1 ? path.substring(i + 1) : "";
        SmartList result = new SmartList();
        ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>((List)result, tail, context, artifactType, path){
            final /* synthetic */ List val$result;
            final /* synthetic */ String val$tail;
            final /* synthetic */ PackagingElementResolvingContext val$context;
            final /* synthetic */ ArtifactType val$artifactType;
            final /* synthetic */ String val$path;
            {
                this.val$result = list;
                this.val$tail = string2;
                this.val$context = packagingElementResolvingContext;
                this.val$artifactType = artifactType;
                this.val$path = string3;
            }

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath elementPath) {
                if (element == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (elementPath == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (element instanceof CompositePackagingElement) {
                    CompositePackagingElement compositeElement = (CompositePackagingElement)element;
                    if (firstName.equals(compositeElement.getName())) {
                        this.val$result.addAll(ArtifactUtil.findSourceFilesByOutputPath(compositeElement, this.val$tail, this.val$context, this.val$artifactType));
                    }
                } else if (element instanceof FileCopyPackagingElement) {
                    FileCopyPackagingElement fileCopyElement = (FileCopyPackagingElement)element;
                    if (firstName.equals(fileCopyElement.getOutputFileName()) && this.val$tail.isEmpty()) {
                        ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)fileCopyElement.findFile());
                    }
                } else if (element instanceof DirectoryCopyPackagingElement || element instanceof ExtractedDirectoryPackagingElement) {
                    VirtualFile sourceRoot = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                    if (sourceRoot != null) {
                        ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)sourceRoot.findFileByRelativePath(this.val$path));
                    }
                } else if (element instanceof ModulePackagingElement) {
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.val$context.getProject());
                    for (VirtualFile sourceRoot : ((ModulePackagingElement)element).getSourceRoots(this.val$context)) {
                        VirtualFile sourceFile = sourceRoot.findFileByRelativePath(this.val$path);
                        if (sourceFile == null || !compilerConfiguration.isResourceFile(sourceFile)) continue;
                        this.val$result.add(sourceFile);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elementPath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$7";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result;
    }

    public static boolean processParents(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ParentElementProcessor processor, int maxLevel) {
        if (artifact == null) {
            ArtifactUtil.$$$reportNull$$$0(58);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(59);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(60);
        }
        return ArtifactUtil.processParents(artifact, context, processor, FList.emptyList(), maxLevel, (Set<? super Artifact>)new THashSet());
    }

    private static boolean processParents(final @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext context, final @NotNull ParentElementProcessor processor, FList<Pair<Artifact, CompositePackagingElement<?>>> pathToElement, final int maxLevel, final Set<? super Artifact> processed) {
        FList pathFromRoot;
        if (artifact == null) {
            ArtifactUtil.$$$reportNull$$$0(61);
        }
        if (context == null) {
            ArtifactUtil.$$$reportNull$$$0(62);
        }
        if (processor == null) {
            ArtifactUtil.$$$reportNull$$$0(63);
        }
        if (!processed.add((Artifact)artifact)) {
            return true;
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        if (rootElement instanceof ArtifactRootElement) {
            pathFromRoot = pathToElement;
        } else {
            if (!processor.process((CompositePackagingElement<?>)rootElement, (List<Pair<Artifact, CompositePackagingElement<?>>>)pathToElement, artifact)) {
                return false;
            }
            pathFromRoot = pathToElement.prepend((Object)new Pair((Object)artifact, (Object)rootElement));
        }
        if (pathFromRoot.size() > maxLevel) {
            return true;
        }
        for (final Artifact anArtifact : context.getArtifactModel().getArtifacts()) {
            PackagingElementProcessor<ArtifactPackagingElement> elementProcessor;
            if (processed.contains(anArtifact) || ArtifactUtil.processPackagingElements(anArtifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, elementProcessor = new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                    return !(element instanceof ArtifactPackagingElement);
                }

                @Override
                public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    if (artifact.getName().equals(element.getArtifactName())) {
                        CompositePackagingElement<?> lastParent;
                        FList currentPath = pathFromRoot;
                        List<CompositePackagingElement<?>> parents = path.getParents();
                        int parentsSize = parents.size();
                        for (int i = 0; i < parentsSize - 1; ++i) {
                            CompositePackagingElement<?> parent = parents.get(i);
                            if (!processor.process(parent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                                return false;
                            }
                            if ((currentPath = currentPath.prepend((Object)new Pair((Object)anArtifact, parent))).size() <= maxLevel) continue;
                            return true;
                        }
                        if (!parents.isEmpty() && (lastParent = parents.get(parents.size() - 1)) instanceof ArtifactRootElement && !processor.process(lastParent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                            return false;
                        }
                        return ArtifactUtil.processParents(anArtifact, context, processor, currentPath, maxLevel, processed);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil$8";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, context, true)) continue;
            return false;
        }
        return true;
    }

    public static void removeChildrenRecursively(@NotNull CompositePackagingElement<?> element, @NotNull Condition<? super PackagingElement<?>> condition) {
        if (element == null) {
            ArtifactUtil.$$$reportNull$$$0(64);
        }
        if (condition == null) {
            ArtifactUtil.$$$reportNull$$$0(65);
        }
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : element.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                CompositePackagingElement compositeChild = (CompositePackagingElement)child;
                ArtifactUtil.removeChildrenRecursively(compositeChild, condition);
                if (!compositeChild.getChildren().isEmpty()) continue;
                toRemove.add(child);
                continue;
            }
            if (!condition.value((Object)child)) continue;
            toRemove.add(child);
        }
        element.removeChildren(toRemove);
    }

    public static boolean shouldClearArtifactOutputBeforeRebuild(Artifact artifact) {
        String outputPath = artifact.getOutputPath();
        return !StringUtil.isEmpty((String)outputPath) && artifact.getRootElement() instanceof ArtifactRootElement;
    }

    public static Set<Module> getModulesIncludedInArtifacts(@NotNull Collection<? extends Artifact> artifacts, @NotNull Project project2) {
        if (artifacts == null) {
            ArtifactUtil.$$$reportNull$$$0(66);
        }
        if (project2 == null) {
            ArtifactUtil.$$$reportNull$$$0(67);
        }
        THashSet modules = new THashSet();
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project2).getResolvingContext();
        for (Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, null, arg_0 -> ArtifactUtil.lambda$getModulesIncludedInArtifacts$0((Set)modules, resolvingContext, arg_0), resolvingContext, true);
        }
        return modules;
    }

    public static Collection<Artifact> getArtifactsContainingModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            ArtifactUtil.$$$reportNull$$$0(68);
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)module2.getProject());
        PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        HashSet<Artifact> result = new HashSet<Artifact>();
        Processor processor = element -> {
            if (element instanceof ProductionModuleOutputPackagingElement && module2.equals(((ProductionModuleOutputPackagingElement)element).findModule(context))) {
                return false;
            }
            return !(element instanceof ArtifactPackagingElement) || !result.contains(((ArtifactPackagingElement)((Object)element)).findArtifact(context));
        };
        for (Artifact artifact : artifactManager.getSortedArtifacts()) {
            boolean contains;
            boolean bl = contains = !ArtifactUtil.processPackagingElements(artifact, null, processor, context, true);
            if (!contains) continue;
            result.add(artifact);
        }
        return result;
    }

    public static List<Artifact> getArtifactWithOutputPaths(Project project2) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project2).getSortedArtifacts()) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            result.add(artifact);
        }
        return result;
    }

    public static String suggestArtifactFileName(String artifactName) {
        return PathUtil.suggestFileName((String)artifactName, (boolean)true, (boolean)true);
    }

    @Nullable
    public static Artifact addArtifact(@NotNull ModifiableArtifactModel artifactModel, @NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        ArtifactTemplate.NewArtifactConfiguration configuration;
        if (artifactModel == null) {
            ArtifactUtil.$$$reportNull$$$0(69);
        }
        if (type == null) {
            ArtifactUtil.$$$reportNull$$$0(70);
        }
        if (artifactTemplate == null) {
            ArtifactUtil.$$$reportNull$$$0(71);
        }
        if ((configuration = artifactTemplate.createArtifact()) == null) {
            return null;
        }
        String baseName = configuration.getArtifactName();
        String name2 = ArtifactUtil.generateUniqueArtifactName(baseName, artifactModel);
        ArtifactType actualType = configuration.getArtifactType();
        if (actualType == null) {
            actualType = type;
        }
        ModifiableArtifact artifact = artifactModel.addArtifact(name2, actualType, configuration.getRootElement());
        artifactTemplate.setUpArtifact((Artifact)artifact, configuration);
        return artifact;
    }

    @NotNull
    public static String generateUniqueArtifactName(String baseName, @NotNull ModifiableArtifactModel artifactModel) {
        if (artifactModel == null) {
            ArtifactUtil.$$$reportNull$$$0(72);
        }
        String string = UniqueNameGenerator.generateUniqueName((String)baseName, name2 -> artifactModel.findArtifact(name2) == null);
        if (string == null) {
            ArtifactUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$getModulesIncludedInArtifacts$0(Set modules, PackagingElementResolvingContext resolvingContext, PackagingElement element) {
        if (element instanceof ModuleOutputPackagingElement) {
            ContainerUtil.addIfNotNull((Collection)modules, (Object)((ModuleOutputPackagingElement)element).findModule(resolvingContext));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 26: 
            case 54: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactUtil";
                break;
            }
            case 9: 
            case 12: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 31: 
            case 36: 
            case 46: 
            case 52: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: 
            case 37: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 28: 
            case 33: 
            case 39: 
            case 43: 
            case 50: 
            case 57: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: 
            case 34: 
            case 40: 
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 30: 
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 38: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToParent";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleElement";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactModel";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyElement";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueArtifactName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyWithChildren";
                break;
            }
            case 5: 
            case 8: 
            case 73: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processPackagingElements";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processElementsRecursively";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processElementRecursively";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultArtifactOutputPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithSubstitutions";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findByRelativePath";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByRelativePath";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoryChildren";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findContainingArtifactsWithOutputPaths";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathInSources";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processParents";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenRecursively";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getModulesIncludedInArtifacts";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsContainingModuleOutput";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueArtifactName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

