/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLibraryEditor
extends LibraryEditorBase {
    private String myLibraryName;
    private final MultiMap<OrderRootType, LightFilePointer> myRoots;
    private final Set<LightFilePointer> myExcludedRoots;
    private final MultiMap<OrderRootType, String> myJarDirectoryUrls = new MultiMap();
    private final MultiMap<OrderRootType, String> myJarDirectoryRecursiveUrls = new MultiMap();
    private LibraryType myType;
    private LibraryProperties myProperties;
    private boolean myKeepInvalidUrls = true;

    public NewLibraryEditor() {
        this(null, null);
    }

    public NewLibraryEditor(@Nullable LibraryType type, @Nullable LibraryProperties properties) {
        this.myType = type;
        this.myProperties = properties;
        this.myRoots = new MultiMap();
        this.myExcludedRoots = new LinkedHashSet<LightFilePointer>();
    }

    public void setKeepInvalidUrls(boolean keepInvalidUrls) {
        this.myKeepInvalidUrls = keepInvalidUrls;
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return this.myRoots.keySet();
    }

    @Nullable
    public LibraryType<?> getType() {
        return this.myType;
    }

    @Override
    public void setType(@NotNull LibraryType<?> type) {
        if (type == null) {
            NewLibraryEditor.$$$reportNull$$$0(0);
        }
        this.myType = type;
    }

    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myProperties = properties;
    }

    public String getName() {
        return this.myLibraryName;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(1);
        }
        String[] stringArray = NewLibraryEditor.pointersToUrls(this.myRoots.get((Object)rootType));
        if (stringArray == null) {
            NewLibraryEditor.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static String[] pointersToUrls(Collection<? extends LightFilePointer> pointers) {
        ArrayList<String> urls = new ArrayList<String>(pointers.size());
        for (LightFilePointer lightFilePointer : pointers) {
            urls.add(lightFilePointer.getUrl());
        }
        return ArrayUtil.toStringArray(urls);
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(3);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (LightFilePointer pointer : this.myRoots.get((Object)rootType)) {
            String url;
            VirtualFile file = pointer.getFile();
            if (file == null) continue;
            if (file.isDirectory() && this.isJarDirectory(url = file.getUrl(), rootType)) {
                boolean recursive = this.myJarDirectoryRecursiveUrls.get((Object)rootType).contains(url);
                NewLibraryEditor.collectJarFiles(file, result, recursive);
                continue;
            }
            result.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            NewLibraryEditor.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        String[] stringArray = NewLibraryEditor.pointersToUrls(this.myExcludedRoots);
        if (stringArray == null) {
            NewLibraryEditor.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    public void setName(String name2) {
        this.myLibraryName = name2;
    }

    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        if (file == null) {
            NewLibraryEditor.$$$reportNull$$$0(6);
        }
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(7);
        }
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(file));
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(8);
        }
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(9);
        }
        this.myRoots.putValue((Object)rootType, (Object)new LightFilePointer(url));
    }

    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive, @NotNull OrderRootType rootType) {
        if (file == null) {
            NewLibraryEditor.$$$reportNull$$$0(10);
        }
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(11);
        }
        this.addJarDirectory(file.getUrl(), recursive, rootType);
    }

    public void addExcludedRoot(@NotNull String url) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(12);
        }
        this.myExcludedRoots.add(new LightFilePointer(url));
    }

    public void removeExcludedRoot(@NotNull String url) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(13);
        }
        this.myExcludedRoots.remove(new LightFilePointer(url));
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(14);
        }
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(15);
        }
        this.addRoot(url, rootType);
        (recursive ? this.myJarDirectoryRecursiveUrls : this.myJarDirectoryUrls).putValue((Object)rootType, (Object)url);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(16);
        }
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(17);
        }
        this.myRoots.remove((Object)rootType, (Object)new LightFilePointer(url));
        this.myExcludedRoots.removeIf(pointer -> !this.isUnderRoots(pointer.getUrl()));
        this.myJarDirectoryUrls.remove((Object)rootType, (Object)url);
        this.myJarDirectoryRecursiveUrls.remove((Object)rootType, (Object)url);
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(18);
        }
        for (LightFilePointer pointer : this.myRoots.values()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)pointer.getUrl(), (String)url)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return true;
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(19);
        }
        if (rootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(20);
        }
        return this.myJarDirectoryUrls.get((Object)rootType).contains(url) || this.myJarDirectoryRecursiveUrls.get((Object)rootType).contains(url);
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType orderRootType) {
        if (url == null) {
            NewLibraryEditor.$$$reportNull$$$0(21);
        }
        if (orderRootType == null) {
            NewLibraryEditor.$$$reportNull$$$0(22);
        }
        Collection pointers = this.myRoots.get((Object)orderRootType);
        for (LightFilePointer pointer : pointers) {
            if (!pointer.getUrl().equals(url)) continue;
            return pointer.isValid();
        }
        return false;
    }

    public void applyTo(@NotNull LibraryEx.ModifiableModelEx model) {
        if (model == null) {
            NewLibraryEditor.$$$reportNull$$$0(23);
        }
        model.setProperties(this.myProperties);
        this.exportRoots(arg_0 -> ((LibraryEx.ModifiableModelEx)model).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEx.ModifiableModelEx)model).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEx.ModifiableModelEx)model).addJarDirectory(arg_0, arg_1, arg_2), arg_0 -> ((LibraryEx.ModifiableModelEx)model).addExcludedRoot(arg_0));
    }

    public void applyTo(@NotNull LibraryEditorBase editor) {
        if (editor == null) {
            NewLibraryEditor.$$$reportNull$$$0(24);
        }
        editor.setProperties(this.myProperties);
        this.exportRoots(arg_0 -> ((LibraryEditorBase)editor).getUrls(arg_0), (arg_0, arg_1) -> ((LibraryEditorBase)editor).isValid(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEditorBase)editor).removeRoot(arg_0, arg_1), (arg_0, arg_1) -> ((LibraryEditorBase)editor).addRoot(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((LibraryEditorBase)editor).addJarDirectory(arg_0, arg_1, arg_2), arg_0 -> ((LibraryEditorBase)editor).addExcludedRoot(arg_0));
    }

    private void exportRoots(Function<? super OrderRootType, String[]> getUrls, BiFunction<? super String, ? super OrderRootType, Boolean> isValid, BiConsumer<? super String, ? super OrderRootType> removeRoot, BiConsumer<? super String, ? super OrderRootType> addRoot, TriConsumer<? super String, ? super Boolean, ? super OrderRootType> addJarDir, Consumer<? super String> addExcludedRoot) {
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : getUrls.apply((OrderRootType)type)) {
                if (this.myKeepInvalidUrls && !isValid.apply(url, (OrderRootType)type).booleanValue()) continue;
                removeRoot.accept(url, (OrderRootType)type);
            }
        }
        for (OrderRootType type : this.myRoots.keySet()) {
            for (LightFilePointer pointer : this.myRoots.get((Object)type)) {
                if (this.isJarDirectory(pointer.getUrl(), type)) continue;
                addRoot.accept(pointer.getUrl(), (OrderRootType)type);
            }
        }
        for (Map.Entry entry : this.myJarDirectoryUrls.entrySet()) {
            OrderRootType type = (OrderRootType)entry.getKey();
            for (String url : (Collection)entry.getValue()) {
                addJarDir.accept(url, (Boolean)false, (OrderRootType)type);
            }
        }
        for (Map.Entry entry : this.myJarDirectoryRecursiveUrls.entrySet()) {
            OrderRootType type = (OrderRootType)entry.getKey();
            for (String url : (Collection)entry.getValue()) {
                addJarDir.accept(url, (Boolean)true, (OrderRootType)type);
            }
        }
        for (LightFilePointer root : this.myExcludedRoots) {
            addExcludedRoot.accept(root.getUrl());
        }
    }

    private static void collectJarFiles(@NotNull VirtualFile dir, final @NotNull List<? super VirtualFile> container, boolean recursively) {
        if (dir == null) {
            NewLibraryEditor.$$$reportNull$$$0(25);
        }
        if (container == null) {
            NewLibraryEditor.$$$reportNull$$$0(26);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, recursively ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            public boolean visitFile(@NotNull VirtualFile file) {
                VirtualFile jarRoot;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file.getPath() + "!/")) != null) {
                    container.add(jarRoot);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/NewLibraryEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectJarFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, P> {
        public void accept(T var1, U var2, P var3);
    }
}

