/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.packaging.artifacts.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaProjectSettingsService
extends ProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;

    public IdeaProjectSettingsService(Project project2) {
        this.myProject = project2;
    }

    public void openProjectSettings() {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectProjectGeneralSettings(true));
    }

    public void openGlobalLibraries() {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectGlobalLibraries(true));
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            IdeaProjectSettingsService.$$$reportNull$$$0(0);
        }
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectProjectOrGlobalLibrary(library, true));
    }

    public boolean canOpenModuleSettings() {
        return true;
    }

    public void openModuleSettings(Module module2) {
        ModulesConfigurator.showDialog(this.myProject, module2.getName(), null);
    }

    public boolean canOpenModuleLibrarySettings() {
        return true;
    }

    public void openModuleLibrarySettings(Module module2) {
        ModulesConfigurator.showDialog(this.myProject, module2.getName(), ClasspathEditor.NAME);
    }

    public boolean canOpenContentEntriesSettings() {
        return true;
    }

    public void openContentEntriesSettings(Module module2) {
        ModulesConfigurator.showDialog(this.myProject, module2.getName(), CommonContentEntriesEditor.NAME);
    }

    public boolean canOpenModuleDependenciesSettings() {
        return true;
    }

    public void openModuleDependenciesSettings(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        if (module2 == null) {
            IdeaProjectSettingsService.$$$reportNull$$$0(1);
        }
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)ProjectStructureConfigurable.getInstance(this.myProject), () -> ProjectStructureConfigurable.getInstance(this.myProject).selectOrderEntry(module2, orderEntry));
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return true;
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            IdeaProjectSettingsService.$$$reportNull$$$0(2);
        }
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> {
            if (orderEntry instanceof JdkOrderEntry) {
                config.select(((JdkOrderEntry)orderEntry).getJdk(), true);
            } else {
                config.select((LibraryOrderEntry)orderEntry, true);
            }
        });
    }

    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        if (rootConfigurable.updateProjectTree(modules)) {
            if (targetGroup != null) {
                rootConfigurable.selectNodeInTree(targetGroup.toString());
            } else {
                rootConfigurable.selectNodeInTree(modules[0].getName());
            }
            return true;
        }
        return false;
    }

    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        ModulesConfigurator.showDialog(this.myProject, moduleToSelect, editorNameToSelect);
    }

    public Sdk chooseAndSetSdk() {
        return JdkChooserPanel.chooseAndSetJDK(this.myProject);
    }

    @Override
    public void openArtifactSettings(@Nullable Artifact artifact) {
        ModulesConfigurator.showArtifactSettings(this.myProject, artifact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/IdeaProjectSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openModuleDependenciesSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibraryOrSdkSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

