/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFromSourcesBuilderImpl
extends ProjectImportBuilder
implements ProjectFromSourcesBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl");
    private static final String NAME = "Existing Sources";
    private String myBaseProjectPath;
    private final List<ProjectConfigurationUpdater> myUpdaters = new ArrayList<ProjectConfigurationUpdater>();
    private final Map<ProjectStructureDetector, ProjectDescriptor> myProjectDescriptors = new LinkedHashMap<ProjectStructureDetector, ProjectDescriptor>();
    private MultiMap<ProjectStructureDetector, DetectedProjectRoot> myRoots = MultiMap.emptyInstance();
    private final WizardContext myContext;
    private final ModulesProvider myModulesProvider;
    private Set<String> myModuleNames;
    private Set<String> myProjectLibrariesNames;

    public ProjectFromSourcesBuilderImpl(WizardContext context, ModulesProvider modulesProvider) {
        this.myContext = context;
        this.myModulesProvider = modulesProvider;
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            this.myProjectDescriptors.put(detector, new ProjectDescriptor());
        }
    }

    @Override
    @NotNull
    public Set<String> getExistingModuleNames() {
        if (this.myModuleNames == null) {
            this.myModuleNames = new HashSet<String>();
            for (Module module2 : this.myModulesProvider.getModules()) {
                this.myModuleNames.add(module2.getName());
            }
        }
        Set<String> set = this.myModuleNames;
        if (set == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getExistingProjectLibraryNames() {
        if (this.myProjectLibrariesNames == null) {
            this.myProjectLibrariesNames = new HashSet<String>();
            LibrariesContainer container = LibrariesContainerFactory.createContainer(this.myContext, this.myModulesProvider);
            for (Library library : container.getLibraries(LibrariesContainer.LibraryLevel.PROJECT)) {
                this.myProjectLibrariesNames.add(library.getName());
            }
        }
        Set<String> set = this.myProjectLibrariesNames;
        if (set == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public WizardContext getContext() {
        WizardContext wizardContext = this.myContext;
        if (wizardContext == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(2);
        }
        return wizardContext;
    }

    public void setBaseProjectPath(String contentRootPath) {
        this.myBaseProjectPath = contentRootPath;
    }

    @Override
    public String getBaseProjectPath() {
        return this.myBaseProjectPath;
    }

    public void setupProjectStructure(MultiMap<ProjectStructureDetector, DetectedProjectRoot> roots) {
        this.myRoots = roots;
        for (ProjectStructureDetector detector : roots.keySet()) {
            detector.setupProjectStructure(roots.get((Object)detector), this.getProjectDescriptor(detector), this);
        }
    }

    @Override
    @NotNull
    public Collection<DetectedProjectRoot> getProjectRoots(@NotNull ProjectStructureDetector detector) {
        if (detector == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(3);
        }
        Collection collection = this.myRoots.get((Object)detector);
        if (collection == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(5);
        }
        return NAME;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Folder;
    }

    public List getList() {
        return null;
    }

    public boolean isMarked(Object element) {
        return false;
    }

    public void setList(List list) throws ConfigurationException {
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @Override
    public void setFileToImport(String path) {
        this.setBaseProjectPath(path);
    }

    @Override
    public List<Module> commit(@NotNull Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        if (project2 == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(6);
        }
        boolean fromProjectStructure = model != null;
        IdeaModifiableModelsProvider modelsProvider = new IdeaModifiableModelsProvider();
        LibraryTable.ModifiableModel projectLibraryTable = modelsProvider.getLibraryTableModifiableModel(project2);
        HashMap projectLibs = new HashMap();
        ArrayList<Module> result = new ArrayList<Module>();
        try {
            WriteAction.run(() -> {
                for (ProjectDescriptor projectDescriptor : this.getSelectedDescriptors()) {
                    for (LibraryDescriptor lib : projectDescriptor.getLibraries()) {
                        Collection<File> files = lib.getJars();
                        Library projectLib = projectLibraryTable.createLibrary(lib.getName());
                        Library.ModifiableModel libraryModel = projectLib.getModifiableModel();
                        for (File file : files) {
                            libraryModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
                        }
                        libraryModel.commit();
                        projectLibs.put(lib, projectLib);
                    }
                }
                if (!fromProjectStructure) {
                    projectLibraryTable.commit();
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        HashMap descriptorToModuleMap = new HashMap();
        try {
            WriteAction.run(() -> {
                ModifiableModuleModel moduleModel = fromProjectStructure ? model : ModuleManager.getInstance((Project)project2).getModifiableModel();
                for (ProjectDescriptor descriptor2 : this.getSelectedDescriptors()) {
                    for (ModuleDescriptor moduleDescriptor : descriptor2.getModules()) {
                        Module module2;
                        if (moduleDescriptor.isReuseExistingElement()) {
                            ExistingModuleLoader moduleLoader = ExistingModuleLoader.setUpLoader((String)FileUtil.toSystemIndependentName((String)moduleDescriptor.computeModuleFilePath()));
                            module2 = moduleLoader.createModule(moduleModel);
                        } else {
                            module2 = ProjectFromSourcesBuilderImpl.createModule(descriptor2, moduleDescriptor, projectLibs, moduleModel);
                        }
                        result.add(module2);
                        descriptorToModuleMap.put(moduleDescriptor, module2);
                    }
                }
                if (!fromProjectStructure) {
                    moduleModel.commit();
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        try {
            WriteAction.run(() -> {
                for (ProjectDescriptor data : this.getSelectedDescriptors()) {
                    for (ModuleDescriptor descriptor2 : data.getModules()) {
                        Set<ModuleDescriptor> deps;
                        Module module2 = (Module)descriptorToModuleMap.get(descriptor2);
                        if (module2 == null || (deps = descriptor2.getDependencies()).size() == 0) continue;
                        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                        for (ModuleDescriptor dependentDescriptor : deps) {
                            Module dependentModule = (Module)descriptorToModuleMap.get(dependentDescriptor);
                            if (dependentModule == null) continue;
                            rootModel.addModuleOrderEntry(dependentModule);
                        }
                        rootModel.commit();
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        WriteAction.run(() -> {
            ModulesProvider updatedModulesProvider = fromProjectStructure ? modulesProvider : new DefaultModulesProvider(project2);
            for (ProjectConfigurationUpdater updater : this.myUpdaters) {
                updater.updateProject(project2, modelsProvider, updatedModulesProvider);
            }
        });
        return result;
    }

    @Override
    @Nullable
    public List<Module> commit(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        return this.commit(project2, model, modulesProvider);
    }

    public Collection<ProjectDescriptor> getSelectedDescriptors() {
        return this.myProjectDescriptors.values();
    }

    public void addConfigurationUpdater(ProjectConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    @Override
    public boolean hasRootsFromOtherDetectors(ProjectStructureDetector thisDetector) {
        for (ProjectStructureDetector projectStructureDetector : ProjectStructureDetector.EP_NAME.getExtensionList()) {
            if (projectStructureDetector == thisDetector || this.getProjectRoots(projectStructureDetector).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setupModulesByContentRoots(ProjectDescriptor projectDescriptor, Collection<DetectedProjectRoot> roots) {
        if (projectDescriptor.getModules().isEmpty()) {
            ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
            for (DetectedProjectRoot root : roots) {
                if (!(root instanceof DetectedContentRoot)) continue;
                modules.add(new ModuleDescriptor(root.getDirectory(), ((DetectedContentRoot)root).getModuleType(), Collections.emptyList()));
            }
            projectDescriptor.setModules(modules);
        }
    }

    @NotNull
    private static Module createModule(ProjectDescriptor projectDescriptor, ModuleDescriptor descriptor2, Map<LibraryDescriptor, Library> projectLibs, ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        String moduleFilePath = descriptor2.computeModuleFilePath();
        ModuleBuilder.deleteModuleFile((String)moduleFilePath);
        Module module2 = moduleModel.newModule(moduleFilePath, descriptor2.getModuleType().getId());
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
        ProjectFromSourcesBuilderImpl.setupRootModel(projectDescriptor, descriptor2, modifiableModel, projectLibs);
        descriptor2.updateModuleConfiguration(module2, modifiableModel);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(7);
        }
        return module3;
    }

    private static void setupRootModel(ProjectDescriptor projectDescriptor, ModuleDescriptor descriptor2, ModifiableRootModel rootModel, Map<LibraryDescriptor, Library> projectLibs) {
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setExcludeOutput(true);
        rootModel.inheritSdk();
        Set<File> contentRoots = descriptor2.getContentRoots();
        for (File contentRoot : contentRoots) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            VirtualFile moduleContentRoot = lfs.refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)contentRoot.getPath()));
            if (moduleContentRoot == null) continue;
            ContentEntry contentEntry = rootModel.addContentEntry(moduleContentRoot);
            Collection<DetectedSourceRoot> sourceRoots = descriptor2.getSourceRoots(contentRoot);
            for (DetectedSourceRoot srcRoot : sourceRoots) {
                String srcpath = FileUtil.toSystemIndependentName((String)srcRoot.getDirectory().getPath());
                VirtualFile sourceRoot = lfs.refreshAndFindFileByPath(srcpath);
                if (sourceRoot == null) continue;
                contentEntry.addSourceFolder(sourceRoot, ProjectFromSourcesBuilderImpl.shouldBeTestRoot(srcRoot.getDirectory()), ProjectFromSourcesBuilderImpl.getPackagePrefix(srcRoot));
            }
        }
        compilerModuleExtension.inheritCompilerOutputPath(true);
        LibraryTable moduleLibraryTable = rootModel.getModuleLibraryTable();
        for (LibraryDescriptor libDescriptor : ModuleInsight.getLibraryDependencies(descriptor2, projectDescriptor.getLibraries())) {
            Library projectLib = projectLibs.get(libDescriptor);
            if (projectLib != null) {
                rootModel.addLibraryEntry(projectLib);
                continue;
            }
            Collection<File> jars = libDescriptor.getJars();
            for (File file : jars) {
                Library library = moduleLibraryTable.createLibrary();
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                modifiableModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
                modifiableModel.commit();
            }
        }
    }

    public static String getPackagePrefix(DetectedSourceRoot srcRoot) {
        return srcRoot.getPackagePrefix();
    }

    @Override
    @NotNull
    public ProjectDescriptor getProjectDescriptor(@NotNull ProjectStructureDetector detector) {
        if (detector == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(8);
        }
        ProjectDescriptor projectDescriptor = this.myProjectDescriptors.get(detector);
        if (projectDescriptor == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(9);
        }
        return projectDescriptor;
    }

    private static boolean shouldBeTestRoot(File srcRoot) {
        if (ProjectFromSourcesBuilderImpl.isTestRootName(srcRoot.getName())) {
            return true;
        }
        File parentFile = srcRoot.getParentFile();
        return parentFile != null && ProjectFromSourcesBuilderImpl.isTestRootName(parentFile.getName());
    }

    private static boolean isTestRootName(String name2) {
        return "test".equalsIgnoreCase(name2) || "tests".equalsIgnoreCase(name2) || "testSource".equalsIgnoreCase(name2) || "testSources".equalsIgnoreCase(name2) || "testSrc".equalsIgnoreCase(name2) || "tst".equalsIgnoreCase(name2);
    }

    public boolean isSuitableSdkType(SdkTypeId sdkTypeId) {
        for (ProjectDescriptor projectDescriptor : this.getSelectedDescriptors()) {
            for (ModuleDescriptor moduleDescriptor : projectDescriptor.getModules()) {
                try {
                    ModuleType moduleType = ProjectFromSourcesBuilderImpl.getModuleType(moduleDescriptor);
                    if (moduleType == null || moduleType.createModuleBuilder().isSuitableSdkType(sdkTypeId)) continue;
                    return false;
                }
                catch (Exception exception) {
                }
            }
        }
        return true;
    }

    @Nullable
    private static ModuleType getModuleType(ModuleDescriptor moduleDescriptor) throws InvalidDataException, JDOMException, IOException {
        if (moduleDescriptor.isReuseExistingElement()) {
            Element rootElement;
            String type;
            File file = new File(moduleDescriptor.computeModuleFilePath());
            if (file.exists() && (type = (rootElement = JDOMUtil.load((File)file)).getAttributeValue("type")) != null) {
                return ModuleTypeManager.getInstance().findByID(type);
            }
            return null;
        }
        return moduleDescriptor.getModuleType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingModuleNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProjectLibraryNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectConfigurationUpdater {
        public void updateProject(@NotNull Project var1, @NotNull ModifiableModelsProvider var2, @NotNull ModulesProvider var3);
    }
}

