/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarApplicationConfigurationProducer
extends LazyRunConfigurationProducer<JarApplicationConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JarApplicationConfigurationType jarApplicationConfigurationType = JarApplicationConfigurationType.getInstance();
        if (jarApplicationConfigurationType == null) {
            JarApplicationConfigurationProducer.$$$reportNull$$$0(0);
        }
        return jarApplicationConfigurationType;
    }

    protected boolean setupConfigurationFromContext(JarApplicationConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        VirtualFile file = JarApplicationConfigurationProducer.getJarFileFromContext(context);
        if (file != null) {
            configuration.setName(file.getName());
            configuration.setJarPath(file.getPath());
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getJarFileFromContext(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        VirtualFile file = location.getVirtualFile();
        return file != null && FileUtilRt.extensionEquals((String)file.getName(), (String)"jar") ? file : null;
    }

    public boolean isConfigurationFromContext(JarApplicationConfiguration configuration, ConfigurationContext context) {
        VirtualFile file = JarApplicationConfigurationProducer.getJarFileFromContext(context);
        return file != null && FileUtil.pathsEqual((String)file.getPath(), (String)configuration.getJarPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/jar/JarApplicationConfigurationProducer", "getConfigurationFactory"));
    }
}

