/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDescriptorImpl
extends ValueDescriptorImpl
implements LocalVariableDescriptor {
    private final StackFrameProxyImpl myFrameProxy;
    private final LocalVariableProxyImpl myLocalVariable;
    private String myTypeName;
    private boolean myIsPrimitive;
    private boolean myIsNewLocal;

    public LocalVariableDescriptorImpl(Project project2, @NotNull LocalVariableProxyImpl local) {
        if (local == null) {
            LocalVariableDescriptorImpl.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myTypeName = DebuggerBundle.message((String)"label.unknown.value", (Object[])new Object[0]);
        this.myIsNewLocal = true;
        this.setLvalue(true);
        this.myFrameProxy = local.getFrame();
        this.myLocalVariable = local;
    }

    @Override
    public LocalVariableProxyImpl getLocalVariable() {
        return this.myLocalVariable;
    }

    public boolean isNewLocal() {
        return this.myIsNewLocal;
    }

    @Override
    public boolean isPrimitive() {
        return this.myIsPrimitive;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        boolean isVisible = this.myFrameProxy.isLocalVariableVisible(this.getLocalVariable());
        if (isVisible) {
            String typeName;
            this.myTypeName = typeName = this.getLocalVariable().typeName();
            this.myIsPrimitive = DebuggerUtils.isPrimitiveType((String)typeName);
            return this.myFrameProxy.getValue(this.getLocalVariable());
        }
        return null;
    }

    public void setNewLocal(boolean aNew) {
        this.myIsNewLocal = aNew;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor2) {
        super.displayAs(descriptor2);
        if (descriptor2 instanceof LocalVariableDescriptorImpl) {
            this.myIsNewLocal = ((LocalVariableDescriptorImpl)descriptor2).myIsNewLocal;
        }
    }

    @Override
    public String getName() {
        return this.myLocalVariable.name();
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.myTypeName;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue value) {
        return new JavaValueModifier(value){

            @Override
            protected void setValueImpl(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback) {
                LocalVariableProxyImpl local;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((local = LocalVariableDescriptorImpl.this.getLocalVariable()) != null) {
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(LocalVariableDescriptorImpl.this.getProject()).getContext();
                    this.set(expression, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            debuggerContext.getFrameProxy().setValue(local, 1.preprocessValue(evaluationContext, newValue, this.getLType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        @NotNull
                        public Type getLType() throws EvaluateException, ClassNotLoadedException {
                            Type type = local.getType();
                            if (type == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return type;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl$1$1", "getLType"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/debugger/ui/impl/watch/LocalVariableDescriptorImpl", "<init>"));
    }
}

