/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class ValueNodeDnD {
    private final DnDAwareTree myTree;

    public ValueNodeDnD(DnDAwareTree tree, Disposable parent) {
        this.myTree = tree;
        DnDManager.getInstance().registerSource(new DnDSource(){

            public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                return ValueNodeDnD.this.getNodesToDrag().length > 0;
            }

            public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
                DebuggerTreeNodeImpl[] nodes = ValueNodeDnD.this.getNodesToDrag();
                return new DnDDragStartBean((Object)nodes);
            }

            @Nullable
            public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
                DebuggerTreeNodeImpl[] nodes = ValueNodeDnD.this.getNodesToDrag();
                Pair image = nodes.length == 1 ? DnDAwareTree.getDragImage((Tree)ValueNodeDnD.this.myTree, (TreePath)new TreePath(nodes[0].getPath()), (Point)dragOrigin) : DnDAwareTree.getDragImage((Tree)ValueNodeDnD.this.myTree, (String)(nodes.length + " elements"), (Point)dragOrigin);
                return image;
            }

            public void dragDropEnd() {
            }

            public void dropActionChanged(int gestureModifiers) {
            }
        }, (JComponent)tree);
    }

    private DebuggerTreeNodeImpl[] getNodesToDrag() {
        return (DebuggerTreeNodeImpl[])this.myTree.getSelectedNodes(DebuggerTreeNodeImpl.class, (Tree.NodeFilter)new Tree.NodeFilter<DebuggerTreeNodeImpl>(){

            public boolean accept(DebuggerTreeNodeImpl node) {
                return node.getDescriptor() instanceof ValueDescriptorImpl;
            }
        });
    }
}

