/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.tracking;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.tracking.BackgroundTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorInstancesTracker
implements TrackerForNewInstances,
Disposable,
BackgroundTracker {
    private static final int TRACKED_INSTANCES_LIMIT = 2000;
    private final String myClassName;
    private final Project myProject;
    private final MyConstructorBreakpoints myBreakpoint;
    @Nullable
    private HashSet<ObjectReference> myNewObjects;
    @NotNull
    private HashSet<ObjectReference> myTrackedObjects;
    private volatile boolean myIsBackgroundMode;
    private volatile boolean myIsBackgroundTrackingEnabled;

    public ConstructorInstancesTracker(@NotNull ReferenceType ref, @NotNull XDebugSession debugSession, @NotNull InstancesTracker instancesTracker) {
        if (ref == null) {
            ConstructorInstancesTracker.$$$reportNull$$$0(0);
        }
        if (debugSession == null) {
            ConstructorInstancesTracker.$$$reportNull$$$0(1);
        }
        if (instancesTracker == null) {
            ConstructorInstancesTracker.$$$reportNull$$$0(2);
        }
        this.myNewObjects = null;
        this.myTrackedObjects = new HashSet();
        this.myProject = debugSession.getProject();
        this.myIsBackgroundTrackingEnabled = instancesTracker.isBackgroundTrackingEnabled();
        this.myClassName = ref.name();
        final DebugProcessImpl debugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
        instancesTracker.addTrackerListener(new InstancesTrackerListener(){

            public void backgroundTrackingValueChanged(final boolean newState) {
                if (ConstructorInstancesTracker.this.myIsBackgroundTrackingEnabled != newState) {
                    ConstructorInstancesTracker.this.myIsBackgroundTrackingEnabled = newState;
                    debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            if (newState) {
                                ConstructorInstancesTracker.this.myBreakpoint.enable();
                            } else {
                                ConstructorInstancesTracker.this.myBreakpoint.disable();
                            }
                        }
                    });
                }
            }
        }, (Disposable)this);
        this.myBreakpoint = new MyConstructorBreakpoints(this.myProject);
        this.myBreakpoint.createRequestForPreparedClass(debugProcess, ref);
    }

    public void obsolete() {
        DebugProcess process2;
        MemoryViewDebugProcessData data;
        XDebugSession session;
        if (this.myNewObjects != null) {
            this.myNewObjects.forEach(DebuggerUtilsEx::enableCollection);
        }
        this.myNewObjects = null;
        if (!this.myIsBackgroundMode || this.myIsBackgroundTrackingEnabled) {
            this.myBreakpoint.enable();
        }
        if ((session = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession()) != null && (data = (MemoryViewDebugProcessData)(process2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(session.getDebugProcess().getProcessHandler())).getUserData(MemoryViewDebugProcessData.KEY)) != null) {
            data.getTrackedStacks().release();
        }
    }

    public void commitTracked() {
        this.myNewObjects = this.myTrackedObjects;
        this.myTrackedObjects = new HashSet();
    }

    @Override
    @NotNull
    public List<ObjectReference> getNewInstances() {
        List<Object> list = this.myNewObjects == null ? Collections.EMPTY_LIST : new ArrayList<ObjectReference>(this.myNewObjects);
        if (list == null) {
            ConstructorInstancesTracker.$$$reportNull$$$0(3);
        }
        return list;
    }

    public int getCount() {
        return this.myNewObjects == null ? 0 : this.myNewObjects.size();
    }

    public void enable() {
        this.myBreakpoint.enable();
    }

    public void disable() {
        this.myBreakpoint.disable();
    }

    public boolean isReady() {
        return this.myNewObjects != null;
    }

    public void dispose() {
        this.myBreakpoint.delete();
        this.myTrackedObjects.clear();
        this.myNewObjects = null;
    }

    @Override
    public void setBackgroundMode(boolean isBackgroundMode) {
        if (this.myIsBackgroundMode == isBackgroundMode) {
            return;
        }
        this.myIsBackgroundMode = isBackgroundMode;
        if (isBackgroundMode) {
            this.doEnableBackgroundMode();
        } else {
            this.doDisableBackgroundMode();
        }
    }

    private void doDisableBackgroundMode() {
        this.myBreakpoint.enable();
    }

    private void doEnableBackgroundMode() {
        if (!this.myIsBackgroundTrackingEnabled) {
            this.myBreakpoint.disable();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instancesTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewInstances";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyConstructorBreakpointBase
    extends SyntheticLineBreakpoint {
        protected MyConstructorBreakpointBase(@NotNull Project project2) {
            if (project2 == null) {
                MyConstructorBreakpointBase.$$$reportNull$$$0(0);
            }
            super(project2);
            this.setSuspendPolicy("SuspendThread");
        }

        @Override
        @Nullable
        public SourcePosition getSourcePosition() {
            return null;
        }

        @Override
        public int getLineIndex() {
            return -1;
        }

        @Override
        public String getEventMessage(LocatableEvent event) {
            return "";
        }

        @Override
        @Nullable
        protected JavaLineBreakpointType getXBreakpointType() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpointBase", "<init>"));
        }
    }

    private final class MyConstructorBreakpoints
    extends MyConstructorBreakpointBase {
        private final List<BreakpointRequest> myRequests;
        private final String myDisplayName;
        private volatile boolean myIsEnabled;
        private volatile boolean myIsDeleted;

        MyConstructorBreakpoints(Project project2) {
            super(project2);
            this.myRequests = new ArrayList<BreakpointRequest>();
            this.myDisplayName = "MemoryViewConstructorTracker:" + ConstructorInstancesTracker.this.myClassName;
            this.myIsEnabled = false;
            this.myIsDeleted = false;
            this.setVisible(false);
        }

        @Override
        protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
            classType.methods().stream().filter(Method::isConstructor).forEach(cons -> {
                Location loc = cons.location();
                BreakpointRequest breakpointRequest = debugProcess.getRequestsManager().createBreakpointRequest(this, loc);
                this.myRequests.add(breakpointRequest);
            });
            if (!ConstructorInstancesTracker.this.myIsBackgroundMode || ConstructorInstancesTracker.this.myIsBackgroundTrackingEnabled) {
                this.enable();
            }
        }

        @Override
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @Override
        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        void delete() {
            this.myRequests.clear();
            this.myIsDeleted = true;
        }

        @Override
        public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
            if (this.myIsDeleted) {
                event.request().disable();
            } else {
                this.handleEvent(action, event);
            }
            return false;
        }

        void enable() {
            if (!this.myIsEnabled && !this.myIsDeleted) {
                this.myRequests.forEach(EventRequest::enable);
                this.myIsEnabled = true;
            }
        }

        void disable() {
            if (this.myIsEnabled && !this.myIsDeleted) {
                this.myRequests.forEach(EventRequest::disable);
                this.myIsEnabled = false;
            }
        }

        private void handleEvent(@NotNull SuspendContextCommandImpl action, @NotNull LocatableEvent event) {
            if (action == null) {
                MyConstructorBreakpoints.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyConstructorBreakpoints.$$$reportNull$$$0(1);
            }
            try {
                SuspendContextImpl suspendContext = action.getSuspendContext();
                if (suspendContext != null) {
                    MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)suspendContext.getDebugProcess().getUserData(MemoryViewDebugProcessData.KEY);
                    ObjectReference thisRef = this.getThisObject(suspendContext, event);
                    if (thisRef != null && thisRef.referenceType().name().equals(ConstructorInstancesTracker.this.myClassName) && data != null) {
                        DebuggerUtilsEx.disableCollection(thisRef);
                        ConstructorInstancesTracker.this.myTrackedObjects.add(thisRef);
                        data.getTrackedStacks().addStack(thisRef, StackFrameItem.createFrames(suspendContext, false));
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (ConstructorInstancesTracker.this.myTrackedObjects.size() >= 2000) {
                this.disable();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpoints";
            objectArray[2] = "handleEvent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

