/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;
    private static final char SEPARATOR = '\r';

    public TextWithImportsImpl(@NotNull PsiElement expression) {
        if (expression == null) {
            TextWithImportsImpl.$$$reportNull$$$0(0);
        }
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text = expression.getText();
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = StdFileTypes.JAVA;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text, @NotNull String imports, @Nullable FileType fileType) {
        if (text == null) {
            TextWithImportsImpl.$$$reportNull$$$0(1);
        }
        if (imports == null) {
            TextWithImportsImpl.$$$reportNull$$$0(2);
        }
        this.myKind = kind;
        this.myText = text;
        this.myImports = imports;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text) {
        if (text == null) {
            TextWithImportsImpl.$$$reportNull$$$0(3);
        }
        this.myKind = kind;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        String string = this.myImports;
        if (string == null) {
            TextWithImportsImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Comparing.equal((String)item.myText, (String)this.myText) && Comparing.equal((String)item.myImports, (String)this.myImports);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String result = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result = result + '\r' + this.myImports;
        }
        if (this.myFileType != null) {
            result = result + '\r' + this.myFileType.getName();
        }
        return result;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports text) {
        if (text != null && !text.getText().isEmpty()) {
            return new XExpressionImpl(text.getText(), LanguageUtil.getFileTypeLanguage((FileType)text.getFileType()), StringUtil.nullize((String)text.getImports()), TextWithImportsImpl.getMode(text.getKind()));
        }
        return null;
    }

    @NotNull
    private static EvaluationMode getMode(@NotNull CodeFragmentKind kind) {
        if (kind == null) {
            TextWithImportsImpl.$$$reportNull$$$0(5);
        }
        switch (kind) {
            case EXPRESSION: {
                EvaluationMode evaluationMode = EvaluationMode.EXPRESSION;
                if (evaluationMode == null) {
                    TextWithImportsImpl.$$$reportNull$$$0(6);
                }
                return evaluationMode;
            }
            case CODE_BLOCK: {
                EvaluationMode evaluationMode = EvaluationMode.CODE_FRAGMENT;
                if (evaluationMode == null) {
                    TextWithImportsImpl.$$$reportNull$$$0(7);
                }
                return evaluationMode;
            }
        }
        throw new IllegalStateException("Unknown kind " + kind);
    }

    @NotNull
    private static CodeFragmentKind getKind(@NotNull EvaluationMode mode) {
        if (mode == null) {
            TextWithImportsImpl.$$$reportNull$$$0(8);
        }
        switch (mode) {
            case EXPRESSION: {
                CodeFragmentKind codeFragmentKind = CodeFragmentKind.EXPRESSION;
                if (codeFragmentKind == null) {
                    TextWithImportsImpl.$$$reportNull$$$0(9);
                }
                return codeFragmentKind;
            }
            case CODE_FRAGMENT: {
                CodeFragmentKind codeFragmentKind = CodeFragmentKind.CODE_BLOCK;
                if (codeFragmentKind == null) {
                    TextWithImportsImpl.$$$reportNull$$$0(10);
                }
                return codeFragmentKind;
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public static TextWithImports fromXExpression(@Nullable XExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression.getCustomInfo() == null && expression.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression.getMode()), expression.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression.getMode()), expression.getExpression(), StringUtil.notNullize((String)expression.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)expression.getLanguage()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

