/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.SrcFileAnnotator;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageDataManagerImpl
extends CoverageDataManager {
    private static final String REPLACE_ACTIVE_SUITES = "&Replace active suites";
    private static final String ADD_TO_ACTIVE_SUITES = "&Add to active suites";
    private static final String DO_NOT_APPLY_COLLECTED_COVERAGE = "Do not apply &collected coverage";
    private final List<CoverageSuiteListener> myListeners;
    private static final Logger LOG = Logger.getInstance(CoverageDataManagerImpl.class);
    @NonNls
    private static final String SUITE = "SUITE";
    private final Project myProject;
    private final Set<CoverageSuite> myCoverageSuites;
    private boolean myIsProjectClosing;
    private final Object myLock;
    private boolean mySubCoverageIsActive;
    private final VirtualFileContentsChangedAdapter myContentListener;
    private Set<LocalFileSystem.WatchRequest> myWatchRequests;
    private List<String> myCurrentSuiteRoots;
    private CoverageSuitesBundle myCurrentSuitesBundle;
    private final Object ANNOTATORS_LOCK;
    private final Map<Editor, SrcFileAnnotator> myAnnotators;

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.myCurrentSuitesBundle;
    }

    public CoverageDataManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCoverageSuites = new HashSet<CoverageSuite>();
        this.myIsProjectClosing = false;
        this.myLock = new Object();
        this.myContentListener = new VirtualFileContentsChangedAdapter(){

            protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CoverageDataManagerImpl.this.myCurrentSuiteRoots != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), (Collection)CoverageDataManagerImpl.this.myCurrentSuiteRoots)) {
                    CoverageDataManagerImpl.this.myCurrentSuitesBundle.restoreCoverageData();
                    CoverageDataManagerImpl.this.updateCoverageData(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
                }
            }

            protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "fileOrDirectory";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.ANNOTATORS_LOCK = new Object();
        this.myAnnotators = new HashMap<Editor, SrcFileAnnotator>();
        this.myProject = project2;
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project2 == CoverageDataManagerImpl.this.myProject) {
                    EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new CoverageEditorFactoryListener(), (Disposable)CoverageDataManagerImpl.this.myProject);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (project2 != CoverageDataManagerImpl.this.myProject) {
                    return;
                }
                Object object = CoverageDataManagerImpl.this.myLock;
                synchronized (object) {
                    CoverageDataManagerImpl.this.myIsProjectClosing = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CoverageViewSuiteListener coverageViewListener = this.createCoverageViewListener();
        if (coverageViewListener != null) {
            this.addSuiteListener(coverageViewListener, (Disposable)this.myProject);
        }
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.myProject);
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (Element suiteElement : element.getChildren(SUITE)) {
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(suiteElement);
            if (coverageRunner == null) {
                CoverageFileProvider fileProvider = BaseCoverageSuite.readDataFileProviderAttribute(suiteElement);
                if (!fileProvider.isValid()) continue;
                continue;
            }
            CoverageSuite suite = null;
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(engine) || (suite = engine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(suite instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)suite).setProject(this.myProject);
                break;
            }
            if (suite == null) continue;
            try {
                suite.readExternal(suiteElement);
                this.myCoverageSuites.add(suite);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (CoverageSuite coverageSuite : this.myCoverageSuites) {
            Element suiteElement = new Element(SUITE);
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
    }

    @Override
    public CoverageSuite addCoverageSuite(String name2, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, name2, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name2.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(suite);
        }
        this.myCoverageSuites.remove(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, selectedFileName, fileProvider, ArrayUtil.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        String name2 = config.getName() + " Coverage Results";
        String covFilePath = config.getCoverageFilePath();
        assert (covFilePath != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        LOG.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider fileProvider = new DefaultCoverageFileProvider(new File(covFilePath));
        CoverageSuite suite = CoverageDataManagerImpl.createCoverageSuite(config, name2, coverageRunner, fileProvider);
        this.removeCoverageSuite(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        suite.deleteCachedCoverageData();
        this.myCoverageSuites.remove(suite);
        if (this.myCurrentSuitesBundle != null && this.myCurrentSuitesBundle.contains(suite)) {
            Object[] suites = this.myCurrentSuitesBundle.getSuites();
            this.chooseSuitesBundle((suites = (CoverageSuite[])ArrayUtil.remove((Object[])suites, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])suites) : null);
        }
    }

    @Override
    @NotNull
    public CoverageSuite[] getSuites() {
        CoverageSuite[] coverageSuiteArray = this.myCoverageSuites.toArray(new CoverageSuite[0]);
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(1);
        }
        return coverageSuiteArray;
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle == suite && suite == null) {
            return;
        }
        if (this.myWatchRequests != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myContentListener);
            this.myWatchRequests = null;
            this.myCurrentSuiteRoots = null;
        }
        this.updateCoverageData(suite);
    }

    private void updateCoverageData(CoverageSuitesBundle suite) {
        LOG.assertTrue(!this.myProject.isDefault());
        this.fireBeforeSuiteChosen();
        this.mySubCoverageIsActive = false;
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        }
        this.myCurrentSuitesBundle = suite;
        this.disposeAnnotators();
        if (suite == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.myCurrentSuitesBundle.getSuites()) {
            boolean suiteFileExists = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (suiteFileExists) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(suite);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myCurrentSuitesBundle != null) {
                int answer;
                String[] stringArray;
                String message = CodeInsightBundle.message((String)"display.coverage.prompt", (Object[])new Object[]{suite.getPresentableName()});
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.myProject);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$4", "getDoNotShowMessage"));
                    }
                };
                if (this.myCurrentSuitesBundle.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = REPLACE_ACTIVE_SUITES;
                    stringArray2[1] = ADD_TO_ACTIVE_SUITES;
                    stringArray = stringArray2;
                    stringArray2[2] = DO_NOT_APPLY_COLLECTED_COVERAGE;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = REPLACE_ACTIVE_SUITES;
                    stringArray = stringArray3;
                    stringArray3[1] = DO_NOT_APPLY_COLLECTED_COVERAGE;
                }
                String[] options = stringArray;
                int n = answer = doNotAskOption.isToBeShown() ? Messages.showDialog((String)message, (String)CodeInsightBundle.message((String)"code.coverage", (Object[])new Object[0]), (String[])options, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (answer == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (answer == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.myCurrentSuitesBundle.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.renewInformationInEditors();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.myProject).refresh();
            CoverageViewManager.getInstance(this.myProject).setReady(true);
        });
    }

    @Override
    public void attachToProcess(@NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(4);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$5", "processTerminated"));
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(5);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public void addRootsToWatch(List<CoverageSuite> suites) {
        this.myCurrentSuiteRoots = ContainerUtil.map(suites, suite -> suite.getCoverageDataFileName());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        this.myCurrentSuiteRoots.forEach(path -> fileSystem.refreshAndFindFileByPath(path));
        this.myWatchRequests = fileSystem.addRootsToWatch(this.myCurrentSuiteRoots, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myContentListener);
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project2);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
        }
    }

    private void renewInformationInEditors() {
        VirtualFile[] openFiles;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            this.applyInformationToEditor(allEditors, openFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInformationToEditor(FileEditor[] editors, VirtualFile file) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.myProject).findFile(file));
        if (psiFile != null && this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
            SrcFileAnnotator annotator;
            Object object;
            Editor textEditor;
            CoverageEngine engine = this.myCurrentSuitesBundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                object = this.ANNOTATORS_LOCK;
                synchronized (object) {
                    annotator = this.myAnnotators.remove(textEditor);
                }
                if (annotator == null) break;
                Disposer.dispose((Disposable)annotator);
                break;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                annotator = this.getAnnotator(textEditor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, textEditor);
                    object = this.ANNOTATORS_LOCK;
                    synchronized (object) {
                        this.myAnnotators.put(textEditor, annotator);
                    }
                }
                if (this.myCurrentSuitesBundle == null || !engine.acceptedByFilters(psiFile, this.myCurrentSuitesBundle)) continue;
                annotator.showCoverageInformation(this.myCurrentSuitesBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(7);
        }
        suite.restoreCoverageData();
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap<String, Set<Integer>> executionTrace = new HashMap<String, Set<Integer>>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            suite.getCoverageEngine().collectTestLines(testNames, coverageSuite, executionTrace);
        }
        ProjectData projectData = new ProjectData();
        for (String className : executionTrace.keySet()) {
            ClassData loadedClassData = projectData.getClassData(className);
            if (loadedClassData == null) {
                loadedClassData = projectData.getOrCreateClassData(className);
            }
            Set lineNumbers = (Set)executionTrace.get(className);
            ClassData oldData = data.getClassData(className);
            LOG.assertTrue(oldData != null, (Object)("missed className: \"" + className + "\""));
            Object[] oldLines = oldData.getLines();
            LOG.assertTrue(oldLines != null);
            int maxNumber = oldLines.length;
            for (Integer lineNumber : lineNumbers) {
                if (lineNumber < maxNumber) continue;
                maxNumber = lineNumber + 1;
            }
            LineData[] lines = new LineData[maxNumber];
            for (Integer line : lineNumbers) {
                LineData oldLineData;
                int lineIdx = line - 1;
                String methodSig = null;
                if (lineIdx < oldData.getLines().length && (oldLineData = oldData.getLineData(lineIdx)) != null) {
                    methodSig = oldLineData.getMethodSignature();
                }
                LineData lineData = new LineData(lineIdx, methodSig);
                if (methodSig != null) {
                    loadedClassData.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lines[lineIdx] = lineData;
            }
            loadedClassData.setLines(lines);
        }
        suite.setCoverageData(projectData);
        this.renewCoverageData(suite);
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(8);
        }
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener, Disposable parentDisposable) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SrcFileAnnotator getAnnotator(Editor editor) {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            return this.myAnnotators.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            for (SrcFileAnnotator annotator : this.myAnnotators.values()) {
                if (annotator == null) continue;
                Disposer.dispose((Disposable)annotator);
            }
            this.myAnnotators.clear();
        }
    }

    @NotNull
    private static CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config, String name2, CoverageRunner coverageRunner, DefaultCoverageFileProvider fileProvider) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && engine.isApplicableTo(config.getConfiguration()) && (suite = engine.createCoverageSuite(coverageRunner, name2, fileProvider, config)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(9);
        }
        return coverageSuite;
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageRunner coverageRunner, String name2, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMergeWith, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && (suite = engine.createCoverageSuite(coverageRunner, name2, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled, false, this.myProject)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite = suite;
        if (coverageSuite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(10);
        }
        return coverageSuite;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Alarm myAlarm;
        private final Map<Editor, Runnable> myCurrentEditors;

        private CoverageEditorFactoryListener() {
            this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)CoverageDataManagerImpl.this.myProject);
            this.myCurrentEditors = new HashMap<Editor, Runnable>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(0);
            }
            Object object = CoverageDataManagerImpl.this.myLock;
            synchronized (object) {
                if (CoverageDataManagerImpl.this.myIsProjectClosing) {
                    return;
                }
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != CoverageDataManagerImpl.this.myProject) {
                return;
            }
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                    return null;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)CoverageDataManagerImpl.this.myProject);
                Document document = editor.getDocument();
                return documentManager.getPsiFile(document);
            });
            if (psiFile != null && CoverageDataManagerImpl.this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
                CoverageEngine engine = CoverageDataManagerImpl.this.myCurrentSuitesBundle.getCoverageEngine();
                if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                SrcFileAnnotator annotator = CoverageDataManagerImpl.this.getAnnotator(editor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, editor);
                }
                SrcFileAnnotator finalAnnotator = annotator;
                Object object2 = CoverageDataManagerImpl.this.ANNOTATORS_LOCK;
                synchronized (object2) {
                    CoverageDataManagerImpl.this.myAnnotators.put(editor, finalAnnotator);
                }
                Runnable request = () -> {
                    if (CoverageDataManagerImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    if (CoverageDataManagerImpl.this.myCurrentSuitesBundle != null && engine.acceptedByFilters(psiFile, CoverageDataManagerImpl.this.myCurrentSuitesBundle)) {
                        finalAnnotator.showCoverageInformation(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
                    }
                };
                this.myCurrentEditors.put(editor, request);
                this.myAlarm.addRequest(request, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((editor = event.getEditor()).getProject() != CoverageDataManagerImpl.this.myProject) {
                return;
            }
            try {
                SrcFileAnnotator fileAnnotator;
                Object object = CoverageDataManagerImpl.this.ANNOTATORS_LOCK;
                synchronized (object) {
                    fileAnnotator = (SrcFileAnnotator)CoverageDataManagerImpl.this.myAnnotators.remove(editor);
                }
                if (fileAnnotator != null) {
                    Disposer.dispose((Disposable)fileAnnotator);
                }
            }
            finally {
                Runnable request = this.myCurrentEditors.remove(editor);
                if (request != null) {
                    this.myAlarm.cancelRequest(request);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

