/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.TableModelEditor;
import gnu.trove.THashSet;
import java.awt.Container;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\"$\u0010\u0000\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\b\u0001\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\t"}, d2={"COLUMNS", "", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "", "[Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "createReadOnlySourcesEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "intellij.settingsRepository"})
public final class ReadOnlySourcesEditorKt {
    private static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Object>[] COLUMNS = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){

        @NotNull
        public Class<Boolean> getColumnClass() {
            return Boolean.TYPE;
        }

        @NotNull
        public Boolean valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getActive();
        }

        public void setValue(@NotNull ReadonlySource item, boolean value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            item.setActive(value);
        }
    }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){

        @Nullable
        public String valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            return item.getUrl();
        }

        public void setValue(@NotNull ReadonlySource item, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            item.setUrl(value);
        }
    }};

    @NotNull
    public static final ConfigurableUi<IcsSettings> createReadOnlySourcesEditor() {
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(){
            static final /* synthetic */ KProperty[] $$delegatedProperties;

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty0((MutablePropertyReference0)new MutablePropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(createReadOnlySourcesEditor.itemEditor.1.class), "urlField", "<v#0>"))};
            }

            @NotNull
            public ReadonlySource clone(@NotNull ReadonlySource item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            /*
             * WARNING - void declaration
             */
            public void edit(@NotNull ReadonlySource item, @NotNull Function<ReadonlySource, ReadonlySource> mutator, boolean isAdd) {
                void this_$iv$iv;
                Row row$iv$iv;
                void this_$iv;
                LayoutBuilder builder$iv;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull(mutator, (String)"mutator");
                KProperty kProperty = $$delegatedProperties[0];
                ReadWriteProperty urlField = Delegates.INSTANCE.notNull();
                Object[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $receiver = builder$iv = LayoutImplKt.createLayoutBuilder((!ArraysKt.contains((Object[])constraints$iv, (Object)LCFlags.disableMagic) ? 1 : 0) != 0);
                boolean bl = false;
                LayoutBuilder layoutBuilder = $receiver;
                String label$iv = "URL:";
                boolean $i$f$row = false;
                void var16_15 = this_$iv;
                JLabel label$iv$iv = ComponentsKt.Label$default((String)label$iv, null, null, (boolean)false, (int)14, null);
                boolean separated$iv$iv = false;
                boolean $i$f$row2 = false;
                Row $receiver2 = row$iv$iv = this_$iv$iv.getBuilder().newRow(label$iv$iv, this_$iv$iv.getButtonGroup(), separated$iv$iv);
                boolean bl2 = false;
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileChooserDescriptor, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
                urlField.setValue(null, kProperty, (Object)Cell.textFieldWithBrowseButton$default((Cell)$receiver2, (String)"Choose Local Git Repository", null, null, (FileChooserDescriptor)fileChooserDescriptor, null, null, (int)54, null));
                JPanel panel$iv = ComponentsKt.Panel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
                JPanel panel = panel$iv;
                ComponentsKt.dialog$default((String)"Add read-only source", (JComponent)panel, (boolean)false, (JComponent)((JComponent)urlField.getValue(null, kProperty)), (boolean)false, null, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(urlField, kProperty, mutator, item){
                    final /* synthetic */ ReadWriteProperty $urlField;
                    final /* synthetic */ KProperty $urlField$metadata;
                    final /* synthetic */ Function $mutator;
                    final /* synthetic */ ReadonlySource $item;

                    @Nullable
                    public final List<ValidationInfo> invoke() {
                        String url = StringKt.nullize((String)((TextFieldWithBrowseButton)this.$urlField.getValue(null, this.$urlField$metadata)).getText(), (boolean)true);
                        String string = UpstreamEditorKt.validateUrl(url, null);
                        if (string != null) {
                            String string2;
                            String it = string2 = string;
                            boolean bl = false;
                            return CollectionsKt.listOf((Object)new ValidationInfo(it));
                        }
                        ((ReadonlySource)this.$mutator.fun((Object)this.$item)).setUrl(url);
                        return null;
                    }
                    {
                        this.$urlField = readWriteProperty;
                        this.$urlField$metadata = kProperty;
                        this.$mutator = function;
                        this.$item = readonlySource;
                        super(0);
                    }
                }), (int)1012, null).show();
            }

            public void applyEdited(@NotNull ReadonlySource oldItem, @NotNull ReadonlySource newItem) {
                Intrinsics.checkParameterIsNotNull((Object)oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        TableModelEditor editor2 = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, "No sources configured");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        editor2.reset((List)(application.isUnitTestMode() ? CollectionsKt.emptyList() : IcsManagerKt.getIcsManager().getSettings().getReadOnlySources()));
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor2){
            final /* synthetic */ TableModelEditor $editor;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List<ReadonlySource> oldList = settings.getReadOnlySources();
                THashSet toDelete = new THashSet(oldList.size());
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)((Collection)toDelete), (Object)oldSource.getPath());
                }
                THashSet toCheckout = new THashSet();
                List list = this.$editor.apply();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"editor.apply()");
                List newList = list;
                for (ReadonlySource newSource : newList) {
                    String path = newSource.getPath();
                    if (path == null || toDelete.remove((Object)path)) continue;
                    toCheckout.add((Object)newSource);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                String title$iv = IcsBundleKt.icsMessage("task.sync.title", new Object[0]);
                Project project$iv = null;
                boolean cancellable$iv = true;
                boolean $i$f$runModalTask = false;
                ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, toDelete, toCheckout, newList){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $title;
                    final /* synthetic */ boolean $cancellable;
                    final /* synthetic */ THashSet $toDelete$inlined;
                    final /* synthetic */ THashSet $toCheckout$inlined;
                    final /* synthetic */ List $newList$inlined;
                    {
                        this.$project = $captured_local_variable$1;
                        this.$title = $captured_local_variable$2;
                        this.$cancellable = $captured_local_variable$3;
                        this.$toDelete$inlined = tHashSet;
                        this.$toCheckout$inlined = tHashSet2;
                        this.$newList$inlined = list;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        boolean $i$f$runAndLogException;
                        Logger $receiver$iv;
                        Object path2;
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        ProgressIndicator indicator2 = indicator;
                        boolean bl = false;
                        indicator2.setIndeterminate(true);
                        Path root = IcsManagerKt.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        Collection collection = (Collection)this.$toDelete$inlined;
                        if (!collection.isEmpty()) {
                            indicator2.setText("Deleting old repositories");
                            for (Object path2 : this.$toDelete$inlined) {
                                indicator2.checkCanceled();
                                $receiver$iv = IcsManagerKt.getLOG();
                                $i$f$runAndLogException = false;
                                try {
                                    boolean bl2 = false;
                                    indicator2.setText2((String)path2);
                                    Path path3 = root.resolve((String)path2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"root.resolve(path)");
                                    PathKt.delete$default((Path)path3, (boolean)false, (int)1, null);
                                }
                                catch (ProcessCanceledException e$iv) {
                                    throw (Throwable)e$iv;
                                }
                                catch (Throwable e$iv) {
                                    $receiver$iv.error(e$iv);
                                }
                            }
                        }
                        if (!(path2 = (Collection)this.$toCheckout$inlined).isEmpty()) {
                            for (ReadonlySource source : this.$toCheckout$inlined) {
                                indicator2.checkCanceled();
                                $receiver$iv = IcsManagerKt.getLOG();
                                $i$f$runAndLogException = false;
                                try {
                                    Path dir;
                                    boolean bl3 = false;
                                    StringBuilder stringBuilder = new StringBuilder().append("Cloning ");
                                    String string = source.getUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    indicator2.setText(stringBuilder.append(StringKt.trimMiddle$default((String)string, (int)255, (boolean)false, (int)2, null)).toString());
                                    String string2 = source.getPath();
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Path path4 = dir = root.resolve(string2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"dir");
                                    if (PathKt.exists((Path)path4)) {
                                        PathKt.delete$default((Path)dir, (boolean)false, (int)1, null);
                                    }
                                    String string3 = source.getUrl();
                                    if (string3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    GitExKt.cloneBare(string3, dir, IcsManagerKt.getIcsManager().getCredentialsStore(), JGitProgressMonitorKt.asProgressMonitor(indicator2)).close();
                                }
                                catch (ProcessCanceledException e$iv) {
                                    throw (Throwable)e$iv;
                                }
                                catch (Throwable e$iv) {
                                    $receiver$iv.error(e$iv);
                                }
                            }
                        }
                        IcsManagerKt.getIcsManager().getReadOnlySourcesManager().setSources(this.$newList$inlined);
                        ((SchemeManagerFactoryBase)IcsManagerKt.getIcsManager().getSchemeManagerFactory().getValue()).process((Function1)createReadOnlySourcesEditor.apply.1.3.INSTANCE);
                    }
                });
            }

            public void reset(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                this.$editor.reset(settings.getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = this.$editor.createComponent();
                Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.createComponent()");
                return jComponent;
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }
}

