/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleBuildSrcProjectsResolver {
    public static final String BUILD_SRC_MODULE_PROPERTY = "buildSrcModule";
    @NotNull
    private final GradleProjectResolver myProjectResolver;
    @NotNull
    private final DefaultProjectResolverContext myResolverContext;
    @Nullable
    private final File myGradleUserHome;
    @Nullable
    private final GradleExecutionSettings myMainBuildExecutionSettings;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId mySyncTaskId;
    @NotNull
    private final GradleProjectResolverExtension myResolverChain;

    public GradleBuildSrcProjectsResolver(@NotNull GradleProjectResolver projectResolver, @NotNull DefaultProjectResolverContext resolverContext, @Nullable File gradleUserHome, @Nullable GradleExecutionSettings mainBuildSettings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId syncTaskId, @NotNull GradleProjectResolverExtension projectResolverChain) {
        if (projectResolver == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(0);
        }
        if (resolverContext == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(1);
        }
        if (listener == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(2);
        }
        if (syncTaskId == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(3);
        }
        if (projectResolverChain == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(4);
        }
        this.myProjectResolver = projectResolver;
        this.myResolverContext = resolverContext;
        this.myGradleUserHome = gradleUserHome;
        this.myMainBuildExecutionSettings = mainBuildSettings;
        this.myListener = listener;
        this.mySyncTaskId = syncTaskId;
        this.myResolverChain = projectResolverChain;
    }

    public void discoverAndAppendTo(@NotNull DataNode<ProjectData> mainBuildProjectDataNode) {
        if (mainBuildProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(5);
        }
        String gradleHome = this.myGradleUserHome == null ? null : this.myGradleUserHome.getPath();
        ProjectData mainBuildProjectData = (ProjectData)mainBuildProjectDataNode.getData();
        String projectPath = mainBuildProjectData.getLinkedExternalProjectPath();
        HashMap includedBuildsPaths = ContainerUtil.newHashMap();
        HashMap buildNames = ContainerUtil.newHashMap();
        buildNames.put(projectPath, mainBuildProjectData.getExternalName());
        DataNode compositeBuildData = ExternalSystemApiUtil.find(mainBuildProjectDataNode, CompositeBuildData.KEY);
        if (compositeBuildData != null) {
            for (BuildParticipant buildParticipant : ((CompositeBuildData)compositeBuildData.getData()).getCompositeParticipants()) {
                String buildParticipantRootPath = buildParticipant.getRootPath();
                buildNames.put(buildParticipantRootPath, buildParticipant.getRootProjectName());
                for (String path : buildParticipant.getProjects()) {
                    includedBuildsPaths.put(path, buildParticipantRootPath);
                }
            }
        }
        MultiMap buildClasspathNodesMap = MultiMap.createSmart();
        HashMap includedModulesPaths = ContainerUtil.newHashMap();
        for (DataNode moduleDataNode : ExternalSystemApiUtil.findAll(mainBuildProjectDataNode, (Key)ProjectKeys.MODULE)) {
            String path;
            path = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            includedModulesPaths.put(path, moduleDataNode.getData());
            DataNode scriptClasspathDataNode = ExternalSystemApiUtil.find((DataNode)moduleDataNode, BuildScriptClasspathData.KEY);
            if (scriptClasspathDataNode == null) continue;
            String rootPath = (String)includedBuildsPaths.get(path);
            buildClasspathNodesMap.putValue((Object)(rootPath != null ? rootPath : projectPath), (Object)scriptClasspathDataNode);
        }
        List jvmOptions = ContainerUtil.newSmartList();
        BuildEnvironment mainBuildEnvironment = this.myResolverContext.getModels().getBuildEnvironment();
        if (mainBuildEnvironment != null) {
            jvmOptions.addAll(mainBuildEnvironment.getJava().getJvmArguments());
        }
        if (this.myMainBuildExecutionSettings != null) {
            jvmOptions.addAll(this.myMainBuildExecutionSettings.getJvmArguments());
        }
        for (String buildPath : buildClasspathNodesMap.keySet()) {
            GradleExecutionSettings buildSrcProjectSettings;
            Collection buildClasspathNodes = buildClasspathNodesMap.get((Object)buildPath);
            if (gradleHome != null) {
                if (this.myMainBuildExecutionSettings != null) {
                    buildSrcProjectSettings = new GradleExecutionSettings(gradleHome, this.myMainBuildExecutionSettings.getServiceDirectory(), DistributionType.LOCAL, this.myMainBuildExecutionSettings.isOfflineWork());
                    buildSrcProjectSettings.setIdeProjectPath(this.myMainBuildExecutionSettings.getIdeProjectPath());
                    buildSrcProjectSettings.setJavaHome(this.myMainBuildExecutionSettings.getJavaHome());
                    buildSrcProjectSettings.setResolveModulePerSourceSet(this.myMainBuildExecutionSettings.isResolveModulePerSourceSet());
                    buildSrcProjectSettings.setUseQualifiedModuleNames(this.myMainBuildExecutionSettings.isUseQualifiedModuleNames());
                    buildSrcProjectSettings.setRemoteProcessIdleTtlInMs(this.myMainBuildExecutionSettings.getRemoteProcessIdleTtlInMs());
                    buildSrcProjectSettings.setVerboseProcessing(this.myMainBuildExecutionSettings.isVerboseProcessing());
                    buildSrcProjectSettings.setWrapperPropertyFile(this.myMainBuildExecutionSettings.getWrapperPropertyFile());
                    buildSrcProjectSettings.withArguments(this.myMainBuildExecutionSettings.getArguments()).withEnvironmentVariables(this.myMainBuildExecutionSettings.getEnv()).passParentEnvs(this.myMainBuildExecutionSettings.isPassParentEnvs()).withVmOptions((Collection)jvmOptions);
                } else {
                    buildSrcProjectSettings = new GradleExecutionSettings(gradleHome, null, DistributionType.LOCAL, false);
                }
            } else {
                buildSrcProjectSettings = this.myMainBuildExecutionSettings;
            }
            String buildSrcProjectPath = buildPath + "/buildSrc";
            DefaultProjectResolverContext buildSrcResolverCtx = new DefaultProjectResolverContext(this.mySyncTaskId, buildSrcProjectPath, buildSrcProjectSettings, this.myListener, false);
            this.myResolverContext.copyUserDataTo(buildSrcResolverCtx);
            String buildName = (String)buildNames.get(buildPath);
            String buildSrcGroup = GradleBuildSrcProjectsResolver.getBuildSrcGroup(buildPath, buildName);
            buildSrcResolverCtx.setBuildSrcGroup(buildSrcGroup);
            this.handleBuildSrcProject(mainBuildProjectDataNode, buildName, buildClasspathNodes, includedModulesPaths, buildSrcResolverCtx, this.myProjectResolver.getProjectDataFunction(buildSrcResolverCtx, this.myResolverChain, true));
        }
    }

    private void handleBuildSrcProject(@NotNull DataNode<ProjectData> resultProjectDataNode, @Nullable String buildName, @NotNull Collection<DataNode<BuildScriptClasspathData>> buildClasspathNodes, @NotNull Map<String, ModuleData> includedModulesPaths, @NotNull DefaultProjectResolverContext buildSrcResolverCtx, @NotNull Function<ProjectConnection, DataNode<ProjectData>> projectConnectionDataNodeFunction) {
        String projectPath;
        File projectPathFile;
        if (resultProjectDataNode == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(6);
        }
        if (buildClasspathNodes == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(7);
        }
        if (includedModulesPaths == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(8);
        }
        if (buildSrcResolverCtx == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(9);
        }
        if (projectConnectionDataNodeFunction == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(10);
        }
        if (!(projectPathFile = new File(projectPath = buildSrcResolverCtx.getProjectPath())).isDirectory()) {
            return;
        }
        if (ArrayUtil.isEmpty((Object[])projectPathFile.list((dir, name) -> !name.equals(".gradle") && !name.equals("build")))) {
            return;
        }
        if (buildSrcResolverCtx.isPreviewMode()) {
            ModuleData buildSrcModuleData = new ModuleData(":buildSrc", GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), "buildSrc", projectPath, projectPath);
            buildSrcModuleData.setProperty(BUILD_SRC_MODULE_PROPERTY, "true");
            resultProjectDataNode.createChild(ProjectKeys.MODULE, (Object)buildSrcModuleData);
            return;
        }
        DataNode<ProjectData> buildSrcProjectDataNode = this.myProjectResolver.getHelper().execute(projectPath, buildSrcResolverCtx.getSettings(), projectConnectionDataNodeFunction);
        if (buildSrcProjectDataNode == null) {
            return;
        }
        HashMap buildSrcModules = ContainerUtil.newHashMap();
        boolean modulePerSourceSet = buildSrcResolverCtx.isResolveModulePerSourceSet();
        DataNode buildSrcModuleNode = null;
        for (DataNode moduleNode : ExternalSystemApiUtil.getChildren(buildSrcProjectDataNode, (Key)ProjectKeys.MODULE)) {
            ModuleData includedModule;
            ModuleData moduleData = (ModuleData)moduleNode.getData();
            buildSrcModules.put(moduleData.getId(), moduleNode);
            boolean isBuildSrcModule = "buildSrc".equals(moduleData.getExternalName());
            if (isBuildSrcModule && !modulePerSourceSet) {
                buildSrcModuleNode = moduleNode;
            }
            if (modulePerSourceSet) {
                for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    buildSrcModules.put(((GradleSourceSetData)((Object)sourceSetNode.getData())).getId(), sourceSetNode);
                    if (!isBuildSrcModule || buildSrcModuleNode != null || !((GradleSourceSetData)((Object)sourceSetNode.getData())).getExternalName().endsWith(":main")) continue;
                    buildSrcModuleNode = sourceSetNode;
                }
            }
            if ((includedModule = includedModulesPaths.get(moduleData.getLinkedExternalProjectPath())) == null) {
                moduleData.setProperty(BUILD_SRC_MODULE_PROPERTY, "true");
                resultProjectDataNode.addChild(moduleNode);
                if (buildSrcResolverCtx.isUseQualifiedModuleNames() || moduleData.getIdeModuleGroup() == null) continue;
                String[] moduleGroup = (String[])ArrayUtil.prepend((Object)(StringUtil.isNotEmpty((String)buildName) ? buildName : ((ProjectData)resultProjectDataNode.getData()).getInternalName()), (Object[])moduleData.getIdeModuleGroup());
                moduleData.setIdeModuleGroup(moduleGroup);
                for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    ((GradleSourceSetData)((Object)sourceSetNode.getData())).setIdeModuleGroup(moduleGroup);
                }
                continue;
            }
            includedModule.setProperty(BUILD_SRC_MODULE_PROPERTY, "true");
        }
        if (buildSrcModuleNode != null) {
            HashSet buildSrcRuntimeSourcesPaths = ContainerUtil.newHashSet();
            HashSet buildSrcRuntimeClassesPaths = ContainerUtil.newHashSet();
            GradleBuildSrcProjectsResolver.addSourcePaths(buildSrcRuntimeSourcesPaths, buildSrcModuleNode);
            for (DataNode child : buildSrcModuleNode.getChildren()) {
                LibraryDependencyData dependencyData;
                Object childData = child.getData();
                if (childData instanceof ModuleDependencyData && ((ModuleDependencyData)childData).getScope().isForProductionRuntime()) {
                    DataNode depModuleNode = (DataNode)buildSrcModules.get(((ModuleData)((ModuleDependencyData)childData).getTarget()).getId());
                    if (depModuleNode == null) continue;
                    GradleBuildSrcProjectsResolver.addSourcePaths(buildSrcRuntimeSourcesPaths, (DataNode<? extends ModuleData>)depModuleNode);
                    continue;
                }
                if (!(childData instanceof LibraryDependencyData) || (dependencyData = (LibraryDependencyData)childData).getExternalName().startsWith("gradle-api-")) continue;
                LibraryData libraryData = (LibraryData)dependencyData.getTarget();
                buildSrcRuntimeSourcesPaths.addAll(libraryData.getPaths(LibraryPathType.SOURCE));
                buildSrcRuntimeClassesPaths.addAll(libraryData.getPaths(LibraryPathType.BINARY));
            }
            if (!buildSrcRuntimeSourcesPaths.isEmpty() || !buildSrcRuntimeClassesPaths.isEmpty()) {
                buildClasspathNodes.forEach(classpathNode -> {
                    BuildScriptClasspathData data = (BuildScriptClasspathData)((Object)((Object)classpathNode.getData()));
                    ArrayList classpathEntries = ContainerUtil.newArrayList();
                    classpathEntries.addAll(data.getClasspathEntries());
                    classpathEntries.add(new BuildScriptClasspathData.ClasspathEntry(new HashSet<String>(buildSrcRuntimeClassesPaths), new HashSet<String>(buildSrcRuntimeSourcesPaths), Collections.emptySet()));
                    BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
                    buildScriptClasspathData.setGradleHomeDir(data.getGradleHomeDir());
                    DataNode parent = classpathNode.getParent();
                    assert (parent != null);
                    parent.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
                    classpathNode.clear(true);
                });
            }
        }
    }

    private static void addSourcePaths(Set<String> paths, DataNode<? extends ModuleData> moduleNode) {
        ExternalSystemApiUtil.getChildren(moduleNode, (Key)ProjectKeys.CONTENT_ROOT).stream().flatMap(contentNode -> ((ContentRootData)contentNode.getData()).getPaths(ExternalSystemSourceType.SOURCE).stream()).map(ContentRootData.SourceRoot::getPath).forEach(paths::add);
    }

    @NotNull
    private static String getBuildSrcGroup(String buildPath, String buildName) {
        if (StringUtil.isEmpty((String)buildName)) {
            String string = new File(buildPath).getName();
            if (string == null) {
                GradleBuildSrcProjectsResolver.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = buildName;
        if (string == null) {
            GradleBuildSrcProjectsResolver.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainBuildProjectDataNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultProjectDataNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildClasspathNodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedModulesPaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSrcResolverCtx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectConnectionDataNodeFunction";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleBuildSrcProjectsResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleBuildSrcProjectsResolver";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSrcGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "discoverAndAppendTo";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleBuildSrcProject";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

