/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.DistributionInstaller;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class DistributionFactoryExt
extends DistributionFactory {
    private DistributionFactoryExt() {
        super(Time.clock());
    }

    public static void setWrappedDistribution(GradleConnector connector, String wrapperPropertyFile, File gradleUserHome) {
        WrapperExecutor wrapper;
        File propertiesFile = new File(wrapperPropertyFile);
        if (propertiesFile.exists() && (wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile)).getDistribution() != null) {
            Distribution distribution = new DistributionFactoryExt().getWrappedDistribution(propertiesFile, gradleUserHome);
            try {
                DistributionFactoryExt.setDistributionField(connector, distribution);
            }
            catch (Exception e) {
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private Distribution getWrappedDistribution(File propertiesFile, File userHomeDir) {
        WrapperExecutor wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration(), DistributionFactoryExt.determineRealUserHomeDir(userHomeDir), Time.clock());
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    private static File determineRealUserHomeDir(File userHomeDir) {
        return userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version((String)gradleVersion));
        return this.getDistribution(distUri);
    }

    private static void setDistributionField(GradleConnector connector, Object fieldValue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = connector.getClass().getDeclaredField("distribution");
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        field.set(connector, fieldValue);
        field.setAccessible(isAccessible);
    }

    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;
        private final File distributionBaseDir;
        private final Clock clock;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration, File distributionBaseDir, Clock clock) {
            this.wrapperConfiguration = wrapperConfiguration;
            this.distributionBaseDir = distributionBaseDir;
            this.clock = clock;
        }

        public String getDisplayName() {
            return "Gradle distribution '" + this.wrapperConfiguration.getDistribution() + "'";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (this.installedDistribution == null) {
                File installDir;
                DistributionInstaller installer = new DistributionInstaller(progressLoggerFactory, progressListener, this.clock);
                try {
                    cancellationToken.addCallback(() -> installer.cancel());
                    installDir = installer.install(this.determineRealUserHomeDir(userHomeDir), this.wrapperConfiguration);
                }
                catch (CancellationException e) {
                    throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                }
                catch (Exception e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, progressListener, userHomeDir, cancellationToken);
        }

        private File determineRealUserHomeDir(File userHomeDir) {
            if (this.distributionBaseDir != null) {
                return this.distributionBaseDir;
            }
            return userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, File userHomeDir, BuildCancellationToken cancellationToken) {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            Object[] files = libDir.listFiles(file -> FileUtils.hasExtension((File)file, (String)".jar"));
            Arrays.sort(files);
            return new DefaultClassPath((File[])files);
        }
    }
}

