/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class WarDirectory
implements Serializable {
    public static final WarDirectory WAR_ROOT = new WarDirectory("/");
    public static final WarDirectory META_INF = new WarDirectory("/META-INF");
    public static final WarDirectory WEB_INF = new WarDirectory("/WEB-INF");
    public static final WarDirectory WEB_INF_LIB = new WarDirectory("/WEB-INF/lib");
    public static final WarDirectory WEB_INF_LIB_PROVIDED = new WarDirectory("/WEB-INF/lib-provided");
    public static final WarDirectory WEB_INF_CLASSES = new WarDirectory("/WEB-INF/classes");
    private static final WarDirectory[] WAR_DIRECTORIES = new WarDirectory[]{WAR_ROOT, META_INF, WEB_INF, WEB_INF_LIB, WEB_INF_LIB_PROVIDED, WEB_INF_CLASSES};
    @NotNull
    private final String myRelativePath;

    WarDirectory(@NotNull String relativePath) {
        if (relativePath == null) {
            WarDirectory.$$$reportNull$$$0(0);
        }
        this.myRelativePath = WarDirectory.getAdjustedPath(relativePath);
    }

    @NotNull
    public String getRelativePath() {
        String string = this.myRelativePath;
        if (string == null) {
            WarDirectory.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isCustomDirectory() {
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!this.myRelativePath.equals(warDirectory.getRelativePath())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static WarDirectory fromPath(@NotNull String path) {
        if (path == null) {
            WarDirectory.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)path)) {
            WarDirectory warDirectory = WAR_ROOT;
            if (warDirectory == null) {
                WarDirectory.$$$reportNull$$$0(3);
            }
            return warDirectory;
        }
        String adjustedPath = WarDirectory.getAdjustedPath(path);
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!warDirectory.myRelativePath.equals(adjustedPath)) continue;
            WarDirectory warDirectory2 = warDirectory;
            if (warDirectory2 == null) {
                WarDirectory.$$$reportNull$$$0(4);
            }
            return warDirectory2;
        }
        WarDirectory warDirectory = new WarDirectory(adjustedPath);
        if (warDirectory == null) {
            WarDirectory.$$$reportNull$$$0(5);
        }
        return warDirectory;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            WarDirectory.$$$reportNull$$$0(6);
        }
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public String toString() {
        return this.myRelativePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarDirectory directory = (WarDirectory)o;
        return this.myRelativePath.equals(directory.myRelativePath);
    }

    public int hashCode() {
        return this.myRelativePath.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/WarDirectory";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/WarDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

