/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageUtil {
    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(0);
        }
        BufferedImage bufferedImage = ImageUtil.toBufferedImage(image, false);
        if (bufferedImage == null) {
            ImageUtil.$$$reportNull$$$0(1);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize) {
        JBHiDPIScaledImage jbImage;
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(2);
        }
        if (image instanceof JBHiDPIScaledImage && (img = (jbImage = (JBHiDPIScaledImage)image).getDelegate()) != null) {
            if (inUserSize) {
                double scale = jbImage.getScale();
                img = ImageUtil.scaleImage(img, 1.0 / scale);
            }
            image = img;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (bufferedImage == null) {
                ImageUtil.$$$reportNull$$$0(3);
            }
            return bufferedImage;
        }
        final int width = image.getWidth(null);
        final int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            BufferedImage bufferedImage = new BufferedImage(Math.max(width, 1), Math.max(height, 1), 2){

                @Override
                public int getWidth() {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight() {
                    return Math.max(height, 0);
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return Math.max(height, 0);
                }
            };
            if (bufferedImage == null) {
                ImageUtil.$$$reportNull$$$0(4);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageUtil.$$$reportNull$$$0(5);
        }
        return bufferedImage2;
    }

    public static double getImageScale(Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getScale();
        }
        return 1.0;
    }

    public static int getRealWidth(@NotNull Image image) {
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(6);
        }
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getWidth(null);
    }

    public static int getRealHeight(@NotNull Image image) {
        Image img;
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(7);
        }
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getHeight(null);
    }

    public static int getUserWidth(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(8);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserWidth(null);
        }
        return image.getWidth(null);
    }

    public static int getUserHeight(@NotNull Image image) {
        if (image == null) {
            ImageUtil.$$$reportNull$$$0(9);
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserHeight(null);
        }
        return image.getHeight(null);
    }

    public static Image filter(Image image, ImageFilter filter) {
        if (image == null || filter == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter));
    }

    public static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(image, scale);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull JBUI.ScaleContext ctx) {
        if (ctx == null) {
            ImageUtil.$$$reportNull$$$0(10);
        }
        if (image == null) {
            return null;
        }
        if (UIUtil.isJreHiDPI(ctx)) {
            return RetinaImage.createFrom(image, ctx.getScale(JBUI.ScaleType.SYS_SCALE), null);
        }
        return image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ImageUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ImageUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toBufferedImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toBufferedImage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRealWidth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRealHeight";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserWidth";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserHeight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureHiDPI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

