/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartFMap<K, V>
implements Map<K, V> {
    private static final SmartFMap EMPTY = new SmartFMap(ArrayUtil.EMPTY_OBJECT_ARRAY);
    private static final int ARRAY_THRESHOLD = 8;
    private final Object myMap;

    private SmartFMap(Object map) {
        this.myMap = map;
    }

    public static <K, V> SmartFMap<K, V> emptyMap() {
        return EMPTY;
    }

    public SmartFMap<K, V> plus(@NotNull K key, V value) {
        if (key == null) {
            SmartFMap.$$$reportNull$$$0(0);
        }
        return new SmartFMap<K, V>(SmartFMap.doPlus(this.myMap, key, value));
    }

    private static Object doPlus(Object oldMap, Object key, Object value) {
        if (oldMap instanceof Map) {
            THashMap newMap = new THashMap((Map)oldMap);
            newMap.put(key, value);
            return newMap;
        }
        Object[] array = (Object[])oldMap;
        for (int i = 0; i < array.length; i += 2) {
            if (!key.equals(array[i])) continue;
            Object[] newArray = new Object[array.length];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[i + 1] = value;
            return newArray;
        }
        if (array.length == 16) {
            THashMap map = new THashMap();
            for (int i = 0; i < array.length; i += 2) {
                map.put(array[i], array[i + 1]);
            }
            map.put(key, value);
            return map;
        }
        Object[] newArray = new Object[array.length + 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = key;
        newArray[array.length + 1] = value;
        return newArray;
    }

    public SmartFMap<K, V> minus(@NotNull K key) {
        if (key == null) {
            SmartFMap.$$$reportNull$$$0(1);
        }
        if (this.myMap instanceof Map) {
            THashMap newMap = new THashMap((Map)this.myMap);
            newMap.remove(key);
            if (newMap.size() <= 8) {
                Object[] newArray = new Object[newMap.size() * 2];
                int i = 0;
                for (Object k : newMap.keySet()) {
                    newArray[i++] = k;
                    newArray[i++] = newMap.get(k);
                }
                return new SmartFMap<K, V>(newArray);
            }
            return new SmartFMap<K, V>(newMap);
        }
        Object[] array = (Object[])this.myMap;
        for (int i = 0; i < array.length; i += 2) {
            if (!key.equals(array[i])) continue;
            if (this.size() == 1) {
                return EMPTY;
            }
            Object[] newArray = new Object[array.length - 2];
            System.arraycopy(array, 0, newArray, 0, i);
            System.arraycopy(array, i + 2, newArray, i, array.length - i - 2);
            return new SmartFMap<K, V>(newArray);
        }
        return this;
    }

    public SmartFMap<K, V> plusAll(Map<? extends K, ? extends V> m) {
        SmartFMap<K, V> result = this;
        for (Map.Entry<K, V> e : m.entrySet()) {
            result = result.plus(e.getKey(), e.getValue());
        }
        return result;
    }

    public SmartFMap<K, V> minusAll(@NotNull Collection<? extends K> keys) {
        if (keys == null) {
            SmartFMap.$$$reportNull$$$0(2);
        }
        SmartFMap<K, V> result = this;
        for (K key : keys) {
            result = result.minus(key);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.myMap instanceof Map) {
            return this.myMap.equals(obj);
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (this.size() != map.size()) {
            return false;
        }
        Object[] array = (Object[])this.myMap;
        for (int i = 0; i < array.length; i += 2) {
            if (Comparing.equal(array[i + 1], map.get(array[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (this.myMap instanceof Map) {
            return ((Map)this.myMap).containsKey(key);
        }
        Object[] array = (Object[])this.myMap;
        for (int i = 0; i < array.length; i += 2) {
            if (!key.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    @Nullable
    public V get(Object key) {
        return (V)SmartFMap.doGet(this.myMap, key);
    }

    @Nullable
    private static Object doGet(Object map, Object key) {
        if (key == null) {
            return null;
        }
        if (map instanceof Map) {
            return ((Map)map).get(key);
        }
        Object[] array = (Object[])map;
        for (int i = 0; i < array.length; i += 2) {
            if (!key.equals(array[i])) continue;
            return array[i + 1];
        }
        return null;
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            SmartFMap.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                SmartFMap.$$$reportNull$$$0(4);
            }
            return set;
        }
        LinkedHashSet<K> result = new LinkedHashSet<K>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result.add(entry.getKey());
        }
        Set set = Collections.unmodifiableSet(result);
        if (set == null) {
            SmartFMap.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                SmartFMap.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<V> result = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result.add(entry.getValue());
        }
        Collection collection = Collections.unmodifiableCollection(result);
        if (collection == null) {
            SmartFMap.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.myMap instanceof Map) {
            return ((Map)this.myMap).size();
        }
        return ((Object[])this.myMap).length >> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            Set<Map.Entry<K, V>> set = Collections.emptySet();
            if (set == null) {
                SmartFMap.$$$reportNull$$$0(8);
            }
            return set;
        }
        LinkedHashSet set = new LinkedHashSet();
        if (this.myMap instanceof Map) {
            for (Map.Entry entry : ((Map)this.myMap).entrySet()) {
                set.add(new AbstractMap.SimpleImmutableEntry(entry));
            }
        } else {
            Object[] array = (Object[])this.myMap;
            for (int i = 0; i < array.length; i += 2) {
                set.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(array[i], array[i + 1]));
            }
        }
        Set<Map.Entry<K, V>> set2 = Collections.unmodifiableSet(set);
        if (set2 == null) {
            SmartFMap.$$$reportNull$$$0(9);
        }
        return set2;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SmartFMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SmartFMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "minusAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

