/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectNode
extends ExternalSystemNode<ProjectData> {
    private String myTooltipCache;
    private boolean singleModuleProject = false;

    public ProjectNode(ExternalProjectsView externalProjectsView, DataNode<ProjectData> projectDataNode) {
        super(externalProjectsView, null, projectDataNode);
        this.updateProject();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ProjectNode.$$$reportNull$$$0(0);
        }
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
    }

    public ExternalSystemNode getGroup() {
        return (ExternalSystemNode)this.getParent();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        this.setIdeGrouping(null);
        List<ExternalSystemNode> children = super.doBuildChildren();
        List visibleChildren = ContainerUtil.filter(children, node -> node.isVisible());
        if (visibleChildren.size() == 1 && ((ExternalSystemNode)visibleChildren.get(0)).getName().equals(this.getName())) {
            this.singleModuleProject = true;
            ExternalSystemNode node2 = (ExternalSystemNode)visibleChildren.get(0);
            if (node2 instanceof ModuleNode) {
                this.setIdeGrouping(((ModuleNode)node2).getIdeGrouping());
            }
            List<ExternalSystemNode> list = node2.doBuildChildren();
            if (list == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            return list;
        }
        this.singleModuleProject = false;
        List list = visibleChildren;
        if (list == null) {
            ProjectNode.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isSingleModuleProject() {
        return this.singleModuleProject;
    }

    void updateProject() {
        this.myTooltipCache = this.makeDescription();
        this.getStructure().updateFrom(this.getParent());
    }

    @Override
    protected void doUpdate() {
        AbstractExternalSystemSettings externalSystemSettings;
        ExternalProjectSettings projectSettings;
        String autoImportHint = null;
        ProjectData projectData = (ProjectData)this.getData();
        if (projectData != null && (projectSettings = (externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.getExternalProjectsView().getProject(), (ProjectSystemId)((ProjectData)this.getData()).getOwner())).getLinkedProjectSettings(projectData.getLinkedExternalProjectPath())) != null && projectSettings.isUseAutoImport()) {
            autoImportHint = "auto-import enabled";
        }
        this.setNameAndTooltip(this.getName(), this.myTooltipCache, autoImportHint);
    }

    private String makeDescription() {
        StringBuilder desc = new StringBuilder();
        ProjectData projectData = (ProjectData)this.getData();
        desc.append("Project: ").append(this.getName()).append(projectData != null ? "\n\rLocation: " + projectData.getLinkedExternalProjectPath() : "").append(projectData != null && !StringUtil.isEmptyOrSpaces((String)projectData.getDescription()) ? "\n\r" + projectData.getDescription() : "");
        return desc.toString();
    }

    @Nullable
    public String getIdeGrouping() {
        ProjectData data = (ProjectData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getIdeGrouping();
    }

    private void setIdeGrouping(@Nullable String ideGrouping) {
        ProjectData data = (ProjectData)this.getData();
        if (data != null) {
            data.setIdeGrouping(ideGrouping);
        }
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "ExternalSystemView.ProjectMenu";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ProjectNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ProjectNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

