/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.PathToken;
import com.jayway.jsonpath.internal.PathTokenizer;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class JsonPath {
    private static Pattern DEFINITE_PATH_PATTERN = Pattern.compile(".*(\\.\\.|\\*|\\[[\\\\/]|\\?|,|:\\s?\\]|\\[\\s?:|>|\\(|<|=|\\+).*");
    private PathTokenizer tokenizer;
    private LinkedList<Filter> filters;

    public JsonPath(String jsonPath, Filter[] filters) {
        if (jsonPath == null || jsonPath.trim().isEmpty() || jsonPath.matches("[^\\?\\+\\=\\-\\*\\/\\!]\\(")) {
            throw new InvalidPathException("Invalid path");
        }
        this.tokenizer = new PathTokenizer(jsonPath);
        this.filters = new LinkedList();
        this.filters.addAll(Arrays.asList(filters));
    }

    PathTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public String getPath() {
        return this.tokenizer.getPath();
    }

    public boolean isPathDefinite() {
        String preparedPath = this.getPath().replaceAll("\"[^\"\\\\\\n\r]*\"", "");
        return !DEFINITE_PATH_PATTERN.matcher(preparedPath).matches();
    }

    public <T> T read(Object jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"json can not be null");
        if (!(jsonObject instanceof Map) && !(jsonObject instanceof List)) {
            throw new IllegalArgumentException("Invalid container object");
        }
        LinkedList<Filter> contextFilters = new LinkedList<Filter>(this.filters);
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        Object result = jsonObject;
        boolean inArrayContext = false;
        for (PathToken pathToken : this.tokenizer) {
            PathTokenFilter filter = pathToken.getFilter();
            result = filter.filter(result, jsonProvider, contextFilters, inArrayContext);
            if (inArrayContext) continue;
            inArrayContext = filter.isArrayFilter();
        }
        return (T)result;
    }

    public <T> T read(String json) {
        Validate.notEmpty((String)json, (String)"json can not be null or empty");
        return this.read(JsonProviderFactory.createProvider().parse(json));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(URL jsonURL) throws IOException {
        T t;
        Validate.notNull((Object)jsonURL, (String)"json URL can not be null");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(jsonURL.openStream()));
            t = this.read(JsonProviderFactory.createProvider().parse(in));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(File jsonFile) throws IOException {
        T t;
        Validate.notNull((Object)jsonFile, (String)"json file can not be null");
        Validate.isTrue((boolean)jsonFile.exists(), (String)"json file does not exist");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jsonFile);
            t = this.read(JsonProviderFactory.createProvider().parse(fis));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T read(InputStream jsonInputStream) throws IOException {
        Validate.notNull((Object)jsonInputStream, (String)"json input stream can not be null");
        try {
            T t = this.read(JsonProviderFactory.createProvider().parse(jsonInputStream));
            return t;
        }
        finally {
            IOUtils.closeQuietly((InputStream)jsonInputStream);
        }
    }

    public static JsonPath compile(String jsonPath, Filter ... filters) {
        Validate.notEmpty((String)jsonPath, (String)"json can not be null or empty");
        return new JsonPath(jsonPath, filters);
    }

    public static <T> T read(String json, String jsonPath, Filter ... filters) {
        Validate.notEmpty((String)json, (String)"json can not be null or empty");
        Validate.notEmpty((String)jsonPath, (String)"jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(json);
    }

    public static <T> T read(Object json, String jsonPath, Filter ... filters) {
        Validate.notNull((Object)json, (String)"json can not be null");
        Validate.notNull((Object)jsonPath, (String)"jsonPath can not be null");
        return JsonPath.compile(jsonPath, filters).read(json);
    }

    public static <T> T read(URL jsonURL, String jsonPath, Filter ... filters) throws IOException {
        Validate.notNull((Object)jsonURL, (String)"json URL can not be null");
        Validate.notEmpty((String)jsonPath, (String)"jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(jsonURL);
    }

    public static <T> T read(File jsonFile, String jsonPath, Filter ... filters) throws IOException {
        Validate.notNull((Object)jsonFile, (String)"json file can not be null");
        Validate.notEmpty((String)jsonPath, (String)"jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(jsonFile);
    }

    public static <T> T read(InputStream jsonInputStream, String jsonPath, Filter ... filters) throws IOException {
        Validate.notNull((Object)jsonInputStream, (String)"json input stream can not be null");
        Validate.notEmpty((String)jsonPath, (String)"jsonPath can not be null or empty");
        return JsonPath.compile(jsonPath, filters).read(jsonInputStream);
    }
}

