/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnFileSystemListener;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.rollback.CopiedAsideInfo;
import org.jetbrains.idea.svn.rollback.ThroughRenameInfo;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;

public class Reverter {
    @NotNull
    private final SvnVcs myVcs;
    private final ProgressTracker myHandler;
    private final List<VcsException> myExceptions;
    private final List<CopiedAsideInfo> myFromToModified;
    private final Map<File, PropertiesMap> myProperties;

    Reverter(@NotNull SvnVcs vcs, @NotNull RollbackProgressListener listener2, @NotNull List<VcsException> exceptions) {
        if (vcs == null) {
            Reverter.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            Reverter.$$$reportNull$$$0(1);
        }
        if (exceptions == null) {
            Reverter.$$$reportNull$$$0(2);
        }
        this.myVcs = vcs;
        this.myHandler = Reverter.createRevertHandler(exceptions, listener2);
        this.myExceptions = exceptions;
        this.myFromToModified = ContainerUtil.newArrayList();
        this.myProperties = ContainerUtil.newHashMap();
    }

    public void revert(@NotNull Collection<File> files, boolean recursive) {
        if (files == null) {
            Reverter.$$$reportNull$$$0(3);
        }
        if (files.isEmpty()) {
            return;
        }
        File target = files.iterator().next();
        try {
            this.myVcs.getFactory(target).createRevertClient().revert(files, Depth.allOrEmpty(recursive), this.myHandler);
        }
        catch (SvnBindException e) {
            if (!e.contains(ErrorCode.WC_NOT_WORKING_COPY)) {
                this.myExceptions.add(e);
            }
        }
        catch (VcsException e) {
            this.myExceptions.add(e);
        }
    }

    public void moveRenamesToTmp(@NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        if (collector == null) {
            Reverter.$$$reportNull$$$0(4);
        }
        try {
            File tmp = FileUtil.createTempDirectory((String)"forRename", (String)"");
            PropertyConsumer handler = Reverter.createPropertyHandler(this.myProperties, collector);
            for (Map.Entry<File, ThroughRenameInfo> entry : collector.getFromTo().entrySet()) {
                File source = entry.getKey();
                ThroughRenameInfo info2 = entry.getValue();
                if (info2.isVersioned()) {
                    this.myVcs.getFactory(source).createPropertyClient().list(Target.on(source), Revision.WORKING, Depth.EMPTY, handler);
                }
                if (source.isDirectory()) {
                    if (FileUtil.filesEqual((File)info2.getTo(), (File)info2.getFirstTo())) continue;
                    this.myFromToModified.add(new CopiedAsideInfo(info2.getParentImmediateReverted(), info2.getTo(), info2.getFirstTo(), null));
                    continue;
                }
                File tmpFile = FileUtil.createTempFile((File)tmp, (String)source.getName(), (String)"", (boolean)false);
                tmpFile.mkdirs();
                FileUtil.delete((File)tmpFile);
                FileUtil.copy((File)source, (File)tmpFile);
                this.myFromToModified.add(new CopiedAsideInfo(info2.getParentImmediateReverted(), info2.getTo(), info2.getFirstTo(), tmpFile));
            }
        }
        catch (IOException e) {
            this.myExceptions.add(new VcsException((Throwable)e));
        }
        catch (VcsException e) {
            this.myExceptions.add(e);
        }
    }

    public void moveGroup() {
        Collections.sort(this.myFromToModified, (o1, o2) -> FileUtil.compareFiles((File)o1.getTo(), (File)o2.getTo()));
        for (CopiedAsideInfo info2 : this.myFromToModified) {
            if (!info2.getParentImmediateReverted().exists()) continue;
            try {
                File root;
                File from = info2.getFrom();
                File target = info2.getTo();
                if (from != null && !FileUtil.filesEqual((File)from, (File)target) && !target.exists()) {
                    SvnFileSystemListener.moveFileWithSvn(this.myVcs, from, target);
                }
                if ((root = info2.getTmpPlace()) == null) continue;
                if (!root.isDirectory()) {
                    if (target.exists()) {
                        FileUtil.copy((File)root, (File)target);
                        continue;
                    }
                    FileUtil.rename((File)root, (File)target);
                    continue;
                }
                FileUtil.processFilesRecursively((File)root, file -> {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)file.getPath(), (char)File.separatorChar);
                    File newFile = new File(target, relativePath);
                    newFile.getParentFile().mkdirs();
                    try {
                        if (target.exists()) {
                            FileUtil.copy((File)file, (File)newFile);
                        } else {
                            FileUtil.rename((File)file, (File)newFile);
                        }
                    }
                    catch (IOException e) {
                        this.myExceptions.add(new VcsException((Throwable)e));
                    }
                    return true;
                });
            }
            catch (IOException e) {
                this.myExceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
            }
        }
        this.applyProperties();
    }

    private void applyProperties() {
        for (Map.Entry<File, PropertiesMap> entry : this.myProperties.entrySet()) {
            File file = entry.getKey();
            try {
                this.myVcs.getFactory(file).createPropertyClient().setProperties(file, entry.getValue());
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
            }
        }
    }

    @NotNull
    private static ProgressTracker createRevertHandler(final @NotNull List<VcsException> exceptions, final @NotNull RollbackProgressListener listener2) {
        if (exceptions == null) {
            Reverter.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            Reverter.$$$reportNull$$$0(6);
        }
        ProgressTracker progressTracker = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                File file;
                if (event.getAction() == EventAction.REVERT && (file = event.getFile()) != null) {
                    listener2.accept(file);
                }
                if (event.getAction() == EventAction.FAILED_REVERT) {
                    exceptions.add(new VcsException("Revert failed"));
                }
            }

            @Override
            public void checkCancelled() throws ProcessCanceledException {
                listener2.checkCanceled();
            }
        };
        if (progressTracker == null) {
            Reverter.$$$reportNull$$$0(7);
        }
        return progressTracker;
    }

    @NotNull
    private static PropertyConsumer createPropertyHandler(final @NotNull Map<File, PropertiesMap> properties, final @NotNull UnversionedAndNotTouchedFilesGroupCollector collector) {
        if (properties == null) {
            Reverter.$$$reportNull$$$0(8);
        }
        if (collector == null) {
            Reverter.$$$reportNull$$$0(9);
        }
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                ThroughRenameInfo info2 = collector.findToFile(VcsUtil.getFilePath((File)path), null);
                if (info2 != null) {
                    if (!properties.containsKey(info2.getTo())) {
                        properties.put(info2.getTo(), new PropertiesMap());
                    }
                    ((PropertiesMap)properties.get(info2.getTo())).put(property.getName(), property.getValue());
                }
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
            }
        };
        if (propertyConsumer == null) {
            Reverter.$$$reportNull$$$0(10);
        }
        return propertyConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/rollback/Reverter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/rollback/Reverter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevertHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertyHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveRenamesToTmp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRevertHandler";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

