/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.VcsLocaleHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandOutputLogger;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.ResultBuilderNotifier;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class CommandExecutor {
    static final Logger LOG = Logger.getInstance((String)CommandExecutor.class.getName());
    private final AtomicReference<Integer> myExitCodeReference;
    @Nullable
    private String myMessage;
    private boolean myIsDestroyed;
    private boolean myNeedsDestroy;
    private volatile String myDestroyReason;
    private volatile boolean myWasCancelled;
    @NotNull
    private final List<File> myTempFiles;
    @NotNull
    protected final GeneralCommandLine myCommandLine;
    protected Process myProcess;
    protected SvnProcessHandler myHandler;
    private OutputStreamWriter myProcessWriter;
    private CapturingProcessAdapter outputAdapter;
    private final Object myLock;
    private final EventDispatcher<LineCommandListener> myListeners;
    private final AtomicBoolean myWasError;
    @Nullable
    private final LineCommandListener myResultBuilder;
    @NotNull
    private final Command myCommand;

    public CommandExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        if (exePath == null) {
            CommandExecutor.$$$reportNull$$$0(0);
        }
        if (command == null) {
            CommandExecutor.$$$reportNull$$$0(1);
        }
        this.myListeners = EventDispatcher.create(LineCommandListener.class);
        this.myWasError = new AtomicBoolean(false);
        this.myCommand = command;
        this.myResultBuilder = command.getResultBuilder();
        if (this.myResultBuilder != null) {
            this.myListeners.addListener((EventListener)((Object)this.myResultBuilder));
            this.myListeners.addListener((EventListener)((Object)new CommandCancelTracker()));
        }
        this.myLock = new Object();
        this.myTempFiles = ContainerUtil.newArrayList();
        this.myCommandLine = this.createCommandLine();
        this.myCommandLine.setExePath(exePath);
        this.myCommandLine.setWorkDirectory(command.getWorkingDirectory());
        if (command.getConfigDir() != null) {
            this.myCommandLine.addParameters(new String[]{"--config-dir", command.getConfigDir().getPath()});
        }
        this.myCommandLine.addParameter(command.getName().getName());
        this.myCommandLine.addParameters(this.prepareParameters(command));
        this.myExitCodeReference = new AtomicReference();
    }

    @NotNull
    private List<String> prepareParameters(@NotNull Command command) {
        if (command == null) {
            CommandExecutor.$$$reportNull$$$0(2);
        }
        List<String> parameters = command.getParameters();
        this.detectAndRemoveMessage(parameters);
        List<String> list = parameters;
        if (list == null) {
            CommandExecutor.$$$reportNull$$$0(3);
        }
        return list;
    }

    private void detectAndRemoveMessage(@NotNull List<String> parameters) {
        int index;
        if (parameters == null) {
            CommandExecutor.$$$reportNull$$$0(4);
        }
        int n = index = (index = parameters.indexOf("-m")) < 0 ? parameters.indexOf("--message") : index;
        if (index >= 0 && index + 1 < parameters.size()) {
            this.myMessage = parameters.get(index + 1);
            parameters.remove(index + 1);
            parameters.remove(index);
        }
    }

    public boolean isManuallyDestroyed() {
        return this.myIsDestroyed;
    }

    public String getDestroyReason() {
        return this.myDestroyReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SvnBindException {
        Object object = this.myLock;
        synchronized (object) {
            this.checkNotStarted();
            try {
                this.beforeCreateProcess();
                this.myProcess = this.createProcess();
                this.myHandler = this.createProcessHandler();
                this.myProcessWriter = new OutputStreamWriter(this.myHandler.getProcessInput());
                this.startHandlingStreams();
            }
            catch (ExecutionException e) {
                this.listeners().startFailed(e);
                throw new SvnBindException(e);
            }
        }
    }

    protected void cleanup() {
        this.deleteTempFiles();
    }

    protected void beforeCreateProcess() throws SvnBindException {
        this.setupLocale();
        this.ensureMessageFile();
        this.ensureTargetsAdded();
        this.ensurePropertyValueAdded();
    }

    private void setupLocale() {
        this.myCommandLine.withEnvironment(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"svn"));
    }

    @NotNull
    private File ensureCommandFile(@NotNull String prefix, @NotNull String extension, @NotNull String data, @NotNull String parameterName) throws SvnBindException {
        if (prefix == null) {
            CommandExecutor.$$$reportNull$$$0(5);
        }
        if (extension == null) {
            CommandExecutor.$$$reportNull$$$0(6);
        }
        if (data == null) {
            CommandExecutor.$$$reportNull$$$0(7);
        }
        if (parameterName == null) {
            CommandExecutor.$$$reportNull$$$0(8);
        }
        File result = CommandExecutor.createTempFile(prefix, extension);
        this.myTempFiles.add(result);
        try {
            FileUtil.writeToFile((File)result, (String)data);
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
        this.myCommandLine.addParameters(new String[]{parameterName, result.getAbsolutePath()});
        File file = result;
        if (file == null) {
            CommandExecutor.$$$reportNull$$$0(9);
        }
        return file;
    }

    private void ensureMessageFile() throws SvnBindException {
        if (this.myMessage != null) {
            this.ensureCommandFile("commit-message", ".txt", this.myMessage, "-F");
            this.myCommandLine.addParameters(new String[]{"--config-option", "config:miscellany:log-encoding=UTF-8"});
        }
    }

    private void ensureTargetsAdded() throws SvnBindException {
        List<String> targetsPaths = this.myCommand.getTargetsPaths();
        if (!ContainerUtil.isEmpty(targetsPaths)) {
            String targetsValue = StringUtil.join(targetsPaths, (String)SystemProperties.getLineSeparator());
            if (this.myCommandLine.getCommandLineString().length() + targetsValue.length() > 7600) {
                this.ensureCommandFile("command-targets", ".txt", targetsValue, "--targets");
            } else {
                this.myCommandLine.addParameters(targetsPaths);
            }
        }
    }

    private void ensurePropertyValueAdded() throws SvnBindException {
        PropertyValue propertyValue = this.myCommand.getPropertyValue();
        if (propertyValue != null) {
            this.ensureCommandFile("property-value", ".txt", PropertyValue.toString(propertyValue), "-F");
        }
    }

    private void deleteTempFiles() {
        for (File file : this.myTempFiles) {
            CommandExecutor.deleteTempFile(file);
        }
    }

    @NotNull
    protected static File getSvnFolder() {
        File vcsFolder = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcsFolder, "svn");
        if (file == null) {
            CommandExecutor.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    protected static File createTempFile(@NotNull String prefix, @NotNull String extension) throws SvnBindException {
        File file;
        if (prefix == null) {
            CommandExecutor.$$$reportNull$$$0(11);
        }
        if (extension == null) {
            CommandExecutor.$$$reportNull$$$0(12);
        }
        try {
            file = FileUtil.createTempFile((File)CommandExecutor.getSvnFolder(), (String)prefix, (String)extension);
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
        if (file == null) {
            CommandExecutor.$$$reportNull$$$0(13);
        }
        return file;
    }

    protected static void deleteTempFile(@Nullable File file) {
        boolean wasDeleted;
        if (file != null && !(wasDeleted = FileUtil.delete((File)file))) {
            LOG.info("Failed to delete temp file " + file.getAbsolutePath());
        }
    }

    @NotNull
    protected SvnProcessHandler createProcessHandler() {
        SvnProcessHandler svnProcessHandler = new SvnProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString(), this.needsUtf8Output(), this.needsBinaryOutput());
        if (svnProcessHandler == null) {
            CommandExecutor.$$$reportNull$$$0(14);
        }
        return svnProcessHandler;
    }

    protected boolean needsBinaryOutput() {
        return this.myCommand.is(SvnCommandName.cat) || this.myCommand.is(SvnCommandName.diff) && !this.myCommand.getParameters().contains("--xml");
    }

    protected boolean needsUtf8Output() {
        return this.myCommand.getParameters().contains("--xml");
    }

    @NotNull
    protected GeneralCommandLine createCommandLine() {
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        if (generalCommandLine == null) {
            CommandExecutor.$$$reportNull$$$0(15);
        }
        return generalCommandLine;
    }

    @NotNull
    protected Process createProcess() throws ExecutionException {
        Process process2 = this.myCommandLine.createProcess();
        if (process2 == null) {
            CommandExecutor.$$$reportNull$$$0(16);
        }
        return process2;
    }

    protected void startHandlingStreams() {
        this.outputAdapter = new CapturingProcessAdapter();
        this.myHandler.addProcessListener((ProcessListener)this.outputAdapter);
        this.myHandler.addProcessListener((ProcessListener)new ProcessTracker());
        this.myHandler.addProcessListener((ProcessListener)new ResultBuilderNotifier(this.listeners()));
        this.myHandler.addProcessListener((ProcessListener)new CommandOutputLogger());
        this.myHandler.startNotify();
    }

    public String getOutput() {
        return this.outputAdapter.getOutput().getStdout();
    }

    public String getErrorOutput() {
        return this.outputAdapter.getOutput().getStderr();
    }

    public ProcessOutput getProcessOutput() {
        return this.outputAdapter.getOutput();
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        ByteArrayOutputStream byteArrayOutputStream = this.myHandler.getBinaryOutput();
        if (byteArrayOutputStream == null) {
            CommandExecutor.$$$reportNull$$$0(17);
        }
        return byteArrayOutputStream;
    }

    @NotNull
    public Command getCommand() {
        Command command = this.myCommand;
        if (command == null) {
            CommandExecutor.$$$reportNull$$$0(18);
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(int timeout) {
        SvnProcessHandler handler;
        this.checkStarted();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return true;
            }
            handler = this.myHandler;
        }
        if (timeout == -1) {
            return handler.waitFor();
        }
        return handler.waitFor(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.myLock;
        synchronized (object) {
            this.checkStarted();
            this.destroyProcess();
        }
    }

    public void run() throws SvnBindException {
        try {
            boolean finished;
            this.start();
            do {
                if ((finished = this.waitFor(500)) || !this.wasError().booleanValue() && !this.needsDestroy() && !this.checkCancelled()) continue;
                this.waitFor(1000);
                this.doDestroyProcess();
                break;
            } while (!finished);
        }
        finally {
            this.cleanup();
        }
    }

    public void run(int timeout) throws SvnBindException {
        try {
            this.start();
            boolean finished = this.waitFor(timeout);
            if (!finished) {
                this.outputAdapter.getOutput().setTimeout();
                this.doDestroyProcess();
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LineCommandListener listener2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.addListener((EventListener)((Object)listener2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LineCommandListener listeners() {
        Object object = this.myLock;
        synchronized (object) {
            return (LineCommandListener)((Object)this.myListeners.getMulticaster());
        }
    }

    public boolean checkCancelled() {
        if (!this.myWasCancelled && this.myCommand.getCanceller() != null) {
            try {
                this.myCommand.getCanceller().checkCancelled();
            }
            catch (ProcessCanceledException e) {
                this.myWasCancelled = true;
            }
        }
        return this.myWasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess() {
        Object object = this.myLock;
        synchronized (object) {
            this.myNeedsDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess(@Nullable String destroyReason) {
        Object object = this.myLock;
        synchronized (object) {
            this.myDestroyReason = destroyReason;
            this.myNeedsDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroyProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myIsDestroyed) {
                LOG.info("Destroying process by command: " + this.getCommandText());
                this.myIsDestroyed = true;
                this.myHandler.destroyProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsDestroy() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myNeedsDestroy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommandText() {
        Object object = this.myLock;
        synchronized (object) {
            return StringUtil.join((String[])new String[]{this.myCommandLine.getExePath(), " ", this.myCommand.getText()});
        }
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
    }

    protected void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The process is not started yet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myProcess != null;
        }
    }

    public SvnCommandName getCommandName() {
        return this.myCommand.getName();
    }

    public Integer getExitCodeReference() {
        return this.myExitCodeReference.get();
    }

    public void setExitCodeReference(int value) {
        this.myExitCodeReference.set(value);
    }

    public Boolean wasError() {
        return this.myWasError.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String value) throws SvnBindException {
        try {
            Object object = this.myLock;
            synchronized (object) {
                this.myProcessWriter.write(value);
                this.myProcessWriter.flush();
            }
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
    }

    public void logCommand() {
        LOG.info("Command text " + this.getCommandText());
        LOG.info("Command output " + this.getOutput());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/CommandExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CommandExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureCommandFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnFolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryOutput";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareParameters";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectAndRemoveMessage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureCommandFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProcessTracker
    extends ProcessAdapter {
        private ProcessTracker() {
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                ProcessTracker.$$$reportNull$$$0(0);
            }
            CommandExecutor.this.setExitCodeReference(event.getExitCode());
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                ProcessTracker.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                ProcessTracker.$$$reportNull$$$0(2);
            }
            if (ProcessOutputTypes.STDERR == outputType) {
                CommandExecutor.this.myWasError.set(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CommandExecutor$ProcessTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CommandCancelTracker
    extends LineCommandAdapter {
        private CommandCancelTracker() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (CommandExecutor.this.myResultBuilder != null && CommandExecutor.this.myResultBuilder.isCanceled()) {
                LOG.info("Cancelling command: " + CommandExecutor.this.getCommandText());
                CommandExecutor.this.destroyProcess();
            }
        }
    }
}

