/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

public class CommonSupertypes {
    @Nullable
    public static KotlinType commonSupertypeForNonDenotableTypes(@NotNull Collection<KotlinType> types) {
        KotlinType type2;
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1 && (type2 = types.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @NotNull
    public static KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
        if (types.size() == 1) {
            return types.iterator().next();
        }
        return CommonSupertypes.findCommonSupertype(types, 0, CommonSupertypes.maxDepth(types) + 3);
    }

    private static int maxDepth(@NotNull Collection<KotlinType> types) {
        int max = 0;
        for (KotlinType type2 : types) {
            int depth = CommonSupertypes.depth(type2);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(@NotNull KotlinType type2) {
        return 1 + CommonSupertypes.maxDepth(CollectionsKt.map(type2.getArguments(), projection -> {
            if (projection.isStarProjection()) {
                return type2.getConstructor().getBuiltIns().getAnyType();
            }
            return projection.getType();
        }));
    }

    @NotNull
    private static KotlinType findCommonSupertype(@NotNull Collection<KotlinType> types, int recursionDepth, int maxDepth) {
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types;
        boolean hasFlexible = false;
        ArrayList<SimpleType> upper = new ArrayList<SimpleType>(types.size());
        ArrayList<SimpleType> lower2 = new ArrayList<SimpleType>(types.size());
        for (KotlinType type2 : types) {
            UnwrappedType unwrappedType2 = type2.unwrap();
            if (unwrappedType2 instanceof FlexibleType) {
                if (DynamicTypesKt.isDynamic(unwrappedType2)) {
                    return unwrappedType2;
                }
                hasFlexible = true;
                FlexibleType flexibleType = (FlexibleType)unwrappedType2;
                upper.add(flexibleType.getUpperBound());
                lower2.add(flexibleType.getLowerBound());
                continue;
            }
            SimpleType simpleType2 = (SimpleType)unwrappedType2;
            upper.add(simpleType2);
            lower2.add(simpleType2);
        }
        if (!hasFlexible) {
            return CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth);
        }
        return KotlinTypeFactory.flexibleType(CommonSupertypes.commonSuperTypeForInflexible(lower2, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth));
    }

    @NotNull
    private static SimpleType commonSuperTypeForInflexible(@NotNull Collection<SimpleType> types, int recursionDepth, int maxDepth) {
        assert (!types.isEmpty());
        LinkedHashSet<SimpleType> typeSet = new LinkedHashSet<SimpleType>(types);
        boolean nullable = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = (KotlinType)iterator2.next();
            assert (type2 != null);
            assert (!FlexibleTypesKt.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (KotlinTypeKt.isError(type2)) {
                return ErrorUtils.createErrorType("Supertype of error type " + type2);
            }
            nullable |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            KotlinBuiltIns builtIns = types.iterator().next().getConstructor().getBuiltIns();
            return nullable ? builtIns.getNullableNothingType() : builtIns.getNothingType();
        }
        if (typeSet.size() == 1) {
            return TypeUtils.makeNullableIfNeeded((SimpleType)typeSet.iterator().next(), nullable);
        }
        Map<TypeConstructor, Set<SimpleType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            LinkedHashSet<SimpleType> merge = new LinkedHashSet<SimpleType>();
            for (Set set2 : commonSupertypes.values()) {
                merge.addAll(set2);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        if (commonSupertypes.isEmpty()) {
            StringBuilder info = new StringBuilder();
            for (SimpleType simpleType2 : types) {
                String superTypes2 = TypeUtils.getAllSupertypes(simpleType2).stream().map(t -> "-- " + CommonSupertypes.renderTypeFully(t)).collect(Collectors.joining("\n"));
                info.append("Info about ").append(CommonSupertypes.renderTypeFully(simpleType2)).append(": ").append('\n').append("- Supertypes: ").append('\n').append(superTypes2).append('\n').append("- DeclarationDescriptor class: ").append(CommonSupertypes.classOfDeclarationDescriptor(simpleType2)).append('\n').append('\n');
            }
            throw new IllegalStateException("[Report version 3] There is no common supertype for: " + types + " \n" + info.toString());
        }
        Map.Entry<TypeConstructor, Set<SimpleType>> entry = commonSupertypes.entrySet().iterator().next();
        SimpleType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        return TypeUtils.makeNullableIfNeeded(result2, nullable);
    }

    @NotNull
    private static String renderTypeFully(@NotNull KotlinType type2) {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2) + ", typeConstructor debug: " + CommonSupertypes.renderTypeConstructorVerboseDebugInformation(type2.getConstructor());
    }

    private static String renderTypeConstructorVerboseDebugInformation(TypeConstructor typeConstructor2) {
        if (!(typeConstructor2 instanceof AbstractTypeConstructor)) {
            return typeConstructor2.toString() + "[" + typeConstructor2.getClass().getName() + "]";
        }
        AbstractTypeConstructor abstractTypeConstructor = (AbstractTypeConstructor)typeConstructor2;
        ClassifierDescriptor declarationDescriptor = abstractTypeConstructor.getDeclarationDescriptor();
        String moduleDescriptorString = declarationDescriptor == null ? "<no module for null descriptor>" : Objects.toString(DescriptorUtils.getContainingModule(declarationDescriptor));
        return "descriptor=" + declarationDescriptor + "@" + Integer.toHexString(Objects.hashCode(declarationDescriptor)) + ", moduleDescriptor=" + moduleDescriptorString + ", " + abstractTypeConstructor.renderAdditionalDebugInformation();
    }

    @Nullable
    private static Class<?> classOfDeclarationDescriptor(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null) {
            return descriptor2.getClass();
        }
        return null;
    }

    @NotNull
    private static Map<TypeConstructor, Set<SimpleType>> computeCommonRawSupertypes(@NotNull Collection<SimpleType> types) {
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<SimpleType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<SimpleType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (SimpleType type2 : types) {
            HashSet<TypeConstructor> visited2 = new HashSet<TypeConstructor>();
            order = CommonSupertypes.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited2);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited2;
                continue;
            }
            commonSuperclasses.retainAll(visited2);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        LinkedHashMap<TypeConstructor, Set<SimpleType>> result2 = new LinkedHashMap<TypeConstructor, Set<SimpleType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<SimpleType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static SimpleType computeSupertypeProjections(@NotNull TypeConstructor constructor2, @NotNull Set<SimpleType> types, int recursionDepth, int maxDepth) {
        void var8_17;
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return types.iterator().next();
        }
        List<TypeParameterDescriptor> parameters2 = constructor2.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>(parameters2.size());
        for (TypeParameterDescriptor typeParameterDescriptor : parameters2) {
            LinkedHashSet<TypeProjection> linkedHashSet = new LinkedHashSet<TypeProjection>();
            for (KotlinType kotlinType2 : types) {
                linkedHashSet.add(kotlinType2.getArguments().get(typeParameterDescriptor.getIndex()));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(typeParameterDescriptor, linkedHashSet, recursionDepth, maxDepth));
        }
        boolean nullable = false;
        for (KotlinType kotlinType3 : types) {
            nullable |= kotlinType3.isMarkedNullable();
        }
        ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof ClassDescriptor) {
            MemberScope memberScope2 = ((ClassDescriptor)classifierDescriptor).getMemberScope(newProjections);
        } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
            MemberScope memberScope3 = classifierDescriptor.getDefaultType().getMemberScope();
        } else {
            MemberScope memberScope4 = ErrorUtils.createErrorScope("A scope for common supertype which is not a normal classifier", true);
        }
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(Annotations.Companion.getEMPTY(), constructor2, newProjections, nullable, (MemberScope)var8_17);
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        TypeProjection singleBestProjection = FlexibleTypesKt.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            return singleBestProjection;
        }
        if (recursionDepth >= maxDepth) {
            return TypeUtils.makeStarProjection(parameterDescriptor);
        }
        LinkedHashSet<KotlinType> ins = new LinkedHashSet<KotlinType>();
        LinkedHashSet<KotlinType> outs = new LinkedHashSet<KotlinType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind = projection.getProjectionKind();
            if (projectionKind.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            assert (!outs.isEmpty()) : "Out projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            Variance projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            KotlinType superType = CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth);
            for (KotlinType upperBound : parameterDescriptor.getUpperBounds()) {
                if (TypeUtilsKt.isSubtypeOf(superType, upperBound)) continue;
                return new StarProjectionImpl(parameterDescriptor);
            }
            return new TypeProjectionImpl(projectionKind, superType);
        }
        if (ins != null) {
            assert (!ins.isEmpty()) : "In projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            KotlinType intersection = TypeIntersector.intersectTypes(ins);
            if (intersection == null) {
                return TypeUtils.makeStarProjection(parameterDescriptor);
            }
            Variance projectionKind = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            return new TypeProjectionImpl(projectionKind, intersection);
        }
        return TypeUtils.makeStarProjection(parameterDescriptor);
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        markerSet.add(typeConstructor2);
        for (KotlinType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }

    @NotNull
    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull SimpleType type2, final @NotNull Map<TypeConstructor, Set<SimpleType>> constructorToAllInstances, @NotNull Set<TypeConstructor> visited2) {
        return DFS.dfs(Collections.singletonList(type2), current -> {
            TypeSubstitutor substitutor3 = TypeSubstitutor.create(current);
            Collection<KotlinType> supertypes2 = current.getConstructor().getSupertypes();
            ArrayList<SimpleType> result2 = new ArrayList<SimpleType>(supertypes2.size());
            for (KotlinType supertype2 : supertypes2) {
                if (visited2.contains(supertype2.getConstructor())) continue;
                result2.add(FlexibleTypesKt.lowerIfFlexible(substitutor3.safeSubstitute(supertype2, Variance.INVARIANT)));
            }
            return result2;
        }, current -> visited2.add(current.getConstructor()), new DFS.NodeHandlerWithListResult<SimpleType, TypeConstructor>(){

            @Override
            public boolean beforeChildren(SimpleType current) {
                Set instances = constructorToAllInstances.computeIfAbsent(current.getConstructor(), k -> new LinkedHashSet());
                instances.add(current);
                return true;
            }

            @Override
            public void afterChildren(SimpleType current) {
                ((LinkedList)this.result).addFirst(current.getConstructor());
            }
        });
    }
}

