/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public class ExtensionReceiver
extends AbstractReceiverValue
implements ImplicitReceiver {
    private final CallableDescriptor descriptor;

    public ExtensionReceiver(@NotNull CallableDescriptor callableDescriptor, @NotNull KotlinType receiverType2, @Nullable ReceiverValue original) {
        super(receiverType2, original);
        this.descriptor = callableDescriptor;
    }

    @Override
    @NotNull
    public CallableDescriptor getDeclarationDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public ReceiverValue replaceType(@NotNull KotlinType newType) {
        return new ExtensionReceiver(this.descriptor, newType, this.getOriginal());
    }

    public String toString() {
        return this.getType() + ": Ext {" + this.descriptor + "}";
    }
}

