/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.SimpleArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.FunctionExpression;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.NotCallableExpectedType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a,\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002\u001a0\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00172\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0015\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"extraLambdaInfo", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaKotlinCallArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "extractLambdaInfoFromFunctionalType", "extractLambdaParameters", "", "preprocessCallableReference", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "preprocessCollectionLiteralArgument", "collectionLiteralArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/CollectionLiteralKotlinCallArgument;", "preprocessLambdaArgument", "forceResolution", "", "resolveKtPrimitive", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "isReceiver", "transformToResolvedLambda", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaWithTypeVariableAsExpectedTypeAtom;", "resolution"})
public final class PostponeArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom resolveKtPrimitive(@NotNull ConstraintSystemBuilder csBuilder, @NotNull KotlinCallArgument argument2, @Nullable UnwrappedType expectedType, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        KotlinCallArgument kotlinCallArgument = argument2;
        if (kotlinCallArgument instanceof SimpleKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSimpleArgument(csBuilder, (SimpleKotlinCallArgument)argument2, expectedType, diagnosticsHolder, isReceiver);
        } else if (kotlinCallArgument instanceof LambdaKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessLambdaArgument$default(csBuilder, (LambdaKotlinCallArgument)argument2, expectedType, false, 8, null);
        } else if (kotlinCallArgument instanceof CallableReferenceKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessCallableReference(csBuilder, (CallableReferenceKotlinCallArgument)argument2, expectedType, diagnosticsHolder);
        } else if (kotlinCallArgument instanceof CollectionLiteralKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessCollectionLiteralArgument((CollectionLiteralKotlinCallArgument)argument2, expectedType);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(argument2);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom preprocessLambdaArgument(ConstraintSystemBuilder csBuilder, LambdaKotlinCallArgument argument2, UnwrappedType expectedType, boolean forceResolution) {
        ResolvedLambdaAtom resolvedArgument;
        if (expectedType != null && !forceResolution && csBuilder.isTypeVariable(expectedType)) {
            return new LambdaWithTypeVariableAsExpectedTypeAtom(argument2, expectedType);
        }
        ResolvedLambdaAtom resolvedLambdaAtom = PostponeArgumentsChecksKt.extractLambdaInfoFromFunctionalType(expectedType, argument2);
        if (resolvedLambdaAtom == null) {
            resolvedLambdaAtom = resolvedArgument = PostponeArgumentsChecksKt.extraLambdaInfo(expectedType, argument2, csBuilder);
        }
        if (expectedType != null) {
            SimpleType lambdaType = FunctionTypesKt.createFunctionType(csBuilder.getBuiltIns(), Annotations.Companion.getEMPTY(), resolvedArgument.getReceiver(), resolvedArgument.getParameters(), null, resolvedArgument.getReturnType(), resolvedArgument.isSuspend());
            csBuilder.addSubtypeConstraint(lambdaType, expectedType, new ArgumentConstraintPosition(argument2));
        }
        return resolvedArgument;
    }

    static /* synthetic */ ResolvedAtom preprocessLambdaArgument$default(ConstraintSystemBuilder constraintSystemBuilder, LambdaKotlinCallArgument lambdaKotlinCallArgument, UnwrappedType unwrappedType2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return PostponeArgumentsChecksKt.preprocessLambdaArgument(constraintSystemBuilder, lambdaKotlinCallArgument, unwrappedType2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final ResolvedLambdaAtom extraLambdaInfo(UnwrappedType expectedType, LambdaKotlinCallArgument argument2, ConstraintSystemBuilder csBuilder) {
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType;
        List list2;
        Object object;
        KotlinBuiltIns builtIns = csBuilder.getBuiltIns();
        UnwrappedType unwrappedType2 = expectedType;
        boolean isSuspend = unwrappedType2 != null ? FunctionTypesKt.isSuspendFunctionType(unwrappedType2) : false;
        boolean isFunctionSupertype = expectedType != null && KotlinBuiltIns.isNotNullOrNullableFunctionSupertype(expectedType);
        LambdaKotlinCallArgument $receiver$iv = argument2;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = $receiver$iv;
        if (!(lambdaKotlinCallArgument instanceof FunctionExpression)) {
            lambdaKotlinCallArgument = null;
        }
        FunctionExpression argumentAsFunctionExpression = (FunctionExpression)lambdaKotlinCallArgument;
        TypeVariableForLambdaReturnType typeVariable2 = new TypeVariableForLambdaReturnType(argument2, builtIns, "_L");
        FunctionExpression functionExpression = argumentAsFunctionExpression;
        UnwrappedType receiverType2 = functionExpression != null ? functionExpression.getReceiverType() : null;
        Object object2 = argumentAsFunctionExpression;
        if (object2 == null || (object2 = object2.getReturnType()) == null) {
            Object object3 = expectedType;
            if (object3 != null && (object3 = ((KotlinType)object3).getArguments()) != null && (object3 = (TypeProjection)CollectionsKt.singleOrNull((List)object3)) != null && (object3 = object3.getType()) != null && (object3 = ((KotlinType)object3).unwrap()) != null) {
                Object object4;
                Object it = object4 = object3;
                object2 = isFunctionSupertype ? object4 : null;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null) {
            object = typeVariable2.getDefaultType();
        }
        Object returnType2 = object;
        UnwrappedType[] unwrappedTypeArray = argument2.getParametersTypes();
        if (unwrappedTypeArray != null) {
            void $receiver$iv$iv;
            UnwrappedType[] $receiver$iv2;
            UnwrappedType[] $i$a$1$takeIf = $receiver$iv2 = unwrappedTypeArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv2.length);
            void var14_15 = $receiver$iv$iv;
            int n = ((void)var14_15).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var18_19 = item$iv$iv = var14_15[j];
                Collection collection = destination$iv$iv;
                UnwrappedType unwrappedType3 = it;
                if (unwrappedType3 == null) {
                    SimpleType simpleType2 = builtIns.getNothingType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nothingType");
                    unwrappedType3 = simpleType2;
                }
                void var23_21 = unwrappedType3;
                collection.add(var23_21);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List parameters2 = list2;
        boolean newTypeVariableUsed = Intrinsics.areEqual((Object)returnType2, (Object)typeVariable2.getDefaultType());
        if (newTypeVariableUsed) {
            csBuilder.registerVariable(typeVariable2);
        }
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType2 = typeVariable2;
        Object object5 = returnType2;
        List list3 = parameters2;
        UnwrappedType unwrappedType4 = receiverType2;
        boolean bl = isSuspend;
        LambdaKotlinCallArgument lambdaKotlinCallArgument2 = argument2;
        TypeVariableForLambdaReturnType it = typeVariableForLambdaReturnType2;
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType3 = typeVariableForLambdaReturnType = newTypeVariableUsed ? typeVariableForLambdaReturnType2 : null;
        Object object6 = object5;
        List list4 = list3;
        UnwrappedType unwrappedType5 = unwrappedType4;
        boolean bl2 = bl;
        LambdaKotlinCallArgument lambdaKotlinCallArgument3 = lambdaKotlinCallArgument2;
        return new ResolvedLambdaAtom(lambdaKotlinCallArgument3, bl2, unwrappedType5, list4, (UnwrappedType)object6, typeVariableForLambdaReturnType3);
    }

    private static final ResolvedLambdaAtom extractLambdaInfoFromFunctionalType(UnwrappedType expectedType, LambdaKotlinCallArgument argument2) {
        Object object;
        Object receiverType2;
        FunctionExpression argumentAsFunctionExpression;
        Object object2;
        if (expectedType == null || !FunctionTypesKt.isBuiltinFunctionalType(expectedType)) {
            return null;
        }
        List<UnwrappedType> parameters2 = PostponeArgumentsChecksKt.extractLambdaParameters(expectedType, argument2);
        LambdaKotlinCallArgument $receiver$iv = argument2;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = $receiver$iv;
        if (!(lambdaKotlinCallArgument instanceof FunctionExpression)) {
            lambdaKotlinCallArgument = null;
        }
        if ((object2 = (argumentAsFunctionExpression = (FunctionExpression)lambdaKotlinCallArgument)) == null || (object2 = object2.getReceiverType()) == null) {
            KotlinType kotlinType2 = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedType);
            object2 = receiverType2 = kotlinType2 != null ? kotlinType2.unwrap() : null;
        }
        if ((object = argumentAsFunctionExpression) == null || (object = object.getReturnType()) == null) {
            object = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType).unwrap();
        }
        Object returnType2 = object;
        return new ResolvedLambdaAtom(argument2, FunctionTypesKt.isSuspendFunctionType(expectedType), (UnwrappedType)receiverType2, parameters2, (UnwrappedType)returnType2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UnwrappedType> extractLambdaParameters(UnwrappedType expectedType, LambdaKotlinCallArgument argument2) {
        UnwrappedType[] $receiver$iv;
        UnwrappedType[] parametersTypes = argument2.getParametersTypes();
        List<TypeProjection> expectedParameters = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedType);
        if (parametersTypes == null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            Iterable iterable = $receiver$iv2 = (Iterable)expectedParameters;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                UnwrappedType unwrappedType2 = it.getType().unwrap();
                collection.add(unwrappedType2);
            }
            return (List)destination$iv$iv;
        }
        UnwrappedType[] $receiver$iv$iv = $receiver$iv = parametersTypes;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int index$iv$iv = 0;
        for (UnwrappedType item$iv$iv : $receiver$iv$iv) {
            UnwrappedType unwrappedType3;
            void type2;
            int n = index$iv$iv++;
            UnwrappedType $i$f$map = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            UnwrappedType unwrappedType4 = type2;
            if (unwrappedType4 == null) {
                void index2;
                Object object = (TypeProjection)CollectionsKt.getOrNull(expectedParameters, (int)index2);
                unwrappedType4 = object != null && (object = object.getType()) != null ? ((KotlinType)object).unwrap() : (unwrappedType3 = null);
            }
            if (unwrappedType4 == null) {
                SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(expectedType).getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"expectedType.builtIns.nullableAnyType");
                unwrappedType3 = simpleType2;
            }
            void var18_15 = unwrappedType3;
            collection.add(var18_15);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ResolvedLambdaAtom transformToResolvedLambda(@NotNull LambdaWithTypeVariableAsExpectedTypeAtom $receiver, @NotNull ConstraintSystemBuilder csBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        UnwrappedType fixedExpectedType = csBuilder.buildCurrentSubstitutor().safeSubstitute($receiver.getExpectedType());
        ResolvedAtom resolvedAtom = PostponeArgumentsChecksKt.preprocessLambdaArgument(csBuilder, $receiver.getAtom(), fixedExpectedType, true);
        if (resolvedAtom == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom");
        }
        ResolvedLambdaAtom resolvedLambdaAtom = (ResolvedLambdaAtom)resolvedAtom;
        $receiver.setAnalyzed(resolvedLambdaAtom);
        return resolvedLambdaAtom;
    }

    private static final ResolvedAtom preprocessCallableReference(ConstraintSystemBuilder csBuilder, CallableReferenceKotlinCallArgument argument2, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder) {
        Object v0;
        ResolvedCallableReferenceAtom result2;
        block3: {
            result2 = new ResolvedCallableReferenceAtom(argument2, expectedType);
            if (expectedType == null) {
                return result2;
            }
            Iterable $receiver$iv = csBuilder.getProperSuperTypeConstructors(expectedType);
            for (Object element$iv : $receiver$iv) {
                TypeConstructor it = (TypeConstructor)element$iv;
                if (!(!ReflectionTypes.Companion.isPossibleExpectedCallableType(it))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        TypeConstructor notCallableTypeConstructor = v0;
        if (notCallableTypeConstructor != null) {
            diagnosticsHolder.addDiagnostic(new NotCallableExpectedType(argument2, expectedType, notCallableTypeConstructor));
        }
        return result2;
    }

    private static final ResolvedAtom preprocessCollectionLiteralArgument(CollectionLiteralKotlinCallArgument collectionLiteralArgument, UnwrappedType expectedType) {
        return new ResolvedCollectionLiteralAtom(collectionLiteralArgument, expectedType);
    }
}

